<?php

/**
 * IndexController - The default controller class
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once ('event/models/Events.php');
require_once 'user/models/UserUtil.php';
class Event_IndexController extends Zend_Controller_Action
{
	public function indexAction()
	{
		$this->_redirect('/event/index/view/s/upcoming');
	}

	public function newAction()
	{
		$this->view->form = $this->getForm();
		$this->renderScript('new.phtml');
	}
	public function editAction()
	{
		$event_id = $this->getRequest()->getParam('e_id');
		$event = Event::get($event_id);
		if($event==null)return $this->_redirect("/event");
		$this->view->form = $this->getForm($event);
		$this->view->id = $event_id;
		$this->renderScript('new.phtml');
	}
	public function deleteAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$event_id = $this->getRequest()->getParam('e_id');
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT));
		$event = $table->find($event_id)->current();

		if($event==null)
		{
			$this->_redirect('/event/index');
			return;
		}
		if($event->user_id != Precurio_Session::getCurrentUserId())
		{
			$this->_redirect('/event/index/');
			return;
		}


		$event->active = 0;
		$event->save();

		$event->index();
	}
	public function submitAction()
	{

		$params = $this->getRequest()->getParams();
		if (!$this->getRequest()->isPost())
		{
			$this->_redirect('/event/index');
			return;
		}
		$form = $this->getForm();
		if (!$form->isValid($_POST))
		{
			// Failed validation; redisplay form
			$this->view->form = $form;
			return $this->render('new');
		}
		$values = $form->getValues();

		$values['start_date'] = $values['start_day'].'-'.$values['start_month'].'-'.$values['start_year'];
		$values['end_date'] = $values['end_day'].'-'.$values['end_month'].'-'.$values['end_year'];
		$values['user_id'] = Precurio_Session::getCurrentUserId();
		$start_date = new Precurio_Date($values['start_date'],null,'de');
		$values['start_timestamp'] = $start_date->getTimestamp();
		$values['date_created'] = Precurio_Date::now()->getTimestamp();
		if(empty($values['logo']) && $values['id'])
			unset($values['logo']);
		if(!empty($values['logo']))
			$values['logo'] = "/uploads/".$values['logo'];

		if(empty($values['start_time']))$values['start_time'] = '9am';
		if(empty($values['end_time']))$values['end_time'] = '5pm';

		if(Precurio_Utils::isNull($values['id']))
		{
			$id = Events::createEvent($values);
		}
		else
		{
			$id = $values['id'];
			Events::updateEvent($values);
		}

		if(Precurio_Utils::isNull($values['id']))
		{
		    $this->_redirect('/event');
		}
		$this->_redirect('/event/index/details/e_id/'.$id);
	}
	public function viewAction()
	{
		$params = $this->getRequest()->getParams();
		$currentUser = UserUtil::getUser(Precurio_Session::getCurrentUserId());

		$location_id = empty($params['l_id']) ? null : $params['l_id'];

		if(!isset($params['w']))
			$params['w'] = null;
		$work = $params['w'];

		if(!isset($params['page']))
			$params['cpage'] = 1;

		$events = Events::getEvents($currentUser->getId(),$location_id,$work);

		$this->view->cpage = $params['page'];
		$this->view->events = $events;
		$this->view->w = $work;
		$this->view->l_id = $location_id;
		$this->view->section = $params['s'];
		if($params['s'] == 'calendar')
			$this->renderScript('calendar.phtml');
		else
			$this->renderScript('view.phtml');
	}
	public function detailsAction()
	{
		$event_id = $this->getRequest()->getParam('e_id',$ns->id);

		try
		{
			$event = Event::get($event_id);
			if(empty($event) || !$event->isActive())
				throw new Precurio_Exception(PrecurioStrings::MISSINGCONTENT, Precurio_Exception::EXCEPTION_MISSING_CONTENT);
			if(!$event->canAccess(Precurio_Session::getCurrentUserId()))
				throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
			$this->view->event = $event;
			$user_ids = $event == null ? array() : $event->getInvitees();
		}
		catch(Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
			throw $e;
		}
		$this->renderScript('details.phtml');

	}
	public function statusAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$event_id = $this->getRequest()->getParam('e_id');
		$status = $this->getRequest()->getParam('s');
		$user_id = Precurio_Session::getCurrentUserId();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT_STATUS));
		$e_status = $table->fetchRow($table->select()->where('event_id = ?',$event_id)
												->where('user_id = ?',$user_id));

		if($e_status)
		{
			$e_status->status = $status;
			$e_status->save();
		}
		else
		{
			$data = array('event_id'=>$event_id,'user_id'=>$user_id,'status'=>$status,'date_created'=>Precurio_Date::now()->getTimestamp());
			$row = $table->createRow($data);
			$row->save();

		}
		if($status == Event::ATTENDING)
			echo $this->view->translate(PrecurioStrings::ATTENDINGEVENT);
		if($status == Event::NOTSURE)
			echo $this->view->translate(PrecurioStrings::UNSUREEVENT);
		if($status == Event::NOTATTENDING)
			echo $this->view->translate(PrecurioStrings::NOTATTENDINGEVENT);


	}
	public function newfileAction()
	{
		$this->_helper->layout->disableLayout();

		$event_id = $this->getRequest()->getParam('e_id',0);
		$event = Event::get($event_id);
		if(empty($event))return;

		$folder = $event->getFolder();
		$this->view->folder = $folder;
		$this->renderScript("views/document/new_file.phtml");
	}
	public function inviteesAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$selected_ids = $this->getRequest()->getParam('users');
		$selected_ids = explode(",",$selected_ids);
		$event_id = array_shift($selected_ids);

		$event = Event::get($event_id);
		$event->setInvitees($selected_ids);
	}
	public function inviteuserAction()
	{
		$this->_helper->viewRenderer->setNoRender();
		$params = $this->getRequest()->getParams();
		$event = Event::get($params['event_id']);
		if(!$event)return;
		$event->inviteUser($params["user_id"]);
	}
	/**
	 * New invite action handles both user and group invitation.
	 * 
	 * @version 4.3
	 */
	public function inviteAction()
	{
	    $this->_helper->layout->disableLayout();
	    $this->_helper->viewRenderer->setNoRender();
	    $params = $this->getRequest()->getParams();
	    $event = Event::get($params['id']);
	    if(!$event)return;
	    
	    if($params['type'] == 'user')
	    {
    	    $event->inviteUser($params["item_id"]);
	    }
	    if($params['type'] == 'group')
	    {
	        $group = UserUtil::getGroup($params["item_id"]);
	        $users = $group->getUsers();
	        foreach($users as $user)
	        {
	            $event->inviteUser($user->getId());
	        }
	    }
	}
	public function uninviteuserAction()
	{
		$this->_helper->viewRenderer->setNoRender();
		$params = $this->getRequest()->getParams();
		$event = Event::get($params['event_id']);
		if(!$event)return;
		$event->uninviteUser($params["user_id"]);
	}
	private function getForm($event = null)
	{
		$startDate = $event == null ? Precurio_Date::now()->addDay(1) : $event->getDate(false);
		$endDate = $event == null ? Precurio_Date::now()->addDay(2) : $event->getEndDate(false);
		$userUtil = new UserUtil();
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/event/index/submit')
		->setMethod('post')
		->setAttrib('id','addForm')
		->setAttrib('name','addForm')
		->setAttrib('enctype', 'multipart/form-data');

		$form->addElement('hidden', 'id', array(
				'validators' => array(
				),
				'required' => false,
				'value'=>$event['id'],
		));

		$form->addElement('text', 'title', array(
				'validators' => array(
				),
				'required' => true,
				'class'=>'form-control',
				'value'=>$event['title']
		));
		$form->addElement('text', 'summary', array(
				'validators' => array(
				),
				'required' => false,
				'class'=>'form-control',
				'value'=>$event['summary']
		));
		$form->addElement('text', 'host', array(
				'validators' => array(
				),
				'required' => false,
				'class'=>'form-control',
				'value'=>$event['host']
		));

		$form->addElement('select', 'location_id', array(
				'required' => false,
				'multiOptions'=> Precurio_FormElement::getOptionsArray($userUtil->getLocations(),'id','title'),
				'class'=>'form-control',
				'value'=>$event['location_id']
		));

		$form->addElement('text', 'venue', array(
				'validators' => array(
				),
				'required' => false,
				'class'=>'form-control',
				'value'=>$event['venue']
		));

		$form->addElement('select', 'start_month', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllMonths(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::MONTH_SHORT)
		));
		$form->addElement('select', 'start_day', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllDays(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::DAY)
		));
		$form->addElement('select', 'start_year', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllYears(),'value','label'),
				'value'=>$startDate->get(Precurio_Date::YEAR)
		));

		$form->addElement('select', 'end_month', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllMonths(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::MONTH_SHORT)
		));
		$form->addElement('select', 'end_day', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllDays(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::DAY)
		));
		$form->addElement('select', 'end_year', array(
				'required' => true,
				'class' => 'oneThirdSelect form-control',
				'multiOptions'=> Precurio_FormElement::getOptionsArray(Precurio_Date::getAllYears(),'value','label'),
				'value'=>$endDate->get(Precurio_Date::YEAR)
		));
		$form->addElement('text', 'start_time', array(
				'validators' => array(
				),
				'required' => false,
				'class'=>'form-control',
				'placeholder'=>'9am',
				'value'=>$event['start_time']
		));
		$form->addElement('text', 'end_time', array(
				'validators' => array(
				),
				'required' => false,
				'class'=>'form-control',
				'placeholder'=>'5pm',
				'value'=>$event['end_time']
		));
		$form->addElement('textarea', 'description', array(
				'validators' => array(
				),
				'filters'=>array(
				),
				'rows'=>7,
				'class'=>'form-control',
				'required' => false,
				'value'=>$event['description']
		));
		$is_open = new Zend_Form_Element_Select('is_open');
		$is_open->addMultiOption(1,'Yes');
		$is_open->addMultiOption(0,'No, Invitation Only');
		$is_open->setAttrib("class", "form-control");
		$is_open->setValue($event == null ? 0 : $event['is_open']);
		//$is_open->setAttrib('class','oneThirdSelect');
		$form->addElement($is_open);

		$work_related = new Zend_Form_Element_Select('work_related');
		$work_related->addMultiOption(1,'Yes');
		$work_related->addMultiOption(0,'No, Personal');
		$work_related->setAttrib("class", "form-control");
		$work_related->setValue($event == null ? 1 : $event['work_related']);
		//$work_related->setAttrib('class','oneThirdSelect');
		$form->addElement($work_related);

		$form->addElement('checkbox', 'restrict_content_access', array(
				'validators' => array(
				),
				'required' => true,
				'value'=>$event['restrict_content_access']
		));
		$form->addElement('checkbox', 'disable_content_access', array(
				'validators' => array(
				),
				'required' => true,
				'value'=>$event['disable_content_access']
		));
		$form->addElement('checkbox', 'open_guest_list', array(
				'validators' => array(
				),
				'required' => true,
				'value'=>$event['open_guest_list']
		));



		$form->setElementDecorators(array('ViewHelper','FormElements','Errors'));


		$logo = new Zend_Form_Element_File('logo');
		$root = Zend_Registry::get('root');
		$logo->setDestination($root.'/public/uploads/')
		->addValidator('Count', false, 1) // ensure only 1 file
		->addValidator('Size', false, 4096000) // limit to 4MB
		->addValidator('Extension' ,false, 'jpg,png,gif'); // only JPEG, PNG, and GIFs
		$logo->removeDecorator('HtmlTag');
		$logo->removeDecorator('Label');
		$logo->setValue($event['logo']);
		$logo->setAttrib('class', 'form-control');
		$form->addElement($logo);


		$form->addElement('submit', 'submit', array(
				'class'=>'standout',
				'label'=>$this->view->translate('Submit'),
		));
		return $form;
	}
	public function exportAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$event_id = $this->getRequest()->getParam('e_id');
		$event = Event::get($event_id);
		if($event==null)return $this->_redirect("/event");

		$iCal = $event->export();
		$filename = $event->getTitle().".ics";
		$this->getResponse()->setHeader('Content-Description','File Transfer');
		$this->getResponse()->setHeader('Content-Disposition',"attachment; filename=$filename");
		$this->getResponse()->setHeader('Content-Type','text/calendar');
		$this->getResponse()->setHeader('Content-Transfer-Encoding','binary');
		echo $iCal;
	}
	public function searchdataAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$tr = Zend_Registry::get('Zend_Translate');
		$label = $tr->translate("Start Date - {1}.");

		$events = Events::getEvents(Precurio_Session::getCurrentUserId());

		$results = array();
		foreach($events as $item)
		{
			$obj = new stdClass();
			$obj->id  = $item->getId();
			$obj->title = $item->getTitle();
			$obj->label = getLocalizedString($label,$item->getDate());
			$obj->url = $item->getUrl();
			$results[] = $obj;
		}
		echo json_encode($results);
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_C);
		$this->view->page = 'upcoming';
		$ns = new Zend_Session_Namespace('temp');
		$ns->page = 'upcoming';//content controller needs this and partial_event
	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/event');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/event');
	}

}
