<?php
/**
 *
 * @author brain
 * @version
 */
require_once 'Zend/View/Interface.php';
/**
 * DocumentView helper
 *
 * @uses viewHelper Document_View_Helper
 */
class Document_View_Helper_DocumentView
{
    /**
     * @var Zend_View_Interface
     */
    public $view;

    public function documentView ()
    {
        return $this;
    }
    /**
     * Sets the view field
     * @param $view Zend_View_Interface
     */
    public function setView (Zend_View_Interface $view)
    {
        $this->view = $view;
    }
	public function getProgressColor($score)
	{
		switch ($score)
		{
			case $score >= 90:
				return 'red';
			case $score >= 80:
				return 'orange';
			case $score >= 10:
				return '#A9F755';
			default:
				return '#A6CFFE';
		}
	}


	/**
	 * Returns the complete download link for a document.
	 * @param int $document_id - ID of the document
	 * @param string $version - version of the document
	 * @param boolean $hrefOnly - If you want to return the link only, without the html attributes. Default is false.
	 * @return string
	 */
	public function getDownloadLink($document_id,$version="0",$hrefOnly=false)
	{
		$view = $this->view;
		$document = Document::getVersion($document_id,$version);
		if($document->isPassworded())
			$str = 'rel="facebox" href="'.$view->baseUrl().'/document/index/passworded/access/download/id/'.$document->getId().'/v/'.$version.'"';
		else
		{
			if($hrefOnly)
				$str =  $view->baseUrl().'/document/index/download/c_id/'.$document->getContentId().'/v/'.$version;
			else
				$str =  'target="_blank" href="'.$view->baseUrl().'/document/index/download/c_id/'.$document->getContentId().'/v/'.$version.'"';
		}
		return $str;
	}
}
