<?php
require_once ('document/models/vo/Folder.php');
class RootFolder extends Folder
{
	const SPECIAL_ID_PUBLIC = -1;
	const SPECIAL_ID_PRIVATE = -2;
	const SPECIAL_ID_SHARED = -3;
	/* constant SPECIAL_ID_HELPDESK is deprecated.
	 * But it is important not to delete it because the
	 * document manager module makes use of it to determine
	 * which folders belong to other modules
	 */
	const SPECIAL_ID_HELPDESK = -8;//leave enough space between -3 and -8 for other things document manager related.
	const SPECIAL_ID_EVENT = -9;
	const SPECIAL_ID_WORKFLOW = -11;
	const SPECIAL_ID_TASK = -12;
	const SPECIAL_ID_DISCUSSION = -13;
	public function __construct($access_type = Category::ACCESS_PRIVATE)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		$this->_data = array(
		'id'=>0,
		'user_id'=>0,
		'parent_id'=>self::SPECIAL_ID_PRIVATE,
		'title'=>$tr->translate('All Files and Folders'),
		'description'=>'',
		'access_type'=>$access_type,
		'special_id'=>self::getSpecialIdFromAccessType($access_type)
		);
		return $this;
	}
	public function getUrl()
	{
		return '/document';
	}
	/**
	 * Returns the sub-categorys of a root folder
	 * @param boolean $recursive |default true| - IGNORED
	 * @param int $category_id |default 0| - IGNORED
	 * @return array
	 */
	public function getCategoryChildren($recursive = true,$category_id=0)
	{

		$user_id = Precurio_Session::getCurrentUserId();
		$result = array();
		//get all public categorys
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'Folder'));
		$items = $table->fetchAll($table->select()->where('active=1')->where('parent_id = 0')
				->where('is_folder = 1')->where('is_site = 0')->where('access_type = ?',self::ACCESS_PUBLIC)->order('title asc'));
		foreach($items as $category)
		{
			$result[$category->id] = $category;
		}

		//get all root categories owned by user.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'Folder'));
		$items = $table->fetchAll($table->select()->where('active=1')->where('parent_id = 0')
				->where('is_folder = 1')->where('is_site = 0')->where('user_id = ?',$user_id)->order('title asc'));
		foreach($items as $category)
		{
			$result[$category->id] = $category;
		}


		//Get categories shared with user's groups
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
						->join(array('b' => PrecurioTableConstants::GROUP_CATEGORYS),'a.id = b.category_id',array('sharer_id'=>'user_id'))
						->join(array('c' => PrecurioTableConstants::USER_GROUPS),'b.group_id = c.group_id',array())
						->where('a.active = 1')
						->where('b.active = 1')
						->where('a.parent_id = 0')
						->where('a.is_folder = 1')
						->where('a.is_site = 0')
						->where('c.user_id = ?',$user_id);
		$groupShared = $table->fetchAll($select);
		foreach($groupShared as $category)
		{
			$result[$category->id] = $category;//using $result[$t->id] solves the issue of duplicate category, since  already existing categorys will replace themselves
		}

		//Get categories shared with user
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
						->join(array('b' => PrecurioTableConstants::SHARED_CATEGORYS),'a.id = b.category_id',array('sharer_id'))
						->where('a.active = 1')
						->where('b.active = 1')
						->where('a.parent_id = 0')
						->where('a.is_folder = 1')
						->where('a.is_site = 0')
						->where('b.user_id = ?',$user_id);
		$userShared = $table->fetchAll($select);
		foreach($userShared as $category)
		{
			$result[$category->id] = $category;//using $result[$t->id] solves the issue of duplicate category, since  already existing categorys will replace themselves
		}

		return $result;
	}

	/**
	 * Returns the documents of a root folder
	 * @param boolean $recursive |default true| - IGNORED
	 * @param int $category_id |default 0| - IGNORED
	 * @return array
	 */
	public function getContentChildren($recursive = true)
	{

		$user_id = Precurio_Session::getCurrentUserId();
		$result = array();
		
		//get all root documents owned by user. (Root documents uploaded by user are always private)
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
		->join(array('c' => PrecurioTableConstants::CONTENT_CATEGORYS),'a.id = c.content_id',array())
		->where('a.user_id = ?',$user_id)
		->where('c.category_id = ?' ,Category::ACCESS_PRIVATE)
		->order('b.last_modified desc');

		$rows = $table->fetchAll($select);

		foreach($rows as $document)//get contents Zend_Db_Table_RowSet into array , by looping.
		{
			$result[$document->id] = $document;//using $contents[$t->id] instead of  solves the issue of duplicate contents, since  already existing contents will replace themselves
		}

		//get all root documents shared with user
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
		->join(array('c' => PrecurioTableConstants::CONTENT_CATEGORYS),'a.id = c.content_id',array())
		->join(array('d' => PrecurioTableConstants::SHARED_CONTENTS),'a.id = d.content_id',array())
		->where('d.user_id = ?',$user_id)
		->where('c.category_id <=0')
		->where('c.category_id > ?',RootFolder::SPECIAL_ID_HELPDESK)
		->order('b.last_modified desc');

		$rows = $table->fetchAll($select);

		foreach($rows as $document)
		{
			$result[$document->id] = $document;
		}
		return $result;
	}

	public function addContents($content_ids,$access_type = Category::ACCESS_PRIVATE)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		if(!is_array($content_ids))$content_ids = array($content_ids);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		foreach($content_ids as $content_id)
		{
			$table->insert(array(
					'category_id'=>$this->special_id,
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1
			));
		}

		return;
	}
	public function getGroups()
	{
		return array();//a rootfolder isnt shared with any group. Except ofcourse TeamRootFolder :) See team/models/vo/TeamRoomFolder.php
	}
	/**
	 * Reverse of getAccessTypeFromSpecialId
	 * @see getAccessTypeFromSpecialId()
	 * @param int $access_type
	 * @return number
	 */
	public static function getSpecialIdFromAccessType($access_type)
	{
		switch($access_type)
		{
			case Category::ACCESS_PUBLIC:
				return self::SPECIAL_ID_PUBLIC;
			case Category::ACCESS_PRIVATE:
				return self::SPECIAL_ID_PRIVATE;
			case Category::ACCESS_SHARED:
				return self::SPECIAL_ID_SHARED;
			default://some weird programming error.
				return 0;
		}
	}
	/**
	 * Get access type from a special ID. This special id refers to a specific
	 * root folder, since the only thing different about root folders is their access types.
	 * For a better understanding of why we did this, @see /document/views/scripts/category/move.phtml
	 * @param unknown_type $id
	 * @return number|string
	 */
	public static function getAccessTypeFromSpecialId($id)
	{
		switch($id)
		{
			case self::SPECIAL_ID_PUBLIC:
				return Category::ACCESS_PUBLIC;
			case self::SPECIAL_ID_PRIVATE:
				return Category::ACCESS_PRIVATE;
			case self::SPECIAL_ID_SHARED:
				return Category::ACCESS_SHARED;
			default://some weird programming error.
				return Folder::get($id)->access_type;
		}
	}
	public function isLocked()
	{
		return false;
	}
}
?>