<?php
require_once ('Zend/Session/Namespace.php');
require_once ('document/models/Folders.php');
class FolderHistory extends Zend_Session_Namespace
{
	const BROWSE_HISTORY = 'Folder_History';//used in Zend Registory to store History object
	public function __construct()
	{
		try
		{
			parent::__construct(Precurio_Session::NAMESPACE_DOCUMENT,true);
		}
		catch (Zend_Session_Exception $e)
    	{
    		if(Zend_Registry::isRegistered(self::BROWSE_HISTORY))
    		{
    			return Zend_Registry::get(FolderHistory::BROWSE_HISTORY);
    		}
    	}

		//$this->history = array();
		Zend_Registry::set(FolderHistory::BROWSE_HISTORY,$this);
	}
	/**
	 * @param int $id
	 * @param boolean $buildPath -  If you want to auto build path to folder. Default is false
	 */
	public function add($id,$buildPath = false)
	{
		if($id <=0) $this->clear();//once you access a root folder, clear the history.
		if($buildPath)
		{
			$this->buildPath($id);
			return;
		}
		$i = array_search($id,$this->history);

		if($i === FALSE)//not there
		{
			$temp = $this->history;
			$temp[] = $id;
			$this->history = $temp;
		}
		else//item alread exists in history. This means the user clicked on the history item
		{
			$this->history = array_slice($this->history, 0,($i+1));
		}
	}
	public function getAll()
	{
		return $this->history;
	}
	public function clear()
	{
		$this->history = array();
	}
	/**
	 * This will determine the path to a particular folder.
	 * Function is used when user gets to a folder without transversing through the
	 * directory.I.e. the user gets in directly through some other means.
	 * This function helps build folder path navigation.
	 * @param int $id - primary key of folder (cateory)
	 */
	private function buildPath($id)
	{
		$this->clear();//clear existing history
		$temp = $this->history;
		if($id < 0)//special id. A root folder.
		{
			array_unshift($temp,$id);
			$this->history = $temp;
			return;
		}
		$folder = Folder::get($id);
		$parent_id  = $folder->parent_id;
		while($parent_id > 0)
		{
			array_unshift($temp, $parent_id);
			$parent = Folder::get($parent_id);
			if($parent == null)
			{
				$parent_id = 0;//loop will now end.
			}
			else
			{
				$folder = $parent;
				$parent_id  = $folder->parent_id;
			}
		}
		$access_type = $folder->access_type;
		array_unshift($temp, RootFolder::getSpecialIdFromAccessType($access_type));
		$this->history = $temp;
	}
	/**
	 * Returns the most recent item in the history
	 * @return Folder
	 */
	public function getMostRecent()
	{
		$item = $this->history[count($this->history) - 1];
        if ($item < 0)
        {
            $id = RootFolder::getAccessStr(RootFolder::getAccessTypeFromSpecialId($item));
            $folder = new RootFolder(RootFolder::getAccessTypeFromSpecialId($item));
        }
        elseif(empty($item))
        {
        	$folder = new RootFolder();
        }
        else
        {
            $folder = Folder::get($item);
            $id = $item;
        }
		return $folder;
	}
	/**
	 * @return Ambigous <FolderHistory, mixed>
	 */
	public static function get()
	{
		if(Zend_Registry::isRegistered(FolderHistory::BROWSE_HISTORY))
		{
			$history = Zend_Registry::get(FolderHistory::BROWSE_HISTORY);
		}
		else
		{
			$history = new FolderHistory();
			if(!isset($history->history))
				$history->history = array();
			Zend_Registry::set(FolderHistory::BROWSE_HISTORY,$history);
		}
		return $history;
	}
}
?>