<?php
require_once 'cms/models/vo/Category.php';
class DiscussionCategory extends Category {

	/**
	 * Get all user discussion categories (with option for pagination)
	 * @param int $user_id
     * @param $limit - int - Number of records per page.Works with $page.
	 * @param $page - int - Set page number if you want to paginate result.
	 * @param $count - int  - Total number of discussions (before pagination) is stored in this variable
	 * @version 4
	 * @return array
	 */
	public static function getAll($user_id = 0,$limit=0,$page=1,&$count=0)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'DiscussionCategory'));

		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
			->joinLeft(array('b' => PrecurioTableConstants::DISCUSSIONS),'a.id = b.category_id',array('last_updated'))
			->where('a.active = 1')->where('a.is_folder = 0')->where('a.appid = ?',Discussion::APPID)
			->order('b.last_updated DESC')
			->order('a.date_created DESC');

		$rows = $table->fetchAll($select);
		//remove duplicates
		$result = array();
		foreach($rows as $row)
		{
			if($user_id && !$row->canAccess($user_id))continue;
			$result[$row->id] = $row;
		}
		$count = count($result);
		if($limit)
		{
		    $offset = ($page - 1) * $limit;
		    $result = array_slice($result, $offset,$limit);
		}
		return $result;
	}
	/**
	 * Get the most recent discussion
	 * @return Discussion
	 */
	public function getLastDiscussion()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'Discussion'));
		$row = $table->fetchRow($table->select()->where('category_id = ?',$this->getId())->where('active = 1')->order('last_updated DESC'));
		return $row;
	}
	public function getNumberOfChildren()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'Discussion'));
		return $table->fetchAll($table->select()->where('category_id = ?',$this->getId())->where('active = 1'))->count();

	}
	public function getUrl()
	{
		return "/discussion/category/view/id/".$this->getId();
	}
	public function do_delete()
	{
		//first delete category discussions
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS));
		$table->update(array('active'=>0), "category_id = ".$this->id);

		//then delete  category
		$this->active = 0;
		$this->save();

	}
	/**
	 * @param int $id id of category
	 * @return DiscussionCategory
	 */
	public static function get($id)
	{
		if($id == 0)
			return new RootDiscussionCategory();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'DiscussionCategory'));
		$item = $table->fetchRow($table->select()->where('id = ?',$id));
		return $item;
	}

	public function canAccess($user_id)
	{
		if($this->user_id == $user_id)return true;//category creator can access
		if($this->isPublic())return true;

		$groups = $this->getGroups();
		foreach($groups as $group)
		{
			if($group->containsMember($user_id))return true;
		}
		return false;
	}
	public function getDiscussions()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'Discussion'));
		$rows = $table->fetchAll($table->select()->where('active = 1')->where('category_id = ?',$this->getId())->order("last_updated DESC"));
		return $rows;
	}
	/**
	 * Gets all contributors to the category starting with the most contributions.
	 * Returns an array in the form [userid1=>count,userid2=>count,userid3=>count,....]
	 *
	 * @return array
	 */
	public function getContributors()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS,'rowClass'=>'Comment'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::COMMENTS))
		->joinLeft(array('b' =>PrecurioTableConstants::DISCUSSIONS),'a.item_id = b.id',array('category_id'))
		->where('a.active = 1 AND b.active = 1')
		->where("b.category_id = ?",$this->getId())
		->where("a.appid = ?",Discussion::APPID);

		$rows = $table->fetchAll($select);
		$result = array();

		foreach ($rows as $row)
		{
			if(!isset($result[$row->user_id]))$result[$row->user_id] = 0;

			++$result[$row->user_id];
		}
		arsort($result);

		return $result;
	}
}
class RootDiscussionCategory extends DiscussionCategory
{
	public function getId()
	{
		return 0;
	}
	public function init()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		$this->_data = array(
			'id'=>"0",
			'title'=>$tr->translate('Internal Discussions'),
			'user_id'=>Precurio_Session::getCurrentUserId(),
			'parent_id'=>0,
			'access_type'=>0,		
			'date_created'=>time()			
		);
	}
}

?>