<?php

/**
 * LoginController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once ('user/models/UserUtil.php');
require_once ('user/models/vo/UserActivity.php');
require_once ('user/models/vo/UserCode.php');
class LoginController extends Zend_Controller_Action {
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
		$this->_forward('login');
	}
	public function preDispatch()
	{
		$this->_helper->viewRenderer->setNoRender();
		$this->_helper->layout->disableLayout();
	}
	public function loginAction()
	{
		$config = Zend_Registry::get('config');

		try
		{
			$db = Zend_Registry::get('db');
			$db->getConnection();//force a database connection test.
		}
		catch (Zend_Db_Exception $e)//i.e there was a problem connecting to the database
		{
			//if it is a new installation
			if(Precurio_Utils::isNewInstallation())
			{
				$this->_redirect('/install/');
			}
			throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
		}


		try
		{
		    
		    //if single sign on is enabled, get windows user and sign on.
		    if(!empty($config->enable_sso))
		    {
		        if($_SERVER['REMOTE_USER'])
		        {
    		        $cred = explode('\\',$_SERVER['REMOTE_USER']);
    		        if (count($cred) == 1) array_unshift($cred, false);
    		        list($domain, $username) = $cred;
    		        try 
    		        {
        		        //validate the user with active directory. SSO must be used with Active directory
        		        $auth = $this->_helper->getHelper('LdapAuth');
        		        $auth->validate($username,'ldap_password'.$username,true);//this method will create the user if it does not exist
    		        
        		        Precurio_Session::setCurrentUser($auth->getUser());
    		            $this->_redirect('/default/index/home');
    		        }
		           catch (Exception $e)//i.e there was a problem validating SSO
            		{
            			//simply do nothing and continue execution
            		}
		        }
		    }
		    
			$user_id = Precurio_Session::getCurrentUserId();
			$user = UserUtil::getUser($user_id);
			if($user->isAnonymous())
			{
				Precurio_Session::logOut();
				throw new Precurio_Exception($this->view->translate(PrecurioStrings::SESSIONEXPIRED),Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
			}
			if($user->getPercentageComplete() <= 40 && $config->force_profile_complete)
			{
				$this->_redirect('/user/profile/edit');
			}
			else
			{
				$this->_redirect('/default/index/home');
			}
		}
		//if this exception is not caught, it propogates to the ErrorController, in this
		//situation, we dont want that.
		catch (Precurio_Exception $e)//i.e there was a problem retrieving the session user
		{
			//simply do nothing and continue execution
		}
		$this->_helper->layout->setLayout('login');
		$this->view->form = 'login';
	}
	public function submitAction()
	{
		$this->_helper->layout->setLayout('login');
		$params = $this->getRequest()->getParams();
		if(!isset($params['username']))
		{
			$ns = new Zend_Session_Namespace(Precurio_Session::NAMESPACE_USER);
			if(!isset($ns->currentUser))//throw a re-login error because session has expired
			{
				throw new Precurio_Exception($this->view->translate(PrecurioStrings::SESSIONEXPIRED),Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
			}

			$user = $ns->currentUser;
			$params['username'] = $user->identity;
			$params['password'] = $user->credential;
		}

		$config = Zend_Registry::get('config');

		$auth = $this->_helper->getHelper($config->auth_mech);
		try
		{
			$this->view->isValid = $auth->validate($params['username'],$params['password']);
		}
		catch(Zend_Auth_Adapter_Exception  $err)
		{
			Precurio_Exception::dispatchError($err,$this->getRequest());
		}
		if($auth->getCode() != Zend_Auth_Result::SUCCESS)
		{

			$this->view->loginError = $auth->getErrorMessage();
		}
		else
		{
			$login = $auth->getUser();
			$user_id = $login->id;
			$user = UserUtil::getUser($user_id);
			$isExtranet = $user->isExternal();

			$ns = new Zend_Session_Namespace(($isExtranet ? Precurio_Session::NAMESPACE_EXTRANET : Precurio_Session::NAMESPACE_USER));
			Precurio_Session::setCurrentUser($auth->getUser(),$isExtranet);
			if(isset($ns->lastRequest))
			{
				$uri = unserialize($ns->lastRequest);

				$baseUrl = $this->getRequest()->getBaseUrl();
				if($baseUrl != "")
				{
					$uri = substr($uri,strlen($baseUrl));
				}
				$log = Zend_Registry::get('log');
				$log->info($uri);

				return $this->_redirect($uri);
			}
			else
			{
				if($user->getPercentageComplete() <= 40 && $config->force_profile_complete)
				{
					$this->_redirect(($isExtranet ? '/extranet/user' : '/user/profile/edit'));
				}
				else
				{
					$this->_redirect(($isExtranet ? '/extranet/user' : '/default/index/home'));
				}
			}
		}
	}
	public function forgotAction()
	{
		$this->_helper->layout->setLayout('login');
		$this->view->form = 'forgot';
		$params = $this->getRequest()->getPost();
		if(count($params))
		{
			$this->view->submited = true;
			$email = $params['id'];
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
			$row = $table->fetchRow($table->select()->where('identity = ?',$email));
			if(empty($row))//no user with that email.
			{
				$this->view->error = true;
				return false;
			}

			$this->sendResetLink($row->id,$email);
		}

	}
	private function sendResetLink($user_id,$email)
	{
		//first create this activity
		$activity_id = Precurio_Activity::create(User::APPID, User::ACTIVITY_FORGOT_PASSWORD, $user_id, $user_id,null,-2);
		if(empty($activity_id))return;
		$activity = UserActivity::get($activity_id);

		//get a code
		$code = UserCode::generate($user_id, $activity);

		$config = Zend_Registry::get('config');
		$baseUrl = $config->base_url;

		$format = Precurio_Activity::getMessageFormat($activity,'mail');
		$resetUrl = $baseUrl.'/default/login/reset/id/'.$code;
		$user = UserUtil::getUser($user_id);
		$body = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$resetUrl,"",$user_id,0,$baseUrl,"","");

		$mail = new Precurio_Mail();
		$mail->sendData(array(
				'to'=>$email,
				'subject'=>$activity->getMailSubject(),
				'body'=>$body,
				'activity_id'=>$activity->getId()
		));
	}
	public function resetAction()
	{
		$this->_helper->layout->setLayout('login');
		$this->view->form = 'reset';

		$code = $this->getParam('id',0);
		if(empty($code))
		{
			$this->_redirect("/default/login/login");
			return;//link was accessed by user
		}

		$userCode = UserCode::getCode($code);

		if(empty($userCode))
		{
			$this->_redirect("/default/login/login");
			return;//link was accessed by user
		}
		if($userCode->isExpired())
		{
			$this->view->error = "The reset link has expired.";
			return;//link was accessed by user
		}

		$user = $userCode->getUser();

		$lastActivity = $user->getLastActivity();

		if($lastActivity->getId() != $userCode->activity_id)//user has performed an activity since requesting for password reset
		{
			$this->view->error = "This link is no more valid.";
			return;//link was accessed by user
		}

		$this->view->email = $user->getFullName();
		$this->view->id = $code;
	}
	public function registerAction()
	{
		$this->_helper->layout->setLayout('login');
		$config = Zend_Registry::get('config');

		if(!$config->enable_user_registration)
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		$this->view->form = 'register';
	}
	public function submitregisterAction()
	{
		/*
		 * This is a security breach!!!!!
		 * @todo: Think of a more secure way to implement user registration
		 */

		$params = $this->getRequest()->getPost();
		$email = $params['email'];

		$config = Zend_Registry::get('config');

		if(!$config->enable_user_registration)
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_NO_ACCESS);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$email));
		if(!empty($row))
		{
			return false;
		}
		$params['credential'] = $params['password1'];
		$params['identity'] = $params['email'];
		$user_id = UserUtil::createUser($params);
		$this->_redirect('/default/login/login');
	}

	public function submitresetAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$userCode = UserCode::getCode($params['id']);

		if(empty($userCode) || empty($params['password']))
		{
			echo "Invalid link.";
			return;//link was accessed by user
		}
		if($userCode->isExpired())
		{
			echo "The reset link has expired.";
			return;//link was accessed by user
		}

		$user = $userCode->getUser();
		$user->updatePassword($params['password']);
		echo($this->view->translate('You have successfully changed your password'));
		return;
	}

	public function logoutAction()
	{
		Precurio_Session::logOut();
		return $this->_redirect('/default/login');
	}
}
?>