<?php
/**
 *
 * @author Brain
 * @version
 */
require_once 'Zend/View/Interface.php';
require_once ('cms/models/MyContents.php');
require_once ('cms/models/SuggestedContents.php');
require_once ('cms/models/vo/Fact.php');
/**
 * ContentViews helper
 *
 * @uses viewHelper Cms_View_Helper
 */
class Cms_View_Helper_ContentView {
	public $translate;
	/**
	 * @var MyContents
	 */
	private $_myContent;
	/**
	 * @var Zend_View_Interface
	 */
	public $view;

	/**
	 *
	 */
	public function contentView() {
		$this->_myContent = new MyContents();
		$registry = Zend_Registry::getInstance();
		$this->translate = $registry->get('Zend_Translate');
		return $this;
	}
	public function getCompanyLinks()
	{
		return $this->_myContent->getLinks();
	}
	public function getCompanyFact()
	{
		$facts = $this->_myContent->getFacts();
		if($facts->count() < 1)return null;
		$i = rand(1,$facts->count());
		return $facts->getRow($i-1);
	}
	public function getSuggestedContents()
	{
		$suggested = new SuggestedContents();
		return $suggested->contents;
	}
	public function getMostRecent($num=5)
	{
		$suggested = new SuggestedContents();
		return $suggested->getMostRecent($num);
	}
	public function getMostCommented($num = 5)
	{
		$suggested = new SuggestedContents();
		return $suggested->getMostDiscussed($num);
	}
	public function getMostRead($num=5)
	{
		$suggested = new SuggestedContents();
		return $suggested->getMostRead($num);
	}
	/**
	 * Returns the path to an image thumbnail
	 * @param Content $content
	 * @return string
	 */
	public function getThumbnail($content)
	{
		$root = Zend_Registry::get('root');
		$thumb = $content->getImagePath(Content::WIDTH_THUMBNAIL);
		if(is_file( $root.'/public/'.$thumb))
		{
			$thumb = $this->view->baseUrl().$thumb;
		}
		else
		{
			$thumb = $content->getImageFromContent();
			if(empty( $thumb))
			{
				$thumb = $this->view->baseUrl().'/library/themes/'.$this->view->theme.'/css/upload/placeholder_content.png';
			}
		}
		return $thumb;
	}
	/**
	 * Sets the view field
	 * @param $view Zend_View_Interface
	 */
	public function setView(Zend_View_Interface $view) {
		$this->view = $view;
	}
	public function translate($str)
	{
		return $this->translate->translate($str);
	}
}
