<?php

/**
 * @author brain
 * Class for Deparmental or Group Site
 */
class Site extends Zend_Db_Table_Row_Abstract {

	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getDescription()
	{
		return $this->description;
	}
	/**
	 * Get site announcements
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getAnnouncements()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT))
		->join(array('b' => PrecurioTableConstants::SITE_CONTENTS),'a.id = b.content_id',array())
		->where('b.site_id = ?',$this->getId())
		->where('a.active=1')
		->where('b.active=1')
		->order('a.last_updated desc');

		return $table->fetchAll($select);
	}
	/**
	 * Alias to getAnnouncements() since all site contents are basically announcements
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getContents()
	{
		return $this->getAnnouncements();
	}
	/**
	 * Get all pages
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getPages()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES,'rowClass'=>'Page'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::PAGES))
		->join(array('b' => PrecurioTableConstants::SITE_PAGES),'a.id = b.page_id',array())
		->where('b.site_id = ?',$this->getId())
		->where('a.active=1')
		->where('b.active=1');
		return $table->fetchAll($select);
	}
	/**
	 * Get all site links
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getLinks()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS,'rowClass'=>'Link'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::LINKS))
		->join(array('b' => PrecurioTableConstants::SITE_LINKS),'a.id = b.link_id',array())
		->where('b.site_id = ?',$this->getId())
		->where('a.active=1')
		->where('b.active=1');
		return $table->fetchAll($select);
	}
	public function getDocuments()
	{
		$category = Folder::get($this->resource_folder_id);
		if(empty($category))return array();
		return $category->getChildren();
	}
	public function getAlbums()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'Category'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
		->join(array('b' => PrecurioTableConstants::SITE_CATEGORYS),'a.id = b.category_id',array())
		->where('b.site_id = ?',$this->getId())
		->where('a.active=1')
		->where('a.is_folder=1')
		->where('a.is_photo=1')
		->where('b.active=1');
		return $table->fetchAll($select);
	}
	/**
	 * Get all site content categorys (this method is not yet in use (implemented for future use))
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getCategorys()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'Category'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
		->join(array('b' => PrecurioTableConstants::SITE_CATEGORYS),'a.id = b.category_id',array())
		->where('b.site_id = ?',$this->getId())
		->where('a.active=1')
		->where('a.is_folder=0')
		->where('a.is_photo=0')
		->where('b.active=1');
		return $table->fetchAll($select);
	}
	public function getPhotos()
	{

	}
	public function getWelcomePage()
	{
		return Page::get($this->welcome_page_id);
	}
	/**
	 * Determines if a site is now publicly available
	 * @return boolean
	 */
	public function published()
	{
		return $this->publish;
	}
	public function active()
	{
		return $this->active;
	}
	public function isAdmin($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_ADMINS));
		$row = $table->fetchRow($table->select()->where('site_id = ?',$this->getId())->where('user_id = ?',$user_id)->where('active = 1'));
		return !empty($row);
	}
	public function setAdmins($user_ids)
	{
		if(empty($user_ids))$user_ids = array();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_ADMINS));
		$table->update(array("active"=>0), "site_id = ".$this->getId());
		$time = Zend_Date::now()->getTimestamp();
		foreach($user_ids as $user_id)
		{
			$table->insert(array(
					'user_id'=>$user_id,'site_id'=>$this->getId(),'active'=>1,'date_created'=>$time
				));
		}
	}
	/**
	 * Add a content to the site
	 * @param int $content_id
	 */
	public function addContent($content_id)
	{
		if($this->hasContent($content_id))return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_CONTENTS));
		$table->insert(array(
				'content_id'=>$content_id,'site_id'=>$this->getId(),'active'=>1,'date_created'=>Zend_Date::now()->getTimestamp()
		));
	}
	/**
	 * @param int $content_id
	 * @return boolean
	 */
	public function hasContent($content_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_CONTENTS));
		$row = $table->fetchRow($table->select()->where('site_id = ?',$this->getId())->where('content_id = ?',$content_id)->where('active = 1'));
		return !empty($row);
	}
	/**
	 * Add a page to the site
	 * @param int $page_id
	 */
	public function addPage($page_id)
	{
		if($this->hasPage($page_id))return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_PAGES));
		$table->insert(array(
				'page_id'=>$page_id,'site_id'=>$this->getId(),'active'=>1,'date_created'=>Zend_Date::now()->getTimestamp()
		));
	}
	/**
	 * @param int $page_id
	 * @return boolean
	 */
	public function hasPage($page_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_PAGES));
		$row = $table->fetchRow($table->select()->where('site_id = ?',$this->getId())->where('page_id = ?',$page_id)->where('active = 1'));
		return !empty($row);
	}
	/**
	 * Add a category to the site (this could either be a content category or an album
	 * @param int $category_id
	 */
	public function addCategory($category_id)
	{
		if($this->hasCategory($category_id))return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_CATEGORYS));
		$table->insert(array(
				'category_id'=>$category_id,'site_id'=>$this->getId(),'active'=>1,'date_created'=>Zend_Date::now()->getTimestamp()
		));
	}
	/**
	 * @param int $category_id
	 * @return boolean
	 */
	public function hasCategory($category_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_CATEGORYS));
		$row = $table->fetchRow($table->select()->where('site_id = ?',$this->getId())->where('category_id = ?',$category_id)->where('active = 1'));
		return !empty($row);
	}
	/**
	 * Add a link to the site
	 * @param int $link_id
	 */
	public function addLink($link_id)
	{
		if($this->hasLink($link_id))return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_LINKS));
		$table->insert(array(
				'link_id'=>$link_id,'site_id'=>$this->getId(),'active'=>1,'date_created'=>Zend_Date::now()->getTimestamp()
		));
	}
	/**
	 * @param int $link_id
	 * @return boolean
	 */
	public function hasLink($link_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITE_LINKS));
		$row = $table->fetchRow($table->select()->where('site_id = ?',$this->getId())->where('link_id = ?',$link_id)->where('active = 1'));
		return !empty($row);
	}
	/**
	 * @param int $id
	 * @return Site
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITES, 'rowClass'=>'Site'));
		return $table->fetchRow($table->select()->where('id = ?',$id)->where('active = 1'));
	}
	public static function getAll($onlyPublished = true)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SITES, 'rowClass'=>'Site'));
		$select = $table->select()->where('active = 1');
		if($onlyPublished)
			$select = $select->where('publish = 1');
		return $table->fetchAll($select->order("title asc"));
	}
}

?>