<?php
require_once ('cms/models/vo/Content.php');
class Page extends Content
{
	protected $content;//a page has a content
	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getParentId()
	{
		return $this->parent_id;
	}
	public function getContentId()
	{
		return $this->content_id;
	}
	/**
	 * Determines if this is a root page. Root page will show on the top menu
	 * @return boolean
	 */
	public function isRoot()
	{
		return $this->parent_id == 0;
	}
	public function getDefaultTemplate()
	{
		return 'page';
	}
	public function getChildren()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES, 'rowClass'=>'Page'));
		return $table->fetchAll($table->select()->where('active=1')->where('parent_id=?',$this->getId())
				->order('order asc'));
	}
	public function getParent()
	{
		return self::get($this->getParentId());
	}
	public function getSiblings()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES, 'rowClass'=>'Page'));
		return $table->fetchAll($table->select()->where('active=1')->where('parent_id=?',$this->getParentId())
				->order('order asc'));
	}

	/*
	 * (non-PHPdoc)
	 * @see Content::commentsDisabled()
	 * A page will always have comments disabled irrespective of content setting
	 */
	public function commentsDisabled()
	{
		return true;// a page always has comments disabled.
	}
	/* (non-PHPdoc)
	 * @see Content::hideInfo()
	 */
	public function hideInfo()
	{
		return true;
	}

	/* Any unknown method call should be transfered to content e.g.
	 * (non-PHPdoc)
	 * @see Zend_Db_Table_Row_Abstract::__call()
	 */
	/*magic method no more necessary, since Page now extends Content
	public function __call($method,$args)
	{
		if(empty($this->content))
			$this->content = MyContents::getContent($this->content_id,false);
		$res = call_user_func_array(array($this->content,$method),$args);
		if($res === FALSE)
			throw new BadMethodCallException("No method $method found in Page or Content");
		return $res;
	}*/
	public function __get($prop)
	{
		if(isset($this->_data[$prop]))return $this->_data[$prop];

		if(empty($this->content))
			$this->content = MyContents::getContent($this->content_id,false);
		return $this->content->$prop;
	}

	/**
	 * Get all pages
	 * @param boolean $rootOnly - Get only top/root pages (default = false)
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($rootOnly=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES, 'rowClass'=>'Page'));
		$select = $table->select()->where('active= ? ',1);

		if($rootOnly)$select = $select->where('parent_id=0');

		$select = $select->order('order asc');

		return $table->fetchAll($select);
	}
	/**
	 * @param int $id - id of the page
	 * @param boolean $isContentId - Set to true if $id is actually content id (Default is false)
	 * @return Page
	 */
	public static function get($id,$isContentId=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES, 'rowClass'=>'Page'));
		if($isContentId)
			$select = $table->select()->where('content_id = ?',$id);
		else
			$select = $table->select()->where('id = ?',$id);

		return $table->fetchRow($select->where('active = 1'));
	}
	public function do_delete($parent_id=0,$deleteCopies = true)
	{
		$this->active = 0;
		$this->save();
		parent::do_delete($parent_id,$deleteCopies);
	}
	/**
	 * @param unknown_type $data
	 * @return Page
	 */
	public static function createNew($data)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PAGES, 'rowClass'=>'Page'));
		$row = $table->createRow($data);
		$row->save();

		return $row;
	}
}
?>