<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
class Menu  extends Zend_Db_Table_Row_Abstract
{

	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getUrl()
	{
		$baseUrl =  Zend_Controller_Front::getInstance()->getBaseUrl();
		if(!empty($this->content_id))
			return $baseUrl.'/cms/view/'.$this->content_id;

		if(!empty($this->redirect_id))
		{
			$menu = self::get($this->redirect_id);
			return $menu->getUrl();
		}

		if(strtolower(substr($this->url,0,4)) != 'http')
		{
			return $baseUrl.$this->url;
		}
		return $this->url;
	}
	public function getDescription()
	{
		return $this->description;
	}
	public function getTarget()
	{
		return $this->target;
	}
	public function getDate()
	{
		return new Precurio_Date($this->date_created);
	}
	public function __toString()
	{
		return $this->getTitle();
	}
	public function getChildren()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MENU, 'rowClass'=>'Menu'));
		return $table->fetchAll($table->select()->where('active=1')->where('parent_id=?',$this->getId())
				->order('menu_order asc'));
	}
	public function getParent()
	{
		return self::get($this->getParentId());
	}
	public function getSiblings()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MENU, 'rowClass'=>'Menu'));
		return $table->fetchAll($table->select()->where('active=1')->where('parent_id=?',$this->getParentId())
				->order('menu_order asc'));
	}
	public function getParentId()
	{
		return $this->parent_id;
	}
	public function getContentId()
	{
		return $this->content_id;
	}
	/**
	 * Determines if menu is top menu
	 * @return boolean
	 */
	public function isTopMenu()
	{
		return $this->parent_id == 0;
	}
	/**
	 * Get all menu links
	 * @param boolean $rootOnly - Get only top/root menu (default = false)
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($rootOnly=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MENU, 'rowClass'=>'Menu'));
		$select = $table->select()->where('active= ? ',1);

		if($rootOnly)$select = $select->where('parent_id=0');

		$select = $select->order('menu_order asc');

		return $table->fetchAll($select);
	}
	/**
	 * Get Menu
	 * @return Menu
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::MENU, 'rowClass'=>'Menu'));
		$select = $table->select()->where('id= ? ',$id);

		return $table->fetchRow($select);
	}
}

?>