<?php

require_once ('admin/controllers/BaseController.php');
require_once ('workflow/models/vo/Process.php');
require_once ('workflow/models/vo/UserProcess.php');
require_once 'PHPExcel/PHPExcel.php';
require_once 'others/class.httpdownload.php';

class Admin_WorkflowExportController extends Zend_Controller_Action
{
    public function indexAction()
    {
        $searchText = $this->getRequest()->getParam('search','');
    
        $this->view->searchText = $searchText;
        $this->view->list =  $this->generateList($searchText);
        $this->view->header = $this->generateHeader();
        $this->view->table = $this->getTableName();
    }
    
    function generateHeader() {
        return array('',$this->translate('Name'),$this->translate('Total Submitted'),$this->translate('Total Approved'),$this->translate('Total Denied'),$this->translate('Last Submission'));
    }
    function generateList($searchText) {
    
        $this->view->tableOptions = array('view_href'=>" href='{$this->view->pathToController}export/id/%1\$s' ",
        'enable_view'=>true,'enable_edit'=>false,
        'view_label'=>$this->view->translate('Export Data'));
    
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
        $items = $table->fetchAll($table->select()->where('active=1'));
    
        $arr = array();
        $i = 1;
        foreach($items as $process)
        {
            if(!Precurio_Utils::isNull($searchText))
            {
                if(stripos($process->display_name,$searchText)===FALSE)
                {
                    if(stripos($process->process,$searchText)===FALSE)
                    {
                        continue;
                    }
                }
            }
            
            
            $report = $process->getReport();
    
            $arr[] = array($i++,'display_name'=>$process->display_name,'submitted'=>$report->numRecords(),'approved'=>$report->numApproved(),
                'rejected'=>$report->numRejected(),'last_date'=>$report->LastRecordDate(),'id'=>$process->id);
        }
        return $arr;
    }
        
    function getTableName() {
        return PrecurioTableConstants::WORKFLOW;
    }
    
    public function exportAction(){
        $this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN);
        $this->_helper->viewRenderer->setNoRender(false);
        
        
        $process_id = $this->getRequest()->getParam("id");
        $process = Process::get($process_id);

        //get the heading
        $fields = $process->getFields();
        $sheetData = array();
        $heading = array();
        foreach($fields as $field){
            if($field['type'] == 'signature')
                continue;
            $heading[] = $field['label'];
        }
        $heading[] = "Status";
        $heading[] = "Date";
        $heading[] = "Department";
        $heading[] = "Name";
        $sheetData[] = $heading;
        
        //get workflow data
        $userProcess = $process->getRecords();
        foreach($userProcess as $up){
            $form = $up->getFormData();
            $row = array();
            $owner = $up->getOwner();
            $date = new Precurio_Date($up->date_created);
            foreach($fields as $field){
                if($field['type'] == 'signature')
                    continue;
                $row[] = $form[$field['name']];
            }
            $row[] = $up->getStatus();
            $row[] = $date->get(Precurio_Date::DATE_LONG);
            $row[] = $owner->getDepartment();
            $row[] = $owner->getFullName();
            $sheetData[] = $row;
        }
        
        
        $objPHPExcel = new PHPExcel();
        //set some properties
        $objPHPExcel->getProperties()->setCreator("Precurio Team");
        $objPHPExcel->getProperties()->setTitle($process->getDisplayName()." - Data");
        $objPHPExcel->getProperties()->setSubject($process->getDisplayName()." - Data");
        $objPHPExcel->getProperties()->setDescription($process->getDisplayName()." Data, exported from Precurio Intranet Software");
        
                
        $objPHPExcel->getActiveSheet()
        ->fromArray(
            $sheetData   // The data to set
        );
        
        //set some style
        $objPHPExcel->getActiveSheet()->getStyle('A1:IN1')->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()->setWidth(20);
        $objPHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        
        //save file
        $date = new Zend_Date();
        $date = $date->toString("YmdHs");
        $path = Zend_Registry::get('root').'/public/uploads/tmp/';
        $file = $path.$process->getName().'-'.$date.".xls";
        $objWriter = new PHPExcel_Writer_Excel5($objPHPExcel);
        $objWriter->save($file);
        
        //download
        $downloader = new httpdownload();
        $downloader->set_byfile($file);
        $downloader->download();
    }
    
    public function init()
    {
        $this->view->module = $this->getRequest()->getControllerName();
        $this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
        $this->view->pathToController = $this->getRequest()->getBaseUrl().'/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/';
        $root = Zend_Registry::get('root');
        if($this->view->theme != 'default')
            $this->view->addScriptPath($root .  '/application/default/layouts/default/views/admin');
        $this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/admin');
    }

    public function translate($str)
    {
        return $this->view->translate($str);
    }
}

?>