<?php
require_once ('user/models/UserUtil.php');
require_once ('admin/controllers/BaseController.php');
class Admin_UserController extends Admin_BaseController {

	function generateHeader() {
		return array(" ",$this->translate("Name"),$this->translate("Email"),$this->translate("Job Title"),$this->translate("Date Joined"));
	}

	public function generateList($searchText)
	{
		$searchText = strtolower($searchText);
		//$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		//$users = $table->fetchAll();
		//commented code above will make Guest user appear in the list. We don't want that.
		$employees = new Employees();
		$users = $employees->getAll(true);
		$arr = array();
		$i = 1;
		foreach($users as $user)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($user->getSearchStr(),$searchText)===FALSE)
				{
					continue;
				}

			}

			$arr[] = array($i++,'title'=>$user->getFullName(),'email'=>$user->getEmail(),'job_title'=>$user->job_title,'date_created'=>$user->getDateJoined(),'id'=>$user->getId());
		}
		return $arr;
	}
	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');

		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/';
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());
		$this->renderScript('views/admin/user/list.phtml');
	}
	/**
	 * Restore user group memberships.
	 * 
	 * This was needed as a result of the silly bug with group memberships being reset when admin updates a user. (See commit #1252).
	 * 
	 * We try to restore membership by using the activity_log table. Since team room members who have contributed to the team room 
	 * either by uploading a document, contributing to a discussion etc, have their activity recorded; we can use these records to
	 * perform a restore. This means inactive team members are lost permanently.
	 * Note - This function will also restore members that were removed intentionally.
	 */
	public function restoreAction()
	{
	    set_time_limit(0);
	    $this->_helper->viewRenderer->setNoRender();
	    $this->_helper->layout->disableLayout();
	    echo "Restoring user group membership. <br/>";
	    //so lets get all groups.
	    
	    $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS));
	    $groups = $table->fetchAll($table->select()->where('active = 1'));
	    
	    foreach ($groups as $group)
	    {
	        //get all activities in the group
	        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
	        $activities = $table->fetchAll($table->select()->where('group_id = ?',$group->id));
	        foreach($activities as $activity)
	        {
	            //get the activity history for each activity.
	            $activityRecords = $table->fetchAll($table->select()->where('item_id = ?',$activity->item_id)->where('appid = ?',$activity->appid));
	            //insert user record
	            foreach($activityRecords as $record)
	                UserUtil::addUserToGroup($record->user_id, $group->id);
	        }
	    }
	    echo "User group membership restored. <br/>";
	}
	function getPageTitle() {
		return $this->translate("User Management");
	}

	function getTableName() {
		return PrecurioTableConstants::USERS;
	}

	public function addAction()
	{
		$this->renderScript('forms/admin/user_form.phtml');
	}
	public function editAction()
	{
		$id = $this->getRequest()->getParam('id',0);

		$item = UserUtil::getUser($id);
		if($item == null)return $this->_forward('index');

		$this->view->user = $item;
		$this->renderScript('forms/admin/user_form.phtml');
	}
	/**
	 * Send email to user, notifying user of registration on intranet
	 */
	public function resendAction()
	{
		$this->_helper->layout->disableLayout();
		sleep(2);
		$tr = Zend_Registry::get("Zend_Translate");

		$user_id = $this->getParam("user_id",-1);

		try
		{
			$user = UserUtil::getUser($user_id,true);
		}
		catch (Exception $e)
		{
			echo $tr->translate("Could not send email to user. User not found.");
			return;
		}


		$loginDetails = getLocalizedString($tr->translate("LOGIN: {1} <br/> PASSWORD: {2} <br/>"),$user->getEmail(),"[We don't store your password]");

		//find activity that was generated when user was created
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
		$row = $table->fetchRow($table->select()->where("appid = ?",User::APPID)->where("user_id = ?",$user_id)->where("type = ?",User::ACTIVITY_NEW)->where("item_id = ?",$user_id));

		if(empty($row))
		{
			echo $tr->translate("Could not send email to user. User was not recently registered");
			return;
		}

		$activity_id = $row->id;
		$activity = UserActivity::get($activity_id);

		$baseUrl = $config->base_url;

		$format = Precurio_Activity::getMessageFormat($activity,"mail");
		$message = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$baseUrl.$user->getUrl(),"",$user_id,"",$baseUrl,$loginDetails,$baseUrl.$user->getUrl());

		$mail = new Precurio_Mail();
		$mail->sendData(array(
				'to'=>$user->getEmail(),
				'subject'=>$activity->getMailSubject(),
				'body'=>$message,
				'activity_id'=>$activity_id
		));
		echo getLocalizedString($tr->translate("Email has been sent to {1}"),$user->getEmail());
	}
	public function deleteAction()
	{
		$ids = $this->getRequest()->getParam("ids");
		foreach($ids as $userid)
		{
			$user = UserUtil::getUser($userid);
			if($user)
				$user->deactivate();
		}

		return $this->_redirect('/admin/user/index/');
	}

	public function submitAction()
	{
		$params = $this->getRequest()->getParams();
		if (!$this->getRequest()->isPost()) {
			return $this->_forward('index');
		}
		$form = $this->getForm();
		if (!$form->isValid($params))
		{
			// Failed validation; redisplay form
			$this->view->user = $params;
			$this->view->error = "Error submiting form.";
			return $this->renderScript('forms/admin/user_form.phtml');
		}

		$params['identity'] = $params['email'];
		//if password was sent, then set credential
		if(!empty($params['password']))
			$params['credential'] = $params['password'];


		if($params['user_id'])
		{
			$user = UserUtil::getUser($params['user_id'],true);
			$user_id = $params['user_id'];
			if(empty($params['password']))unset($params['password']);//this way, if password is blank string, password is not changed
			//v4 feature. add user to selected groups
			if(count($params['group_ids']))
			{
				foreach($params['group_ids'] as $group_id)
				{
					$group = UserUtil::getGroup($group_id);
					if(!empty($group))$group->addUserMember($user_id);
				}
			}
			$user->update($params);//only update after setting groups
		}
		else
		{
			if(empty($params['credential']))
				$params['credential'] = Precurio_Utils::randomPassword(8);
			try
			{
				$user = UserUtil::createUser($params);
			}
			catch(Precurio_Exception $e)
			{
				$this->view->user = $params;
				$this->view->error = $e->getMessage();
				return $this->renderScript('forms/admin/user_form.phtml');
			}
			$user_id = $user->getId();
		}
		$this->_redirect('/admin/user/index/search/'.$params['email']);
	}

	function getForm($user = null, $viewMode = false)
	{
		$userUtil = new UserUtil();

		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/user/submitnew')
			->setMethod('post')
			->setAttrib('id','form')
			->setAttrib('name','addForm')
			->setAttrib('enctype', 'multipart/form-data');



		$form->addElement('hidden', 'user_id', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				));

		$form->addElement('hidden', 'date_created', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				'value'=>Precurio_Date::now()->getTimestamp()
				));

		$form->addElement('text', 'first_name', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('First name'),
				));

		$form->addElement('text', 'last_name', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Last name'),
				));

		$form->addElement('text', 'email', array(
				'validators' => array(
				),
				'required' => true,
				'label'=>$this->translate('Email'),
				));

		$form->addElement('text', 'password', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Password'),
				));

		$form->addElement('select', 'department_id', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Department'),
				'multiOptions'=> Precurio_FormElement::getOptionsArray($userUtil->getDepartments(),'id','title',true),
				));
		$form->addElement('select', 'location_id', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Location'),
				'multiOptions'=> Precurio_FormElement::getOptionsArray($userUtil->getLocations(),'id','title',true),
				));

		$form->addElement('submit', 'submit', array(
					'class'=>'standout',
					'label'=>$this->translate('Submit'),
					));


		return $form;
	}

	public function importAction()
	{
		$this->_helper->layout->disableLayout();
		$this->renderScript('views/admin/user/import.phtml');
	}
	public function doimportAction()
	{
		require_once("ExcelReader/reader.php");
		require_once("ExcelReader/oleread.inc");
		set_time_limit(0);
		$this->_helper->viewRenderer->setNoRender();
		$this->_helper->layout->disableLayout();

		$upgrade = new Precurio_Upgrade();
		$target_dir = $upgrade->checkDir('/uploads/tmp/');
		if(!($_FILES['file']['size']))
		{
			echo ($this->translate('No file selected'));
			return;
		}
		$file = $_FILES['file'];
		//first handle file upload
		if (is_uploaded_file($file['tmp_name']))
		{
	    	$filename = $file['name'];
			$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
			$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
			if(strtolower($ext) !== 'xls')
			{
				echo ($this->translate('Incorrect file format'));
				return;
			}
			if (!move_uploaded_file($file['tmp_name'], $target_dir.'/'.$filename))
			{
			    echo($this->translate('Cannot upload file'));
			    return;
			}
			$userFile = ($target_dir.'/'.$filename);
		}
		if(empty($userFile))
		{
			echo($this->translate('Cannot upload file'));
			return;
		}

		require_once("ExcelReader/reader.php");
		require_once("ExcelReader/oleread.inc");

		$data = new Spreadsheet_Excel_Reader();
		$data->read($userFile);

		$cols = $data->sheets[0]['numCols'];
		$sheets = count($data->sheets) - 1;

		$start = 0;

		$x = 2;
		$y = count($data->sheets[0]['cells']) + 10;
		$str = "";
		for($x; $x <= $y; $x++)
		{
			if(empty($data->sheets[$start]['cells'][$x][1]))break;

			$first_name = $data->sheets[$start]['cells'][$x][1];
			$last_name = $data->sheets[$start]['cells'][$x][2];
			$email = strtolower($data->sheets[$start]['cells'][$x][3]);
			$job_title = $data->sheets[$start]['cells'][$x][4];
			$department = $data->sheets[$start]['cells'][$x][5];
			$location = $data->sheets[$start]['cells'][$x][6];
			//unless 0 is explicitly set in the excel file, always assume true.
			$active = isset($data->sheets[$start]['cells'][$x][7]) ? $data->sheets[$start]['cells'][$x][7] : 1;
			$password = $data->sheets[$start]['cells'][$x][8];


			if(empty($password))
				$password = $this->getRequest()->getParam('pwd','pass1234');

			$password = md5($password);
			$date_created = time();
			if(stripos($email, '@') === false)continue;

			$username = substr($email,0,stripos($email, '@'));

			$location_id = 0; $department_id = 0;
			if(!empty($location))$location_id = Location::getLocationId($location);
			if(!empty($department))$department_id = Department::getDepartmentId($department);

			$param = array(
				'first_name'=>$first_name,
				'last_name'=>$last_name,
				'identity'=>$email,
				'credential'=>$password,
				'email'=>$email,
				'username'=>$username,
				'department_id'=>$department_id,
				'location_id'=>$location_id,
				'job_title'=>$job_title,
				'active'=>$active
			);


			try {

				UserUtil::createUser($param);
			}
			catch(Precurio_Exception $e)
			{
				switch($e->type)
				{
					case Precurio_Exception::EXCEPTION_LICENSE_FULL:
						$str = $this->translate("You have exceeded your allowed maximum number of users. Please purchase additonal user licenses.");
						die($str);
					break;

					case Precurio_Exception::EXCEPTION_APPLICATION_ERROR://user already exists.
						//get user and update
						$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
						$row = $table->fetchRow($table->select()->where('identity = ?',$param['identity']));

						$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS));
						$item = $table->fetchRow($table->select()->where('user_id = ?',$row->id));
						if(!empty($item))
						{
							unset($param['password']);
							$item->setFromArray($param);
							$item->save();
						}

					break;
					default:
						$str = $this->translate("An error occurred: ".$e->getMessage());
						die($str);
				}

			}


		}
	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/admin');
		$this->view->addScriptPath($root .  '/application/default/layouts/default/views/admin');
	}
}

?>