<?php
require_once ('cms/models/MyContents.php');
require_once ('admin/controllers/BaseController.php');

class Admin_SitePhotoController extends Admin_BaseController {
	function generateHeader() {

	}

	public function generateList($searchText)
	{
		$album_id = $this->getRequest()->getParam('album_id');
		$album = Folder::get($album_id);

		$contents = $album->getContentChildren(false);

		$arr = array();
		$i = 1;
		foreach($contents as $content)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($content->getTitle(),$searchText)===FALSE)
				{
					if(stripos($content->getDescription(),$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = $content;
		}
		return $arr;
	}
	public function indexAction()
	{
		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());

		$this->renderScript('views/admin/site/edit.phtml');
	}
	/**
	 * Upload photo action (facebox)
	 */
	public function newAction()
	{
		$this->_helper->layout->disableLayout();
		$this->view->folder = $this->view->album;
		$this->renderScript('views/document/new_file.phtml');
	}
	public function submitAction()
	{
		$params = $this->getRequest()->getPost();
		$folder = Folder::get($params['parent_id']);
		foreach($params['files'] as $filename)
		{
			$params['file'] = $filename;
			$params['image_path'] = Content::PATH_THUMBNAILS.$filename;
			$params['is_photo'] = 1;
			$params['is_site'] = 1;
			Documents::createNew($params,$folder);
			//delete the file
			$file = Precurio_Upload::checkDir(Content::PATH_TMP).$filename;
			@unlink($file);
		}

		$this->_redirect('/admin/sitephoto/index/site_id/'.$params['site_id'].'/album_id/'.$params['album_id']);

		$this->postSubmit($params);
	}
	public function deleteAction()
	{
		$params = $this->getRequest()->getPost();
		$ids = $params["ids"];
		foreach($ids as $id)
		{
			$content = MyContents::getContent($id,true);
			$content->do_delete();
		}
		$this->postDelete($ids);
		return $this->_redirect('/admin/sitephoto/index/site_id/'.$params['site_id'].'/album_id/'.$params['album_id']);
	}
	public function updateAction()
	{
		$params = $this->getRequest()->getPost();
		$content = MyContents::getContent($params["id"],false);
		$content->summary = $params['summary'];
		$content->save();
		return $this->_redirect('/admin/sitephoto/view/site_id/'.$params['site_id'].'/album_id/'.$params['album_id'].'/id/'.$params['id']);
	}
	public function viewAction()
	{
		$this->view->photo = MyContents::getContent($this->getRequest()->getParam('id',0));
		$this->view->section = "viewphoto";
		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function getForm($menu = null,$viewMode = false)
	{

	}

	public function getPageTitle()
	{
		return $this->translate("Site Photos");
	}
	public function getTableName()
	{
		return PrecurioTableConstants::CONTENT;
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
		$site_id = $this->getRequest()->getParam('site_id');
		$this->view->site = Site::get($site_id);
		$album_id = $this->getRequest()->getParam('album_id');
		$this->view->album = Folder::get($album_id);
		$this->view->module = "sitephoto";
		$this->view->section = "photo";
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$site_id.'/album_id/'.$album_id.'/';
	}
}
?>