<?php
require_once ('admin/controllers/CmsController.php');
class Admin_SiteContentController  extends Admin_CmsController{
	function generateList($searchText) {
		$site_id = $this->getRequest()->getParam('site_id');
		$site = Site::get($site_id);
		$items = $site->getContents();
		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->getTitle(),$searchText)===FALSE)
				{
					continue;
				}
			}
			$arr[] = array($i++,'title'=>$item->getTitle(),'user'=>$item->getFullName(),'date'=>$item->getDateAdded(),'id'=>$item->getContentId());
		}
		$this->view->tableOptions = array("edit_href"=>" href='".$this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/edit/site_id/'.$site_id.'/'."id/%1\$s' ");
		return $arr;
	}
	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');
		$site_id = $this->getRequest()->getParam('site_id');

		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$site_id.'/';
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());
		$this->view->site = Site::get($site_id);
		$this->view->section = "content";
		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
		$this->view->module = "sitecontent";
		$site_id = $this->getRequest()->getParam('site_id');
		$this->view->site = Site::get($site_id);
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$this->getRequest()->getParam('site_id').'/';
	}
	function postSubmit($params)
	{
		if(empty($params['site_id']))$this->_redirect('/admin/page');

		$site = Site::get($params['site_id']);
		$site->addContent($params['content_id']);

		//$this->_redirect('/admin/sitecontent/edit/site_id/'.$params['site_id'].'/id/'.$params['content_id']);
		$this->_redirect('/admin/sitecontent/index/site_id/'.$params['site_id']);
	}
	public function postDelete($ids)
	{
		$this->_redirect('/admin/sitecontent/index/site_id/'.$this->getRequest()->getParam('site_id'));
	}
}

?>