<?php
require_once ('admin/controllers/CategoryController.php');
class Admin_SiteAlbumController  extends Admin_CategoryController{
	public function addAction()
	{
		$this->renderScript('forms/admin/sitealbum_form.phtml');
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);
		$this->view->category = Category::getCategory($id);
		$this->renderScript('forms/admin/sitealbum_form.phtml');
	}
	function generateList($searchText) {
		$site_id = $this->getRequest()->getParam('site_id');
		$site = Site::get($site_id);
		$items = $site->getAlbums();
		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->title,$searchText)===FALSE)
				{
					if(stripos($item->description,$searchText)===FALSE)
					{
						continue;
					}
				}
			}
			$arr[] = array($i++,'title'=>$item->title,'description'=>$item->description,'photos'=> count($item->getContentChildren(true)),'date'=> $item->getDateCreated() ,'id'=>$item->id);
		}
		$this->view->tableOptions = array(
				"view_href"=>" href='".$this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/edit/site_id/'.$site_id.'/'."id/%1\$s' ",
				"edit_href"=>" href='".$this->getRequest()->getBaseUrl().'/admin/sitephoto/index/site_id/'.$site_id.'/'."album_id/%1\$s' ",
				"enable_view"=>1,
				"view_label"=>$this->view->translate("Edit")
				);
		return $arr;
	}
	public function generateHeader()
	{
		return array(" ",$this->translate("Name"),$this->translate("Description"),$this->translate("Photos"),$this->translate("Date Created"));
	}
	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');
		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());

		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function preDispatch()
	{
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_ADMIN);
		$site_id = $this->getRequest()->getParam('site_id');
		$this->view->site = Site::get($site_id);
		$this->view->module = "sitealbum";
		$this->view->section = "album";
		$this->view->pathToController = $this->getRequest()->getBaseUrl().'/admin/'.$this->getRequest()->getControllerName().'/index/site_id/'.$this->getRequest()->getParam('site_id').'/';
	}
	function postSubmit($params)
	{
		if(empty($params['site_id']))$this->_redirect('/admin/category');

		$site = Site::get($params['site_id']);
		$site->addCategory($params['id']);

		$this->_redirect('/admin/sitealbum/index/site_id/'.$params['site_id']);
	}
	public function postDelete($ids)
	{
		$this->_redirect('/admin/sitealbum/index/site_id/'.$this->getRequest()->getParam('site_id'));
	}
}
?>