<?php

/**
 * Site Managmenet
 *
 * @author mayorbrain
 * @version
 */

require_once ('cms/models/MyContents.php');
require_once ('admin/controllers/BaseController.php');

class Admin_SiteController extends Admin_BaseController
{
	function generateHeader() {
		return array(" ",$this->translate("Title"),$this->translate("Description"),$this->translate("Published"));
	}
	public function generateList($searchText)
	{
		$sites = Site::getAll(false);
		$tr = Zend_Registry::get('Zend_Translate');
		$arr = array();
		$i = 1;
		foreach($sites as $site)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($site->title,$searchText)===FALSE)
				{
					if(stripos($site->description,$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = array($i++,'title'=>$site->title,'description'=>$site->description,'publish'=>($site->publish ? $tr->translate('Yes') : $tr->translate('No')),'id'=>$site->id);
		}
		return $arr;
	}

	public function addAction()
	{
		$this->renderScript('forms/admin/site_form.phtml');
	}
	public function editAction()
	{
		$id = $this->getRequest()->getParam('id',0);
		if(empty($id))$this->redirect('/admin/site/');
		$this->view->site = Site::get($id);
		$this->renderScript('views/admin/site/edit.phtml');
	}
	public function getForm($item = null,$viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/site/submit')
		->setMethod('post')
		->setAttrib('id','form')
		->setAttrib('name','addForm');


		$form->addElement('hidden', 'id', array('value'=>$item['id']));
		$form->addElement('hidden', 'title', array('value'=>$item['title']));
		$form->addElement('hidden', 'description', array('value'=>$item['description']));
		$form->addElement('hidden', 'date_created', array('value'=>$item['date_created']));
		$form->addElement('hidden', 'welcome_page_id', array('value'=>$item['welcome_page_id']));
		$form->addElement('hidden', 'resource_folder_id', array('value'=>$item['resource_folder_id']));
		$form->addElement('hidden', 'publish', array('value'=>$item['publish']));
		$form->addElement('hidden', 'active', array('value'=>$item['active']));

		return $form;
	}
	function postSubmit($params)
	{
		$site = Site::get($params['id']);
		$site->setAdmins($params['user_ids']);
		$this->_redirect("/admin/site/edit/id/".$params['id']);
	}

	function getPageTitle() {
		return $this->translate("Sites");
	}

	function getTableName() {
		return PrecurioTableConstants::SITES;
	}
}
