<?php

require_once 'Zend/Controller/Action.php';

class Admin_ResetController extends Zend_Controller_Action 
{
    public function indexAction() 
    {
        
    }
    /**
     * Action called by remove button.
     * Removes the test data
     */
    public function removeAction()
    {
        set_time_limit(300);//five minutes maximum execution time
        $this->_helper->viewRenderer->setNoRender();
        $this->_helper->layout->disableLayout();
        
        $root = Zend_Registry::get('root');
        $installPath = $root."/public/install/";
        
        //first get current user before clearing data. Will be used in the final stage of this function
        $user = UserUtil::getUser();
        $user = $user->toArray();
        
        $db_config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',"mysql");

    	$db_config = $db_config->toArray();
    	$db_config = $db_config['database'];
    	
        //create tables
        try {
            $dbh = new PDO('mysql:host='.$db_config['host'].';dbname='.$db_config['dbname'], $db_config['username'], $db_config['password']);
            $sql = file_get_contents($installPath."sql/create_tables.sql");
            $dbh->exec($sql);
            $dbh = null;
        
        }
        catch (PDOException $e) {
            echo $e->getMessage();
            return;
        }
        
        //install default data
        $dir = $installPath."data/";
        $handle = opendir($dir);//for now, it's just data 1
        if ($handle) {
            while (false !== ($entry = readdir($handle))) {
                if(!is_file($dir.$entry))continue;//skip all directories
                loadCsv($dir.$entry);
            }
            closedir($handle);
        }
        
        
        //create user
        $user['credential'] = "pass1234";
        $user['identity'] = $user['email'];
        unset($user['password']);unset($user['department_id']);unset($user['location_id']);
        unset($user['profile_picture_id']);unset($user['percentage_complete']);
        UserUtil::createUser($user);
        echo getLocalizedString($this->translate("Your login is {1} and your password is {2}"),"<b>".$user['email']."</b>","<b>".$user['credential']."</b>");
    }
    public function preDispatch()
    {
        $this->_helper->layout->disableLayout();
        //$this->_helper->viewRenderer->setNoRender();
    }
    public function translate($str)
    {
        return $this->view->translate($str);
    }
    public function init()
    {
        $root = Zend_Registry::get('root');
        $this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/admin');
        $this->view->addScriptPath($root .  '/application/default/layouts/default/views/admin');
    }
}

/**
 * The two functions below are copied from forms-handler.php (in install folder)
 * @author mayorbrain
 */


/**
 * Loads a CSV file into a database table
 * @param string $filepath - relative path to csv file
 * @param integer $timestampDiff - Difference in timestamp between now and when the demo was created
 */
function loadCsv($filepath,$timestampDiff=0)
{
    list( $dirname, $filename, $extension, $tablename ) = array_values( pathinfo($filepath) );

    if(strtolower($extension) != "csv")return false;//only csv file please

    $handle = fopen ( $filepath, "r" );
    if($handle ===  FALSE)return false; //could not find file

    $db = Zend_Registry::get('db');
    $table = new Zend_Db_Table(array('name'=>$tablename));//initialise db table
    $table->getAdapter()->query('TRUNCATE TABLE '.$tablename);//truncate table

    //get first line, which is always the header
    $header = fgetcsv ( $handle, 1000, "," );

    //continue with rest of data
    $count = 0;
    while ( ($data = fgetcsv ( $handle, 1000, "," )) !== FALSE ) {
        $rowData = array_combine($header,$data);
        $row  = $table->createRow();
        $rowData = fixRowData($rowData, $timestampDiff);
        $row->setFromArray($rowData);
        $id  = $row->save();
        //now lets make sure there is database reconnection after a while
        $count++;
        if($count > 50)
        {
            $count = 0;//reset counter
            $db->closeConnection();//close connection
        }
    }

    fclose ( $handle );
    $db->closeConnection();
}
/**
 * Fixes row data by striping slashed and modifying date information.
 * Returns the fixed data
 * @param array $row - Row data (associative array)
 * @param string $timestampDiff - the timestamp difference between the time of the demo and now. We will use this to determine the relative current date of every row
 * @return array
 */
function fixRowData($row,$timestampDiff)
{
    $textCols = array("title","description","summary","body","message","job_description","skills");
    $dateCols = array("expires","date_created","last_modifed","start_timestamp","start_time","end_time","complete_time");

    foreach($row as $col=>$value)
    {
        if(in_array($col,$textCols))
            $row[$col] = stripslashes($value);

        //do not fix start_time for events but fix start_date instead
        if($col == "start_time" && isset($row['venue']))
        {
            $date = new Precurio_Date($row['start_date'],null,'de');//event date is stored in format dd-mm-yyy which is closest to deutch locale
            $date->addTimestamp($timestampDiff);
            $row['start_date'] = $date->get(Zend_Date::DATE_MEDIUM);
            continue;
        }

        //do not fix end_time for events but fix end_date instead
        if($col == "end_time" && isset($row['venue']))
        {
            $date = new Precurio_Date($row['end_date'],null,'de');//event date is stored in format dd-mm-yyy which is closest to deutch locale
            $date->addTimestamp($timestampDiff);
            $row['end_date'] = $date->get(Zend_Date::DATE_MEDIUM);
            continue;
        }

        //fix for others
        if(in_array($col,$dateCols) && !empty($value))
            $row[$col] = $value + $timestampDiff;

        //fix ids
        if(stripos($col,"id") && empty($row[$col]))
        {
            $row[$col] = 0;
        }

    }

    //fix special scenario. Polls end date
    if(isset($row['end_date']) && isset($row['multiple_answers']))
        $row['end_date'] = $row['end_date'] + $timestampDiff;

    return $row;
}

?>