<?php

require_once ('admin/controllers/BaseController.php');

class Admin_BugController extends Admin_BaseController  {

	function generateHeader() {
		return array(" ",$this->translate("Log Level"),$this->translate("Message"),$this->translate("Date"));
	}

	public function generateList($searchText)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LOGS));
		$items = $table->fetchAll($table->select()->where("priority <= 4")->order("id DESC")->limit(100));

		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(stripos($item->message, "Precurio_Session::getCurrentUserId()") !== FALSE)continue;//do not display session errors
			if(stripos($item->message, "(library)") !== FALSE)continue;//don't display the 'Invalid controller specified (library)' error.

			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->message,$searchText)===FALSE)
				{
					continue;
				}

			}


			$x = stripos($item->message, "stack");
			if($x === false || $x > 180)$x = 180;//maximum length of error should be 180 characters
			$message = substr($item->message,0,$x);

			$arr[] = array($i++,'priority'=>$this->getPriority($item->priority),'error'=>$message,'date'=>$this->getErrorDate($item->timestamp),'id'=>$item->id);
		}

		$this->view->tableOptions = array('enable_view'=>true,"view_href"=>" href='{$this->view->pathToController}view/id/%1\$s' ");
		return $arr;
	}
	private function getErrorDate($timestamp)
	{
		if(is_object($timestamp) && get_class($timestamp) == 'DateTime')
			$timestamp = $timestamp->getTimestamp();//for mssql server;

		$date = new Precurio_Date($timestamp,"","en_GB");
		return $date;
	}
	private function getPriority($level)
	{
		$str = "";
		switch ($level)
		{
			case 0:
			case 1:
				$str = "Emergency";
				break;
			case 2:
				$str = "Critical";
				break;
			case 3:
				$str = "Error";
				break;
			case 4:
				$str = "Warning";
				break;
			case 5:
				$str = "Notice";
				break;
			case 6:
			case 7:
			default:
				$str = "Debug";
				break;
		}
		return $str;
	}
	public function viewAction()
	{
		$id = $this->getRequest()->getParam('id',0);

		$table = new Zend_Db_Table(array('name'=>$this->getTableName()));
		$item = $table->find($id)->current();

		if($item == null)return $this->_forward('index');

		$this->view->item = $item;
		$this->renderScript("views/admin/bug/view.phtml");
	}
	public function deleteAction()
	{
		$ids = $this->getRequest()->getParam("ids");
		$table = new Zend_Db_Table(array('name'=>$this->getTableName()));
		$items = $table->find($ids);

		foreach($items as $obj)
		{
			$obj->delete();
		}
		$this->postDelete($ids);
		return $this->_redirect('/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/');
	}
	public function getForm($item = null,$viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/bug/submit')
			->setMethod('post')
			->setAttrib('id','form')
			->setAttrib('name','addForm')
			->setAttrib('enctype', 'multipart/form-data');

		$form->addElement('hidden', 'id', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				'value'=>$item['id'],
				));
		$form->addElement('textarea', 'message', array(
				'validators' => array(
				),
				'required' => true,
				'col'=>150,
				'rows'=>50,
				'label'=>$this->translate('Full Error Trace'),
				'value'=>$item['message']
				));

		return $form;
	}
	function getPageTitle() {
		return $this->translate("Errors & Logs");
	}

	function getTableName() {
		return PrecurioTableConstants::LOGS;
	}


	public function postSubmit($values)
	{
		$config = Zend_Registry::get('config');


		$user = UserUtil::getUser($values['user_id']);
		$userInfo = $user->getFullName()." (".$user->getEmail().")" ;

		$msg = "<h5>A new isse has been posted from $config->company_name</h5>
    	<br/>Issue details<br/>=====================================<br/>
    	Type : {$values['type']} <br/>
    	Component : {$values['component']} <br/>
    	Title : {$values['title']} <br/>
    	Description : {$values['description']} <br/>
    	Reported By : {$userInfo} <br/>
    	<br/>Technical Information<br/>=====================================<br/>
    	".serialize($config->toArray());

		$conf = array();
		if($config->mail->use_auth)
		{
			$conf = array('auth' => $config->mail->auth,
			'username' => $config->mail->username,
			'password' => $config->mail->password);
			if($config->mail->use_secure)
				$conf['ssl'] = $config->mail->ssl;
		}
		else
		{
			$conf = array();
		}

		$conf['port'] = $config->mail->port;
    	$tr = new Zend_Mail_Transport_Smtp($config->mail->server,$conf);

		$mail = new Zend_Mail();
		$mail->addTo('support@precurio.com','Support Team');
    	$mail->setBodyHtml($msg);
    	$mail->setFrom($user->getFullName(),$user->getEmail());
		$mail->setSubject('New issue report from '.$config->company_name.'. Issue ID #'.$values['id']);
		try
		{
			$mail->send($tr);
			$table = new Zend_Db_Table(array('name'=>$this->getTableName()));
			$row = $table->find($values['id'])->current();
			$row->sent = 1;
			$row->save();
		}
		catch(Exception $e)
		{
			$this->_helper->FlashMessenger($this->translate('Your mail server settings may be incorrect.'));
			$this->_helper->FlashMessenger($this->translate('Error Message').':');
			$this->_helper->FlashMessenger($e->getMessage());
			$baseUrl = $this->getRequest()->getBaseUrl();
			$this->_helper->FlashMessenger("<a href='$baseUrl/admin/setting/mail'>".$this->translate('Click here')."</a> ".$this->translate("to change your mail settings"));
		}
	}
}
?>