<?php
class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
	protected function _initPlugin()
	{
		set_include_path(implode(PATH_SEPARATOR, array(
		realpath(APPLICATION_PATH .'/../application/cms/models/vo') ,
    	get_include_path(),
		)));
		$this->bootstrap('config');
		$this->bootstrap('enviroment');
		if(!Precurio_Session::sessionExists())$this->bootstrap('session');;
		$this->bootstrap('request');
		$this->bootstrap('controller');
		$this->bootstrap('routes');
		$this->bootstrap('db');
		$this->bootstrap('log');
		$this->bootstrap('view');

		$frontController = Zend_Controller_Front::getInstance();
		$frontController->registerPlugin(new Initializer());

		// Dispatch the request using the front controller.
		//$frontController->dispatch();
	}
	protected function _initEnviroment()
	{
		$this->bootstrap('config');
		// set the test environment parameters
		$config = Zend_Registry::get('config');
		$env = empty($config->enviroment)? 'production' : $config->enviroment;
		if ($env == 'development') {
			// Enable all errors so we'll know when something goes wrong.
			error_reporting(E_ALL | E_STRICT);
			ini_set('display_startup_errors', 1);
			ini_set('display_errors', 1);
		}
		else if($env == 'test')
		{
			// Enable only errors so we'll know when something goes wrong.
			error_reporting(E_ERROR | E_WARNING | E_PARSE);
			ini_set('display_startup_errors', 0);
			ini_set('display_errors', 1);
		}
		else
		{
			// Enable only errors so we'll know when something goes wrong.
			error_reporting(E_ERROR);
			ini_set('display_startup_errors', 0);
			ini_set('display_errors', 0);
		}
	}
	/**
     * Initialize view
     *
     * @return void
     */
	protected function _initView()
	{
		$this->bootstrap('config');
		$this->bootstrap('controller');
		$this->bootstrap('log');
		$this->bootstrap('languages');

		$frontController = Zend_Controller_Front::getInstance();
        $baseUrl = $frontController->getBaseUrl();

        if(substr(strtolower($baseUrl),-4) == '.php')
			$baseUrl = dirname($baseUrl);

        $root = Zend_Registry::get('root');

        $themes = new Precurio_Themes();
        $theme = $themes->getUserTheme();
        $theme = strtolower($theme);
        // Bootstrap layouts
        $layoutPath = $root .  '/application/default/layouts/'.$theme;
        try
        {
        	$user = UserUtil::getUser(Precurio_Session::getCurrentUserId(),true);
        	if($user->isExternal())$layoutPath = $root .  '/application/default/layouts/'.$theme.'/extranet';
        }
        catch (Exception $e) { }
        $layout = Zend_Layout::startMvc(array(
            'layoutPath' => $layoutPath,
            'layout'=>'main'
        ));

        //if not using the default theme, set theme folder as initial include path.
        //so that application checks this folder first for files before checking the default folder.
        if(strtolower($theme) != 'default')
        {
        	set_include_path(implode(PATH_SEPARATOR, array(
        		realpath(APPLICATION_PATH .'/../application/default/layouts/'.$theme),
        		get_include_path()
	        )));
        }

        $config = Zend_Registry::get('config');


        $view = new Zend_View();
        $view->assign('theme',$theme);
        $view->assign('themepath', $baseUrl.'/library/themes/'.$theme);//url path, not file path
        $view->assign('company_name',$config->company_name);
        $view->getHelper('BaseUrl')->setBaseUrl($frontController->getBaseUrl());

		//add view helpers
        $view->addHelperPath($root .'/application/default/views/helpers', 'Default_View_Helper');
        $view->addHelperPath($root .'/application/user/views/helpers', 'User_View_Helper');

        //add script path. this enables partials to load from theme
        if($theme != 'default')
        	$view->addScriptPath($root .  '/application/default/layouts/default');
        $view->addScriptPath($root .  '/application/default/layouts/'.$theme);

        $view->headScript()->appendScript("
        		var baseUrl='". $baseUrl ."';
        		var currentTheme = '".$theme."';");


        $modules = Bootstrap::getModules(false);
        foreach($modules as $module)
       	 	$view->addHelperPath($root .'/application/'.$module->getName().'/views/helpers', ucfirst($module->getName()).'_View_Helper');


        Zend_View_Helper_PaginationControl::setDefaultViewPartial('views/paginator.phtml');

        $config = new Zend_Config_Xml($root.'/application/configs/navigation.xml');
        $navigation = new Zend_Navigation($config);
        $view->navigation($navigation);

        $viewRenderer = new Zend_Controller_Action_Helper_ViewRenderer();
        $viewRenderer->setView($view);
        Zend_Controller_Action_HelperBroker::addHelper($viewRenderer);

		return $view;
	}
	/**
     * Initialize Controller paths
     *
     * @return void
     */
	protected function _initController()
	{
		$front = Zend_Controller_Front::getInstance();
		$root = Zend_Registry::get('root');

        $front->setDefaultModule("default");
        $front->setDefaultControllerName("index");

		$front->setControllerDirectory($root . '/application/default/controllers','default');
        $front->addControllerDirectory($root.'/application/user/controllers', 'user');
		$front->addControllerDirectory($root.'/application/install/controllers', 'install');
        $front->addControllerDirectory($root.'/application/search/controllers', 'search');
        $front->addControllerDirectory($root.'/application/widget/controllers', 'widget');
        $front->addControllerDirectory($root.'/application/extranet/controllers', 'extranet');
        $front->addControllerDirectory($root.'/application/team/controllers', 'team');
        $front->addControllerDirectory($root.'/application/poll/controllers', 'poll');


        $modules = Bootstrap::getModules(false);
        foreach($modules as $module)
        	$front->addControllerDirectory($root.'/application/'.$module->getName().'/controllers', $module->getName());

      	return $front;
	}
	protected function _initConfig()
	{
		$root = Zend_Registry::get('root');
		try
		{
			$frontendOptions = array('master_file'=>$root.'/application/configs/precurio.ini','automatic_serialization' => true,'lifetime' => 7200);//cache is valid for 2 hrs
			$backendOptions = array('cache_dir' => $root.'/application/tmp/');

			$cache = Zend_Cache::factory('File',
			'File',
			$frontendOptions,
			$backendOptions);
			if(!$config = $cache->load('config' ))
			{
				$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true));
				$cache->save($config,'config');
			}
		}
		catch(Exception $e)
		{
			if(file_exists($root.'/application/configs/precurio_tmp.ini'))
			{
				copy($root.'/application/configs/precurio_tmp.ini',$root.'/application/configs/precurio.ini');
			}
			$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true));
		}
		Zend_Registry::set('config',$config);
    	return $config;
	}
	/**
     * Initialize data bases
     *
     * @return void
     */
	protected function _initDb()
    {
    	$this->bootstrap('config');
    	$this->bootstrap('controller');

    	$root = Zend_Registry::get('root');
    	$config = Zend_Registry::get('config');

    	$active_db = $config->active_database;
    	$db_config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',$active_db);

    	$db_config = $db_config->toArray();
    	$db_config = $db_config['database'];

    	$adapter = $db_config['adapter'];
    	$params = array();
		foreach ($db_config as $key=>$value) {
			if($key == 'adapter')continue;
			$params[$key] = $value;
		}

		$db = Zend_Db::factory($adapter,$params);
		if($config->database_auto_connect)
		{
			try {
				$db->getConnection();
			}
			catch(Zend_Db_Exception $e)
			{
				throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
			}
			catch(Zend_Exception $e)
			{
				throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
			}
			$db->closeConnection();
		}

		Zend_Registry::set('db',$db);
		Zend_Db_Table::setDefaultAdapter($db);

		$frontendOptions = array('automatic_serialization' => true);//cache is valid for ever
		$backendOptions = array('cache_dir' => $root.'/application/tmp/');

		$cache = Zend_Cache::factory('Core','File',$frontendOptions,$backendOptions);

    	Zend_Db_Table_Abstract::setDefaultMetadataCache($cache);
    	return $db;
    }
    /**
     * Initialize action helpers
     *
     * @return void
     */
    protected function _initHelpers()
    {
    	$this->bootstrap('controller');
    	// register the default action helpers
    	$root = Zend_Registry::get('root');
    	Zend_Controller_Action_HelperBroker::addPath($root .'/application/default/helpers', 'Precurio_Helper');

    }
 	protected function _initLanguages()
    {

    	$this->bootstrap('config');
    	$this->bootstrap('controller');

    	$root = Zend_Registry::get('root');

    	$frontendOptions = array('automatic_serialization' => true,'lifetime' => 21600);//cache is valid for 6 hrs
		$backendOptions = array('cache_dir' => $root.'/application/tmp/');

		$cache = Zend_Cache::factory('Core',
		'File',
		$frontendOptions,
		$backendOptions);

		Zend_Translate::setCache($cache);

		//get locale settings for registry
    	$registry = Zend_Registry::getInstance();
		$config = $registry->get('config');

   	 	try
        {
            $user = UserUtil::getUser(Precurio_Session::getCurrentUserId());
            if($user == null)
            {
            	Precurio_Session::logOut();
            	throw new Exception('User has been deactivated');
            }

            $userSettings = $user->getSettings();
            $loc = $userSettings->getLocale();
            $locale = new Zend_Locale($loc);
            if(!$locale->isLocale($locale))throw new Zend_Locale_Exception("User locale is invalid");
        }
    	catch (Exception $e)//i.e there was a problem retrieving the session user
        {
        	$loc = $config->default_locale;
            $locale = new Zend_Locale($loc);
            $log = Zend_Registry::get('log');
			$log->err($e);
        }


		$lang = $locale->getLanguage();
		$region = $locale->getRegion();
		//$t_file => translation file
		$t_file = $root ."/application/languages/$lang/LC_MESSAGES/$loc.mo";
		if(!file_exists($t_file))
			$t_file = $root .'/application/languages/'.$lang.'/LC_MESSAGES/precurio.mo';



		$translate = new Zend_Translate(array(
				'adapter'=>'gettext',
				'disableNotices'=>true
		));

		$translate->getAdapter()->addTranslation(array(
						'content' => $t_file,
						'locale' => $locale
		));

		$translate->setLocale($locale);

		date_default_timezone_set('Africa/Lagos');
		if(!empty($config->timezone))
			date_default_timezone_set($config->timezone);

		$registry->set('Zend_Translate', $translate);
		$registry->set('Zend_Locale', $locale);
    }
  	/**
     * Initialize routes
     *
     * @return void
     */
    protected function _initRoutes()
    {
    	if(!Zend_Registry::isRegistered('app'))
		{
			echo "Could not load application extension";
			die();
		}
    	$this->bootstrap('controller');

    	$router = Zend_Controller_Front::getInstance()->getRouter();

    	$router->addRoute('workflow',new Zend_Controller_Router_Route('workflow/new/:id',
																			array('module'=>'workflow',
																			'controller' => 'process',
																			'action' => 'new',
																			'id' =>1)));

		$router->addRoute('workflow2',new Zend_Controller_Router_Route('workflow/view/:id',
																			array('module'=>'workflow',
																			'controller' => 'process',
																			'action' => 'view',
																			'id' =>1)));

		$router->addRoute('cms_content',new Zend_Controller_Router_Route('cms/:action/:c_id',
				array('module'=>'cms',
						'controller' => 'index')));

		$router->addRoute('cms_site',new Zend_Controller_Router_Route('cms/site/:action/:id',
				array('module'=>'cms',
						'controller' => 'site')));
		$router->addRoute('teamrooms',new Zend_Controller_Router_Route('team/:action/:id',
				array('module'=>'team',
						'controller' => 'index',
						'action'=>'index',
						'id'=>0)));

		$router->addRoute('profile',new Zend_Controller_Router_Route('user/profile/view/:id/:page/:param1/:param2/:cpage',
																			array('module'=>'user',
																			'controller' => 'profile',
																			'action' => 'view',
																			'id'=>0,
																			'page'=>'recent',
																			'param1'=>'0',
																			'param2'=>'0',
																			'cpage'=>'0')));


    }
	/**
     * Initialize Session
     *
     * @return void
     */
    protected function _initSession()
    {
    	$root = Zend_Registry::get('root');
    	$config = Zend_Registry::get("config");
    	Zend_Session::start(array(
    		'save_path'=>$root.'/application/tmp/',
        	'name'=>empty($config->session_id_prefix) ? "PRECURIOSESSID" : $config->session_id_prefix,
    		'remember_me_seconds'=>$config->expire_after
        ));
    }
	/**
     * Initialize logs
     *
     * @return void
     */
    protected function _initLog()
    {
    	$log = new Precurio_Log();
    	Zend_Registry::set('log',$log);
    	return $log;

    }
	protected function _initRequest()
	{
	    $front = Zend_Controller_Front::getInstance();
	    $request = $front->getRequest();
	    if (null === $request) {
	        $request = new Zend_Controller_Request_Http();
	        $front->setRequest($request);
	    }
	    return $request;
	}
	public static function encrypt($str)
	{
		$key = rand(1,6);
		$arr = str_split($str);
		for($i=0;$i<count($arr);$i++)
		{
			$arr[$i] = chr(ord($arr[$i]) +$key);
		}
		$arr[] = chr($key+65);
		return implode('',$arr);

	}

	/**
	 * Returns an array of Precurio_Module objects of enabled modules.
	 * @param boolean $onlyActive - Determine if you want to get only active modules or you also want to include inactive ones. Default = true i.e. get only active modules
	 * @return array
	 */
	public static function getModules($onlyActive=true)
	{
		$config = Zend_Registry::get('config');
   		$arr = $config->module->toArray();//$arr = Array([mod_employee] => 1,[mod_event] => 1,[mod_contact] => 1 ...
   		$modules = array();
   		foreach($arr as $key=>$value)
   		{
   			$key = substr($key,4);//change 'mod_employee' to 'employee'
   			$value = (int)$value;
   			try
   			{
   				if($value >= (int)$onlyActive)
   				{
   					$module = new Precurio_Module($key,$value);
   					$modules[] = $module;
   				}
   			}
   			catch(Exception $e)
   			{
   				continue;
   			}
   		}
   		return $modules;
	}
	public static function isActiveModule($moduleName)
	{
		if(strtolower(substr($moduleName,0,3)) != 'mod')$moduleName = "mod_".$moduleName;
		$config = Zend_Registry::get('config');
		$arr = $config->module->toArray();
		if(empty($arr[$moduleName]))return false;
		return $arr[$moduleName] == 1;
	}
	/**
	 * Returns an array of Precurio_Widget objects of enabled modules.
	 * @param boolean $onlyActive - Determine if you want to get only active widgets or you also want to include inactive ones. Default = true i.e. get only active modules
	 * @return array
	 */
	public static function getWidgets($onlyActive=true)
	{
		$config = Zend_Registry::get('config');
   		$arr = $config->widget->toArray();//$arr = Array([wgt_poll] => 1,[wgt_link] => 1,....
   		$widgets = array();
   		foreach($arr as $key=>$value)
   		{
   			$key = substr($key,4);//change 'wgt_poll' to 'poll'
   			$value = (int)$value;
   			try
   			{
   				if($value >= (int)$onlyActive)
   				{
   					$widget = new Precurio_Widget($key,$value);
   					$widgets[] = $widget;
   				}
   			}
   			catch(Exception $e)
   			{
   				continue;
   			}
   		}
   		return $widgets;
	}
	/**
	 * Returns all availabe language translation in Precurio
	 * @return array of Precurio_Language objects
	 */
	public static function getLanguages()
	{
		$config = Zend_Registry::get('config');
   		$arr = $config->language->language->toArray();
   		$languages = array();
   		foreach($arr as $key=>$value)
   		{
   			$languages[] = new Precurio_Language($key,$config->language->language->{$key}->toArray());
   		}
   		//perform binary sort. to sort languages alphabetically A....Z.
   		for($j=0;$j<=count($languages)-1;$j++)
   		{
   			for($i=0;$i<=count($languages)-1;$i++)
   			{
   				if($languages[$i]->getLabel() > $languages[$j]->getLabel())
   				{
   					$temp = $languages[$j];
   					$languages[$j] = $languages[$i];
   					$languages[$i] = $temp;
   				}
   			}
   		}
   		return $languages;
	}
	/**s
	 * Determines if Precurio uses the database for user authentication & management
	 * @return boolean
	 */
	public static function usesDatabase()
	{
		$config = Zend_Registry::get('config');
		return $config->auth_mech == 'DatabaseAuth';
	}

	public static function isHosted()
	{
		$license = new Precurio_License();
		$type = $license->getType();
		return $type == 'SAAS' || $type == 'HOSTED';
	}
}
/**
 * Returns a string with some variables replaced
 * E.g.:
 * $str    = "Page {1}  ({1}/{2})";
 * $arg1   = "1";
 * $arg2   = "5";
 * echo localizedString($str,$arg1,$arg2);
 * would return: Page 1 (1/5)
 * @author http://moinne.com/blog/ronald/php/php-function-localizedstring/
 */
function getLocalizedString() {
	$patterns     = array();
	$replacements = array();
	$text         = func_get_arg(0);
	$numArgs      = func_num_args();

	for ($i = 1; $i < $numArgs; $i++) {
		$patterns[]     = '/\{'.$i.'\}/';
		$replacements[] = func_get_arg($i);
	}

	return preg_replace ($patterns, $replacements, $text);
}
/**
 * Detect agent browser
 *
 * @return string The client's browser
 */
function detectBrowser() {
	$mobileAgents = array('iphone', 'ipad', 'ipod', 'blackberry', 'htc', 'palm', 'windows ce',
			'windows phone','avantgo','blazer','compal','elaine','iemobile','kindle','opera mobi','opera mini',
			'treo','vodafone', 'android', 'midp', 'symbian','psp','hiptop');
	$agent = $_SERVER['HTTP_USER_AGENT'];

	switch (true) {
		case preg_match("/(".implode("|", $mobileAgents).")/i", $agent) != 0: $browser = 'mobile'; break;
		case stripos($agent, 'firefox')  !== false: $browser = 'firefox'; break;
		case stripos($agent, 'msie 6.0') !== false: $browser = 'ie6'; break;
		case stripos($agent, 'msie') !== false: $browser = 'ie'; break;
		case stripos($agent, 'chrome') !== false: $browser = 'chrome'; break;
		case stripos($agent, 'safari') !== false: $browser = 'safari'; break;
		default: $browser = 'ie'; break;
	}

	return $browser;
}
?>