<?php

	//We need to load Zend Framework because of the translation, and in future because of multiple db support
	/****************************Code to load Zend Framework starts here*******************************/
	defined('APPLICATION_PATH')
	    || define('APPLICATION_PATH', realpath(dirname(__FILE__)));
	set_include_path(implode(PATH_SEPARATOR, array(
	    realpath(APPLICATION_PATH . '/../../library'),
	    get_include_path(),
	)));


	require_once "Zend/Loader.php";
	require_once 'Zend/Loader/Autoloader.php';

	$autoloader = Zend_Loader_Autoloader::getInstance();
	        $autoloader->setFallbackAutoloader(true);

	$root = realpath(dirname(__FILE__) . '/../../');
	Zend_Registry::set('root',$root);

	$config = new Zend_Config_Ini($root.'/application/configs/precurio_tmp.ini',null,array('allowModifications'=>true));
	Zend_Registry::set('config',$config);

	/****************************Code to load Zend Framework stops here*******************************/
	deleteTmpDir();



	function deleteTmpDir()
	{
		$root = Zend_Registry::get('root');
		recursive_remove_directory($root.'/application/tmp',TRUE);
	}
	function deleteInstallDir()
	{
		$root = Zend_Registry::get('root');
		recursive_remove_directory($root.'/public/install');
	}
	function checkIoncube()
	{
		global $tr;
		if(extension_loaded('ionCube Loader'))
			return new CheckStatus(true, $tr->translate("ionCube Loader is installed"),$tr->translate('installed'));
		return new CheckStatus(false, $tr->translate("You don't have ionCube loader install."),$tr->translate('not installed'));
	}
	function checkMysQL()
	{
		global $tr;
		if(extension_loaded('pdo_mysql'))
			return new CheckStatus(true, $tr->translate("PDO_MySQL extension is enabled"),$tr->translate('enabled'));
		return new CheckStatus(false, $tr->translate("Please enable the PDO_MySQL extension in php.ini"),$tr->translate('disabled'));
	}
	function checkMysQLVersion()
	{
		global $tr;
		$db = getDb();
		$version = $db->getServerVersion();
		if(substr($version, 0,3) >= "5.1")
			return new CheckStatus(true, $tr->translate("MySQL server version is okay"),$version);
		return new CheckStatus(false, $tr->translate("Your MySQL server does not meet requirement, please upgrade to version 5.1 and above"),$version);
	}
	function checkGD()
	{
		global $tr;
		if(extension_loaded('gd') || !extension_loaded('gd2'))
			return new CheckStatus(true, $tr->translate("GD extension is enabled"),$tr->translate('enabled'));
		return new CheckStatus(false, $tr->translate("Please enable the GD extension in php.ini"),$tr->translate('disabled'));
	}
	function checkCurl()
	{
		global $tr;
		if(extension_loaded('curl'))
			return new CheckStatus(true, $tr->translate("cURL extension is enabled"),$tr->translate('enabled'));
		return new CheckStatus(false, $tr->translate("Please enable the cURL extension in php.ini"),$tr->translate('disabled'));
	}
	function checkPHPVersion()
	{
		global $tr;
		$version = phpversion();
		if(substr($version, 0,3) >= "5.3")
			return new CheckStatus(true, $tr->translate("Your PHP version is okay."),$version);
		return new CheckStatus(false, $tr->translate("Your PHP version does not meet requirement, please upgrade to version 5.3 and above"),$version);
	}
	function checkApacheVersion()
	{
		global $tr;
		$version = apacheversion();$version = trim($version);
		if(empty($version))
			return new CheckStatus(true, $tr->translate("Your Apache Server version could not be determined. Please verify manually"),"(Unknown)");
		if(substr($version, 0,3) >= "2.2")
			return new CheckStatus(true, $tr->translate("Your Apache Server is ok"),$version);
		return new CheckStatus(false, $tr->translate("Your Apache server does not meet requirement, please upgrade to version 2.2 and above"),$version);
	}
	/**
	 * Check if Mod Rewrite is enabled
	 * @return CheckStatus
	 */
	function checkModRewrite()
	{
		global $tr;

		if( function_exists('apache_get_modules') && in_array('mod_rewrite',apache_get_modules()) )
			$mod_rewrite = TRUE;
		elseif( isset($_SERVER['IIS_UrlRewriteModule']) )
			$mod_rewrite = TRUE;
		elseif(!function_exists('apache_get_modules'))
			return new CheckStatus(true, $tr->translate("Mod Rewrite status could not be determined. Please verify manually."),"(Unknown)");
		else
			$mod_rewrite = FALSE;
		if($mod_rewrite)
			return new CheckStatus(true, $tr->translate("Rewrite module is enabled"),$tr->translate("enabled"));
		return new CheckStatus(false, $tr->translate("Mod Rewrite is not enabled. Please enable rewrite module."),$tr->translate("disabled"));
	}
	function apacheversion()
	{
		if (preg_match('|Apache\/(\d+)\.(\d+)\.(\d+)|', $_SERVER['SERVER_SOFTWARE'], $apver))
		{
	  		return  $apver[1].'.'.$apver[2].'.'.$apver[3];
		}
		else
		{
			$ver = @split("[/ ]",$_SERVER['SERVER_SOFTWARE']);
			$apver = "$ver[1] $ver[2]";
			return $apver;
		}
    }
	function getThemeStyle()
	{
		$config = Zend_Registry::get('config');
		$theme = $config->theme->default;
		$style = $config->theme->themes->{$theme}->default;
		return $theme.'/'.$style;
	}
	 /**
     * Returns the URL to the installation page
     * @return string
     */
    function getUrl()
    {
    	return getBaseUrl().'/install';
    }
    /**
     * Returns the URL to the Precurio base page (redirects to login page)
     * @return string
     */
    function getBaseUrl()
    {
    	if(isset($_SERVER['SCRIPT_URI']) && isset($_SERVER['SCRIPT_URL']))
    	{
    		$uri = $_SERVER['SCRIPT_URI'];
    		return substr($uri,0,strpos($uri,"/install")).'/';
    	}
    	else
    	{
    		$protocol = stristr($_SERVER['SERVER_PROTOCOL'],'https')===false ? 'http://' : 'https://';
    		$host = $protocol.$_SERVER['HTTP_HOST'];

    		$scriptPath = $_SERVER['PHP_SELF'];
    		$pos = stripos($scriptPath,'/install');

    		if($pos === false)return $host;

    		$path = substr($_SERVER['PHP_SELF'],0,$pos);

    		return $host.$path.'/';
    	}
    }
	function getTranslator($locale)
    {
    	if(Zend_Registry::isRegistered('Zend_Translate'))
    		return Zend_Registry::get('Zend_Translate');

    	$root = Zend_Registry::get('root');

    	$frontendOptions = array('automatic_serialization' => true,'lifetime' => 7200);//cache is valid for 2 hrs
		$backendOptions = array('cache_dir' => $root.'/application/tmp/');

		$cache = Zend_Cache::factory('Core',
		'File',
		$frontendOptions,
		$backendOptions);

		Zend_Translate::setCache($cache);

		//get locale settings for registry
    	$registry = Zend_Registry::getInstance();
		$locale = new Zend_Locale($locale);
		if(!$locale->isLocale($locale))$locale = new Locale("en");

		$lang = $locale->getLanguage();
		$region = $locale->getRegion();
		//$t_file => translation file
		$t_file = $root ."/application/languages/$lang/LC_MESSAGES/".$lang.'_'."$region.mo";
		if(!file_exists($t_file))
			$t_file = $root .'/application/languages/'.$lang.'/LC_MESSAGES/precurio.mo';

		if(!file_exists($t_file))
		{
			$locale = "en";
			$t_file = $root .'/application/languages/en/LC_MESSAGES/precurio.mo';
		}

		$translate = new Zend_Translate(array(
				'adapter'=>'gettext',
				'disableNotices'=>true
		));

		$translate->getAdapter()->addTranslation(array(
						'content' => $t_file,
						'locale' => $locale
		));

		$translate->setLocale($locale);

		$config = Zend_Registry::get('config');
		$config->default_locale = $locale;
		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $root.'/application/configs/precurio_tmp.ini'));
		$item->write();

		$registry->set('Zend_Translate', $translate);
		$registry->set('Zend_Locale', $locale);
		return $translate;
    }
    function getLanguages()
    {
    	$config = Zend_Registry::get('config');
    	$arr = $config->language->language->toArray();
    	$languages = array();
    	foreach($arr as $key=>$value)
    	{
    		$languages[] = new Precurio_Language($key,$config->language->language->{$key}->toArray());
    	}
    	//perform binary sort. to sort languages alphabetically A....Z.
    	for($j=0;$j<=count($languages)-1;$j++)
    	{
	    	for($i=0;$i<=count($languages)-1;$i++)
	    	{
		    	if($languages[$i]->getLabel() > $languages[$j]->getLabel())
		    	{
		    	$temp = $languages[$j];
		    		$languages[$j] = $languages[$i];
		    		$languages[$i] = $temp;
		    	}
	    	}
    	}
    	return $languages;
    }
    function getDb()
    {
    	$root = Zend_Registry::get('root');
    	$config = Zend_Registry::get('config');

    	$active_db = $config->active_database;
    	$db_config = new Zend_Config_Ini($root.'/application/configs/precurio_tmp.ini',$active_db);

    	$db_config = $db_config->toArray();
    	$db_config = $db_config['database'];

    	$adapter = $db_config['adapter'];
    	$params = array();
    	foreach ($db_config as $key=>$value) {
    		if($key == 'adapter')continue;
    		$params[$key] = $value;
    	}

    	$db = Zend_Db::factory($adapter,$params);
    	if($config->database_auto_connect)
    	{
    		try {
    			$db->getConnection();
    		}
    		catch(Zend_Db_Exception $e)
    		{
    			throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
    		}
    		catch(Zend_Exception $e)
    		{
    			throw new Precurio_Exception($e->getMessage(),Precurio_Exception::EXCEPTION_DATABASE_CONNECTION);
    		}
    		$db->closeConnection();
    	}

    	Zend_Registry::set('db',$db);
    	Zend_Db_Table::setDefaultAdapter($db);

    	$frontendOptions = array('automatic_serialization' => true);//cache is valid for ever
    	$backendOptions = array('cache_dir' => $root.'/application/tmp/');

    	$cache = Zend_Cache::factory('Core','File',$frontendOptions,$backendOptions);

    	Zend_Db_Table_Abstract::setDefaultMetadataCache($cache);
    	return $db;
    }
    // ------------ lixlpixel recursive PHP functions -------------
	// recursive_remove_directory( directory to delete, empty )
	// expects path to directory and optional TRUE / FALSE to empty
	// of course PHP has to have the rights to delete the directory
	// you specify and all files and folders inside the directory
	// ------------------------------------------------------------

	// to use this function to totally remove a directory, write:
	// recursive_remove_directory('path/to/directory/to/delete');

	// to use this function to empty a directory, write:
	// recursive_remove_directory('path/to/full_directory',TRUE);

   	function recursive_remove_directory($directory, $empty=FALSE)
	{
		// if the path has a slash at the end we remove it here
		if(substr($directory,-1) == '/')
		{
			$directory = substr($directory,0,-1);
		}

		// if the path is not valid or is not a directory ...
		if(!file_exists($directory) || !is_dir($directory))
		{
			// ... we return false and exit the function
			return FALSE;

		// ... if the path is not readable
		}elseif(!is_readable($directory))
		{
			// ... we return false and exit the function
			return FALSE;

		// ... else if the path is readable
		}else{

			// we open the directory
			$handle = opendir($directory);

			// and scan through the items inside
			while (FALSE !== ($item = readdir($handle)))
			{
				// if the filepointer is not the current directory
				// or the parent directory
				if($item != '.' && $item != '..')
				{
					// we build the new path to delete
					$path = $directory.'/'.$item;

					// if the new path is a directory
					if(is_dir($path))
					{
						// we call this function with the new path
						recursive_remove_directory($path);

					// if the new path is a file
					}else{
						// we remove the file
						unlink($path);
					}
				}
			}
			// close the directory
			closedir($handle);

			// if the option to empty is not set to true
			if($empty == FALSE)
			{
				// try to delete the now empty directory
				if(!rmdir($directory))
				{
					// return false if not possible
					return FALSE;
				}
			}
			// return success
			return TRUE;
		}
	}
	/**
	 * Returns a string with some variables replaced
	 * E.g.:
	 * $str    = "Page {1}  ({1}/{2})";
	 * $arg1   = "1";
	 * $arg2   = "5";
	 * echo localizedString($str,$arg1,$arg2);
	 * would return: Page 1 (1/5)
	 * @author http://moinne.com/blog/ronald/php/php-function-localizedstring/
	 */
	function getLocalizedString() {
		$patterns     = array();
		$replacements = array();
		$text         = func_get_arg(0);
		$numArgs      = func_num_args();

		for ($i = 1; $i < $numArgs; $i++) {
			$patterns[]     = '/\{'.$i.'\}/';
			$replacements[] = func_get_arg($i);
		}

		return preg_replace ($patterns, $replacements, $text);
	}

	class CheckStatus
	{
		private $status;
		private $message;
		private $value;
		/**
		 * Enter description here ...
		 * @param boolean $status
		 * @param string $message
		 * @param string $value
		 */
		public function __construct($status,$message,$value="")
		{
			$this->status = $status;
			$this->message = $message;
			$this->value = $value;
		}
		public function getIcon()
		{
			return ($this->status ? 'tick.png' : 'cross.png');
		}
		public function getMessage()
		{
			return $this->message;
		}
		public function getStatus()
		{
			return $this->status;
		}
		public function getValue()
		{
			return $this->value;
		}
	}
?>