<?php
//Handles all form submissions
	ob_start();
	$installFolder = realpath(dirname(__FILE__).'/tmp');
    ini_set("session.save_handler", "files");
    ini_set("session.save_path",$installFolder);
    session_id("precurioinstall");
    session_start();
	require_once 'functions.php';
	require_once 'rest_curl_client.php';
	require_once 'xmltoarray.php';
	sleep(1);

	$fn = $_GET['fn'];
	switch($fn)
	{
		case "register":
			registerSoftware();
			break;
		case "company":
			registerCompany();
			break;
		case "login":
			login();
			break;
		case "database":
			saveDbSettings();
			break;
		case "admin":
			saveUserInfo();
			break;
		case "ldap":
			ldapConnect();
			break;
		case "settings":
			finalSetup();
			break;
	}

	function finalSetup()
	{
		$data = $_POST;
		$obj = new stdClass();

		//write final settings to config
		$config = Zend_Registry::get('config');
		$root = Zend_Registry::get('root');

		$email = $_SESSION['admin']['email'];
		$company_name = $_SESSION['admin']['company_name'];
		$domain = substr($email, stripos($email,"@"));

		$timezone = @date_default_timezone_get();

		if(!($timezone && strlen($timezone) > 6))
			$timezone = "Europe/London";

		$config->welcome_text = "Welcome to your Portal";
		$config->timezone = $timezone;
		$config->enviroment = "production";
		$config->company_name = $company_name;
		$config->auth_mech = "DatabaseAuth";
		$config->base_url = getBaseUrl();
		$config->email_domain = $domain;
		$config->domain = $domain;
		$config->default_locale = $data['locale'];

		$config->session_id_prefix = "PRECURIOSESSID".time();

		$item = new Precurio_ConfigWriter(array('config'   => $config,
				'filename' => $root.'/application/configs/precurio_tmp.ini'));
		$item->write();

		//create database
		$result = createMySQLDatabase($_SESSION['database']);
		if($result && isset($result->error))//if there was an error creating the database
		{
			sendToBrowser($result);
			return;
		}

		//create user
		unset($result);
		$result = createUser($_SESSION['admin']);
		if($result && isset($result->error))//if there was an error creating the user
		{
			sendToBrowser($result);
			return;
		}

		//install necessary data
		try {
			if($data['demo_data'])
			{
				insertDemoData();
			}
			else
			{
				insertDefaultData();
			}

			if(strtolower($data['auth_mech']) == "ldapauth")
			{
				performLdapUpdates();
			}

		}
		catch (Exception $e)
		{
			$obj->error = true;
			$obj->message = $e->getMessage();
			sendToBrowser($obj);
			return;
		}

		//copy the htaccess file to public folder. Remember we didn't include the .htaccess file in installation
		//package because of error 505 on some servers.
		@copy("htaccess.txt", $root."/public/.htaccess");
		//replace root index file with one that redirects to login page rather than install page
		@unlink($root."/index.php");
		@copy("temp.php", $root."/index.php");
		//replace public index file
		@unlink($root."/public/index.php");
		@copy("original/index.php", $root."/public/index.php");

		//replace install index file with one that tells user "installation is complete"
		@unlink("index.php");
		@copy("index2.php", "index.php");

		//rename tmp config as permanent config.
		copy($root.'/application/configs/precurio_tmp.ini', $root.'/application/configs/precurio.ini');

		$_SESSION['settings'] = $data;//used by finish.php do display demo users login info

		//now send installation complete to API. REMEMBER, user cannot get to this point without registering or login.
		//so user information definitely exists in precurio records
		$data = array_merge($data, $_SESSION['admin']);//just lump all previous infortmation
		$data['identity'] = $data['email'];
		$data['credential'] = $data['password'];
		$data['source'] = "Trial";//this is used by the CRM API
		$data['install'] = "Completed";//this is used by the CRM API, so we can know those who completed installation, so we can offer setup assistance
		$data['demo'] = $data['demo_data'] ? "Yes" : "No";//this is used by the CRM API, so we can know those who are doing a demo.
		unset($data['credential']);unset($data['password']);//do not send password.
		if(strtolower($data['auth_mech']) == "ldapauth")$data['ad'] = "Yes";//we know those using AD. so we can offer setup assistance.

		$post['data'] = $data;
		$post = json_decode (json_encode ($post), FALSE);//converts array to object

	   try {
			//we really do not need the result. We just assume all works fine.
			$post = json_encode($post);
			$res = sendToAPI('contact/register', $post, array(CURLOPT_HTTPHEADER =>  array("Content-Type: application/json;","Accept:application/json, text/javascript")));
		}
		catch(Exception $e)
		{
			//$obj->error = true;
			//$obj->message = $e->getMessage();
			//sendToBrowser($obj);
			//return;
		}
		sendToBrowser($obj);
	}
	/**
	 * Updates the database for AD / LDAP scenarios.
	 * Basically, all we need to do is deleting the roles table, so that there is no ACL issues.
	 * And update the group names with the most likely scenarios.
	 */
	function performLdapUpdates()
	{
		$config = Zend_Registry::get('config');
		try {
			$dbh = new PDO('mysql:host='.$config->mysql->database->host.';dbname='.$config->mysql->database->dbname, $config->mysql->database->username, $config->mysql->database->password);
			$sql = "TRUNCATE roles;";
			$dbh->exec($sql);

		}
		catch (PDOException $e) {
			throw $e;
		}

		$table = new Zend_Db_Table(array('name'=>"groups"));
		$table->update(array("is_role"=>0), "id > 0");
		$table->update(array("title"=>"Domain Admins"), "title = 'Administrators'");
		$table->update(array("title"=>"Domain Users"), "title = 'Staff'");
	}
	function saveUserInfo()
	{
		$data = $_POST;
		//store data in session
		$_SESSION['admin'] = $data;
		$obj = new stdClass();
		sendToBrowser($obj);
		return;
	}
	function createUser($data)
	{
		$obj = new stdClass();

		try {
			$db = getDb();

			$data['date_created'] = time();
			$data['username'] = (stripos($data['email'],'@') === false ? $data['email'] : substr($data['email'],0,strpos($data['email'],'@')));
			$data['password'] = md5($data['password']);

			//create user in authentication table
			$table = new Zend_Db_Table(array('name'=>"p2_users"));
			$user_id = $table->insert(array(
					'identity'=>$data['email'],
					'credential'=>$data['password'],
					'date_created'=>$data['date_created']
			));
			$data['user_id'] = $user_id;
			//create user details
			$table = new Zend_Db_Table(array('name'=>"user_details"));
			$row  = $table->createRow();$row->setFromArray($data);
			$id  = $row->save();
			$obj->user_id = $user_id;
		}
		catch (Exception $e)
		{
			$obj->error = true;
			$obj->message = $e->getMessage();
			sendToBrowser($obj);
			return;
		}
		return $obj;
	}

	function saveDbSettings()
	{
		$data = $_POST;
		$obj = new stdClass();

		$config = Zend_Registry::get('config');
		$root = Zend_Registry::get('root');

		$config->mysql->database->host = $data['host'];
		$config->mysql->database->port = $data['port'];
		$config->mysql->database->username = $data['username'];
		$config->mysql->database->password = $data['password'];
		$config->mysql->database->dbname = $data['database'];

		$item = new Precurio_ConfigWriter(array('config'   => $config,
				'filename' => $root.'/application/configs/precurio_tmp.ini'));
		$item->write();

		//store data in session
		$_SESSION['database'] = $data;

		sendToBrowser($obj);
		return;
	}
	function createMySQLDatabase($data)
	{
		$obj = new stdClass();


		try {
			//$dbh = new PDO('mysql:host='.$data['host'].';dbname='.$data['test_db'], $data['username'], $data['password']);
			$dbh = new PDO('mysql:host='.$data['host'].';', $data['username'], $data['password']);
			//create db
			$sql = file_get_contents("sql/create_db.sql");
			$sql = getLocalizedString($sql,$data['database']);
			$dbh->exec($sql);
			$dbh = null;

			//create tables
			$dbh = new PDO('mysql:host='.$data['host'].';dbname='.$data['database'], $data['username'], $data['password']);
			$sql = file_get_contents("sql/create_tables.sql");
			$dbh->exec($sql);
			$dbh = null;

		}
		catch (PDOException $e) {
			$obj->error = true;
			$obj->message = $e->getMessage();
			sendToBrowser($obj);
			return;
		}

		return $obj;
	}
	function ldapConnect()
	{
		$data = $_POST;
		$obj = new stdClass();

		$params = array(
				'server1'=>array(
						'host'=>$data['host'],
						'port'=>$data['port'],
						'useSsl'=>$data['useSsl'],
						'accountDomainName'=>$data['accountDomainName'],
						'baseDn'=>$data['baseDn'],
						'username'=>$data['username'],
						'password'=>$data['password'],
						'bindRequiresDn'=>$data['bindRequiresDn']
				)
		);
		try {

			$ldap = new Zend_Auth_Adapter_Ldap($params,$data['username'],$data['password']);

			$result = $ldap->authenticate();
			$messages = $result->getMessages();
			if($result->isValid())
			{
				//set config
				$config = Zend_Registry::get('config');
				$root = Zend_Registry::get('root');

				foreach($data as $key=>$value)
				{
					if(isset($config->ldap->ldap->server1->{$key}))
						$config->ldap->ldap->server1->{$key} = $value;
				}
				$item = new Precurio_ConfigWriter(array('config'   => $config,
						'filename' => $root.'/application/configs/precurio_tmp.ini'));
				$item->write();

				//store data in session
				$_SESSION['ldap'] = $data;
				$_SESSION['admin'] = array(
					//in future we can ask the user to test login, and store the details here
				);
			}
			else
			{
				$obj->error = true;
				$obj->message = implode("<br/>",$messages)	;
			}
		}
		catch(Exception $e)
		{
			$obj->error = true;
			$obj->message = $e->getMessage();
		}
		sendToBrowser($obj);
	}
	function registerSoftware()
	{
		$data = $_POST;
		$obj = new stdClass();

		$domain = substr($data['email'], stripos($data['email'],"@"));

		//set config
		$config = Zend_Registry::get('config');
		$root = Zend_Registry::get('root');

		$config->company_name = $data['company_name'];
		$config->auth_mech = $data['auth_mech'];
		$config->base_url = getBaseUrl();
		$config->email_domain = $domain;
		$config->domain = $domain;

		$item = new Precurio_ConfigWriter(array('config'   => $config,
				'filename' => $root.'/application/configs/precurio_tmp.ini'));
		$item->write();

		//store data in session
		$_SESSION['register'] = $data;
		if($data['auth_mech'] == "LdapAuth")
			$_SESSION['ldap'] = true;

		//now send registration to API
		$full_name = explode(" ", $data['full_name'],2);
		$data['first_name'] = $full_name[0];
		$data['last_name'] = $full_name[1];
		$data['identity'] = $data['email'];
		$data['credential'] = $data['password'];
		$data['source'] = "Trial";//this is used by the CRM API
		$data['install'] = "Started";//this is used by the CRM API, so we can know those who completed installation
		$post['data'] = $data;
		$post = json_decode (json_encode ($post), FALSE);//converts array to object

		try {
			$post = json_encode($post);
			$result = sendToAPI('user/register', $post, array(CURLOPT_HTTPHEADER =>  array("Content-Type: application/json;","Accept:application/json, text/javascript")));
		}
		catch(Exception $e)
		{
			$obj->error = true;
			$obj->message = $e->getMessage();
			sendToBrowser($obj);
			return;
		}
		//check result from server to make sure all is well.
		$result = json_decode($result);
		if(empty($result))
		{
			$obj->error = true;
			$obj->message = "Invalid Response from Server";
		}
		elseif(isset($result->error))
		{
			$obj->error = true;
			$obj->message = $result->error->message;
		}

		sendToBrowser($obj);
	}
	function registerCompany()
	{
		$data = $_POST;
		$obj = new stdClass();

		//store data in session
		$_SESSION['register'] = $data;

		sendToBrowser($obj);
	}
	function login()
	{
		$data = $_POST;
		$obj = new stdClass();

		try {

			//send login info to API
			$post['data'] = $data;
			$post = json_decode (json_encode ($post), FALSE);//converts array to object

			$post = json_encode($post);
			$result = sendToAPI('user/login', $post, array(CURLOPT_HTTPHEADER =>  array("Content-Type: application/json;","Accept:application/json, text/javascript")));
		}
		catch (Exception $e)
		{
			$obj->error = true;
			$obj->message = $e->getMessage();
			sendToBrowser($obj);
			return;
		}

		$result = json_decode($result);
		if(empty($result))
		{
			$obj->error = true;
			$obj->message = "Invalid Response from Server";
		}
		elseif(isset($result->error))
		{
			$obj->error = true;
			$obj->message = $result->error->message;
		}
		else
		{
			//set config only after successful login
			$config = Zend_Registry::get('config');
			$root = Zend_Registry::get('root');

			$config->company_name = empty($data['company_name']) ? $result->company : $data['company_name'];//if user didn't enter company name, then use user information
			$config->auth_mech = $data['auth_mech'];
			$config->base_url = getBaseUrl();
			$domain = substr($data['email'], stripos($data['email'],"@"));
			$config->email_domain = $domain;
			$config->domain = $domain;

			$item = new Precurio_ConfigWriter(array('config'   => $config,
					'filename' => $root.'/application/configs/precurio_tmp.ini'));
			$item->write();

			$_SESSION['ldap'] = $data['auth_mech'] == "LdapAuth" ? true : false;//so that it displays the AD form instead of admin form


			$result->full_name = $result->first_name.' '.$result->last_name;//so that admin page will be able to get this
			$_SESSION['register'] = json_decode(json_encode($result), true);//convert json into assoc. array
			$_SESSION['register']['auth_mech'] = $data['auth_mech'];//save this so that it is posted at finalsetup to API

			$obj->username = $result->username;//not necessary actualy.
		}
		sendToBrowser($obj);
	}
	function sendToBrowser($result)
	{
		ob_clean();
		//clean error message
		if(isset($result->error) && $result->error && $result->message)
		{
			$result->message = str_ireplace("allclients", "precurio", $result->message);//remove occurances of "allclients"
		}
		echo json_encode($result);
		ob_end_flush();
	}

	/**
	 * Read data directory and insert data into db
	 */
	function insertDemoData()
	{
		set_time_limit(300);//five minutes maximum execution time
		//first lets truncate the user tables. We still have user information in session.
		//get connection setting from session
		$con = $_SESSION['database'];
		$dbh = new PDO('mysql:host='.$con['host'].';dbname='.$con['database'], $con['username'], $con['password']);
		$sql = "TRUNCATE TABLE `p2_users`; TRUNCATE TABLE `user_details`";
		$dbh->exec($sql);
		$dbh = null;
		//done truncating

		$dir = "demo/data1/";
		//lets get the timestamp difference.
		$demoConfig = new Zend_Config_Ini($dir.'demo.ini',null);
		if(empty($demoConfig) || !isset($demoConfig->timestamp))//throw error is config not found
			throw new Exception("Invalid demo configuration");

		$timestamp = $demoConfig->timestamp;
		$timestampDiff = time() - $timestamp;//get difference between now and when demo was created
		//timestamp difference gotten

		//start csv data import

		$handle = opendir($dir);//for now, it's just data 1
		if ($handle) {
			while (false !== ($entry = readdir($handle))) {
				if(!is_file($dir.$entry))continue;//skip all directories
				loadCsv($dir.$entry,$timestampDiff);
			}
			closedir($handle);
		}
		//end csv import.


		//Update precurio config with appropraite widget settings.
		//NOTE: This should be the last time the config is modified during the installation process
		$demoConfig = new Zend_Config_Ini($dir.'/precurio.ini',null);
		$config = Zend_Registry::get('config');
		$root = Zend_Registry::get('root');

		$config->announcement->announcement->category_id = $demoConfig->announcement->announcement->category_id;
		$config->cms->cms->articles_category_id  = $demoConfig->cms->cms->articles_category_id;
		$config->cms->cms->news_category_id  = $demoConfig->cms->cms->news_category_id;
		$config->ads->ads->category_id  = $demoConfig->ads->ads->category_id;

		$item = new Precurio_ConfigWriter(array('config'   => $config,
				'filename' => $root.'/application/configs/precurio_tmp.ini'));
		$item->write();
		//end of config update


		//copy demo upload files
		$fn = new Precurio_FileFn();
		$fn->copy($dir.'uploads', $root.'/public/uploads');
		//end of copy demo upload files

		//load demo documents
		loadDemoDocuments();
		//end of copy demo upload files


		//finally, update first demo user with admin info. We want userid 1 to be admin.
		$admin = $_SESSION['admin'];//get admin from session
		$admin['password'] = md5($admin['password']);
		$db = getDb();
		$table = new Zend_Db_Table(array('name'=>"p2_users"));
		$user = $table->fetchRow("id = 1");
		$user->identity = $admin['email'];
		$user->credential = $admin['password'];
		$user->save();
		$table = new Zend_Db_Table(array('name'=>"user_details"));
		$user = $table->fetchRow("user_id = 1");
		$user->setFromArray($admin);
		$user->save();
		//End. first demo user now has same info as admin.
	}
	/**
	 * Read data directory and insert only default data into db
	 */
	function insertDefaultData()
	{
		set_time_limit(300);//five minutes maximum execution time

		//start csv data import
		$dir = "data/";
		$handle = opendir($dir);//for now, it's just data 1
		if ($handle) {
			while (false !== ($entry = readdir($handle))) {
				if(!is_file($dir.$entry))continue;//skip all directories
				loadCsv($dir.$entry);
			}
			closedir($handle);
		}
		//end csv import.
	}

	/**
	 * Loads a CSV file into a database table
	 * @param string $filepath - relative path to csv file
	 * @param integer $timestampDiff - Difference in timestamp between now and when the demo was created
	 */
	function loadCsv($filepath,$timestampDiff=0)
	{
		list( $dirname, $filename, $extension, $tablename ) = array_values( pathinfo($filepath) );

		if(strtolower($extension) != "csv")return false;//only csv file please

		$handle = fopen ( $filepath, "r" );
		if($handle ===  FALSE)return false; //could not find file

		$db = getDb();//initialise db
		$table = new Zend_Db_Table(array('name'=>$tablename));//initialise db table
		$table->getAdapter()->query('TRUNCATE TABLE '.$tablename);//truncate table

		//get first line, which is always the header
		$header = fgetcsv ( $handle, 1000, "," );

		//continue with rest of data
		$count = 0;
		while ( ($data = fgetcsv ( $handle, 1000, "," )) !== FALSE ) {
			$rowData = array_combine($header,$data);
			$row  = $table->createRow();
			$rowData = fixRowData($rowData, $timestampDiff);
			$row->setFromArray($rowData);
			$id  = $row->save();
			//now lets make sure there is database reconnection after a while
			$count++;
			if($count > 50)
			{
				$count = 0;//reset counter
				$db->closeConnection();//close connection
			}
		}

		fclose ( $handle );
		$db->closeConnection();
	}
	/**
	 * Fixes row data by striping slashed and modifying date information.
	 * Returns the fixed data
	 * @param array $row - Row data (associative array)
	 * @param string $timestampDiff - the timestamp difference between the time of the demo and now. We will use this to determine the relative current date of every row
	 * @return array
	 */
	function fixRowData($row,$timestampDiff)
	{
		$textCols = array("title","description","summary","body","message","job_description","skills");
		$dateCols = array("expires","date_created","last_modifed","start_timestamp","start_time","end_time","complete_time");

		foreach($row as $col=>$value)
		{
			if(in_array($col,$textCols))
				$row[$col] = stripslashes($value);

			//do not fix start_time for events but fix start_date instead
			if($col == "start_time" && isset($row['venue']))
			{
				$date = new Precurio_Date($row['start_date'],null,'de');//event date is stored in format dd-mm-yyy which is closest to deutch locale
				$date->addTimestamp($timestampDiff);
				$row['start_date'] = $date->get(Zend_Date::DATE_MEDIUM);
				continue;
			}

			//do not fix end_time for events but fix end_date instead
			if($col == "end_time" && isset($row['venue']))
			{
				$date = new Precurio_Date($row['end_date'],null,'de');//event date is stored in format dd-mm-yyy which is closest to deutch locale
				$date->addTimestamp($timestampDiff);
				$row['end_date'] = $date->get(Zend_Date::DATE_MEDIUM);
				continue;
			}

			//fix for others
			if(in_array($col,$dateCols) && !empty($value))
				$row[$col] = $value + $timestampDiff;

			//fix ids
			if(stripos($col,"id") && empty($row[$col]))
			{
				$row[$col] = 0;
			}

		}

		//fix special scenario. Polls end date
		if(isset($row['end_date']) && isset($row['multiple_answers']))
			$row['end_date'] = $row['end_date'] + $timestampDiff;

		return $row;
	}
	/**
	 * Since the documents.csv data file cannot contain the document contents, we load it here.
	 */
	function loadDemoDocuments()
	{
		$dir = "demo/data1/documents/";
		$db = getDb();
		$table = new Zend_Db_Table(array('name'=>"documents"));//initialise table
		$count = 0;

		$handle = opendir($dir);//for now, it's just data 1
		if ($handle) {
			//for each file in the directory
			while (false !== ($entry = readdir($handle))) {
				$filepath = $dir.$entry;
				if(!is_file($filepath))continue;//skip all directories

				//get the file id from the file path.
				list( $dirname, $filename, $extension, $fileID ) = array_values( pathinfo($filepath) );

				//get document object
				$row = $table->fetchRow("id = ".$fileID);
				if($row)
				{
					$content = file_get_contents($filepath);
					$row->file_content = $content;
					$row->save();
				}
				$content = "";
				$row = null;
				//now lets make sure there is database reconnection after a while
				$count++;
				if($count > 10)
				{
					$count = 0;//reset counter
					$db->closeConnection();//close connection
				}
			}
			closedir($handle);
		}
	}
	/**
	 * @param string $url e.g. "user/login"
	 * @param array $data - data to post
	 * @param array $postOptions OPTIONAL curl options
	 * @throws Exception
	 * @return void|Ambigous <Ambigous <multitype:, string>>
	 */
	function sendToAPI($url,$data,$postOptions=array())
	{
		//first check for CURL
		if(!extension_loaded('curl'))
		{
			throw new Exception("cURL extension not enabled! Please you must enable the cURL extension in php.ini");
		}
		$url = "http://api.precurio.com/".$url;
		$c = new RestCurlClient();
		$curlOptions = array(CURLOPT_SSL_VERIFYPEER=>false) + $postOptions;
		$res = $c->post($url, $data,$curlOptions);
		return $res;
	}
?>