<?php
//We need to load Zend Framework because of the translation, and in future because of multiple db support
/****************************Code to load Zend Framework starts here*******************************/
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__)));
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../../library'),
    get_include_path(),
)));


require_once "Zend/Loader.php";
require_once 'Zend/Loader/Autoloader.php';

$autoloader = Zend_Loader_Autoloader::getInstance();
        $autoloader->setFallbackAutoloader(true);

$root = realpath(dirname(__FILE__) . '/../../');
Zend_Registry::set('root',$root);

$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true));
Zend_Registry::set('config',$config);

define("PATH_TMP",$root. '/application/tmp/');//path to tmp folder

Zend_Session::start(array('save_path'=>PATH_TMP,
 			'name'=>empty($config->session_id_prefix) ? "PRECURIOSESSID" : $config->session_id_prefix));//6hrs

/****************************Code to load Zend Framework stops here*******************************/



require_once('Precurio.php');
$precurio = new Precurio(isset($_GET['userid']) ? $_GET['userid'] : 0);
$db = $precurio->getDb();//initialise database connection
$tr = $precurio->getTranslator();//initialise translation
$user = $precurio->getCurrentUser();

function createForm($formname, $formdesc, $user)
{
	$tr = Zend_Registry::get('Zend_Translate');
	if (verifyFormName($formname) < 1 )
	{
		$formcode = '';
		$my_values = explode(" ",$formname);
		$count_values = sizeof($my_values);
		$loop_count = 0;

		while ($loop_count < $count_values)
		{
			$formcode = $formcode. substr($my_values[$loop_count],0,1);
			$loop_count++;
		}

		try
		{
			$table = new Zend_Db_Table(array('name'=>"forms"));
			$id = $table->insert(array(
				'formName'=>$formname,
				'formDescription'=>$formdesc,
				'createdBy'=>$user,
				'formCode'=>$formcode,
				'active'=>1
			));
			$msg = $tr->translate('Success');
			header ("Location: form_design.php?id=$id");
		}
		catch (Exception $e)
		{
			$msg = $tr->translate('Unable to create form. Details - '.$e->getMessage());
		}
	}
	else

	{
		$msg = $tr->translate('Sorry, a form with this name already exists');

	}

	return($msg);
}


function updateForm($formid, $formname, $formdesc, $user, $formcode)
{
	$tr = Zend_Registry::get('Zend_Translate');

	if (verifyFormNameId($formname,$formid) < 1 )
	{
		try
		{
			$table = new Zend_Db_Table(array('name'=>"forms"));
			$form =  $table->fetchRow($table->select()->where("formid = ?",$formid));
			$form->setFromArray(array(
					'formName'=>$formname,
					'formDescription'=>$formdesc,
					'createdBy'=>$user,
					'formCode'=>$formcode
			));
			$form->save();
			$msg = $tr->translate('Form Successfully Updated');
		}
		catch (Exception $e)
		{
			$msg = $tr->translate('Unable to update form');
		}
	}
	else
	{
		$msg = $tr->translate('Sorry, a form with this name already exists');
	}

	return($msg);
}

/**
 * Verify how many other forms have the same name
 * @param string $formname
 * @return number
 */
function verifyFormName($formname)
{
	$table = new Zend_Db_Table(array('name'=>"forms"));
	$rows = $table->fetchAll($table->select()->where("formName = ?",$formname));
	return $rows->count();
}

/**
 * Verify if any other form has the same name.
 * @param string $formname
 * @param int $formid - ID of the original form
 * @return boolean
 */
function verifyFormNameId($formname,$formid)
{
	$table = new Zend_Db_Table(array('name'=>"forms"));
	$rows = $table->fetchAll($table->select()->where("formid <> ?",$formid)->where("formName = ?",$formname));
	return $rows->count();
}


function getFormDetails($formid)
{
	$table = new Zend_Db_Table(array('name'=>"forms"));
	return $table->fetchRow($table->select()->where("formid = ?",$formid));
}


function getActiveForms ()
{
	$table = new Zend_Db_Table(array('name'=>"forms"));
	return $table->fetchAll($table->select()->where("active = 1"));
}

function getLastRow($formid, $section)
{
	$table = new Zend_Db_Table(array('name'=>"components"));
	$row = $table->fetchRow($table->select()->where("componentform = ?",$formid)->where("section = ?",$section)->order("rowid DESC"));
	return ($row ? $row->rowid : 0);
}




function addComponent ($label, $form, $type, $required, $default, $section,$database="",$tablename="",$labelField="",$valueField="",$where="")
{
	$tr = Zend_Registry::get('Zend_Translate');
	try
	{
		$last_row_id = getLastRow($form,$section) + 1;

		$table = new Zend_Db_Table(array('name'=>"components"));
		$id = $table->insert(array(
				'componentform'=>$form,
				'rowid'=>$last_row_id,
				'section'=>$section,
				'componenttype'=>$type,
				'componentlabel'=>$label,
				'componentrequired'=>$required,
				'componentdefaultvalue'=>$default,
				'frm_database'=>$database,
				'frm_table'=>$tablename,
				'frm_label_field'=>$labelField,
				'frm_value_field'=>$valueField,
				'frm_where_clause'=>$where
		));
		$msg = $tr->translate('Success');
	}
	catch (Exception $e)
	{
		$msg = $tr->translate('Error creating component');
	}

	return ($msg);
}

function updateComponent ($componentid, $label, $required, $default,$database="",$tablename="",$labelField="",$valueField="",$where="")
{
	$tr = Zend_Registry::get('Zend_Translate');

	try
	{
		$component = getComponentDetails($componentid);

		$component->componentlabel = $label;
		$component->componentrequired = $required;
		$component->componentdefaultvalue = $default;
		$component->frm_database = $database;
		$component->frm_table = $tablename;
		$component->frm_label_field = $labelField;
		$component->frm_value_field = $valueField;
		$component->frm_where_clause =$where;

		$component->save();

		$msg = $tr->translate('Success');
	}
	catch(Exception $e)
	{
		$msg = $tr->translate('Error updating component');
	}

	return ($msg);
}

function deleteComponent ($componentid)
{
	$component = getComponentDetails($componentid);

	$tr = Zend_Registry::get('Zend_Translate');
	if ($component )
	{
		$component->delete();
		$msg = $tr->translate('Success');

	}
	else
	{
		$msg = $tr->translate('Error deleting component');
	}
	return ($msg);
}


function deleteSection ($sectionid)
{

	$section = getSectionDetails($sectionid);
	$tr = Zend_Registry::get('Zend_Translate');
	if ($section )
	{
		$section->delete();
		$msg = $tr->translate('Deleted');
	}
	else
	{
		$msg = $tr->translate('Error deleting section');
	}
	return ($msg);
}


function deleteForm ($formid)
{
	$tr = Zend_Registry::get('Zend_Translate');

	$form = getFormDetails($formid);
	if ($form)
	{
		$form->active = 0;
		$form->save();
		$msg = $tr->translate('Deleted');
	}
	else
	{
		$msg = $tr->translate('Error deleting form');
	}

	return ($msg);

}


function getAvailableComponents($formid,$section)
{
	$table = new Zend_Db_Table(array('name'=>"components"));
	return $table->fetchAll($table->select()->where("componentform = ?",$formid)->where("section = ?",$section)->order("rowid ASC"));
}

function pasteComponentCodes($type, $component)
{
  				$default = getComponentDefault($component);




				if ($type == 'text')
				{
					$code = '<input type="text"  value='.$default.'>';
				}
				elseif ($type == 'number')
				{
					$code = '<input type="text" value='.$default.'>';
				}

				elseif ($type == 'price')
				{
					$code = '<input type="text" value='.number_format($default).'>';
				}
				elseif ($type == 'radio')
				{
					$option = getComponentOptions ($component);
					$my_values = explode(",",$option);
					$count_values = sizeof($my_values);
					$loop_count = 0;
					$code = '';
					while ($loop_count < $count_values) {
		 					$code = $code. ' <input type="radio" name="radio'.$component.'" value="radio"> '. $my_values[$loop_count]. '<br/><hr>';
							 $loop_count++;
					}


				}
				elseif ($type == 'check')

				{
					$option = getComponentOptions ($component);
					$my_values = explode(",",$option);
					$count_values = sizeof($my_values);
					$loop_count = 0;
					$code = '';
					while ($loop_count < $count_values) {
		 					$code = $code. ' <input type="checkbox" name="chk'.$component.'" value="check"> '. $my_values[$loop_count]. '<br/><hr>';
							 $loop_count++;
					}


				}

				elseif ($type == 'textarea')
				{
					$code = '<textarea cols="17" rows="5">'.$default.'</textarea>';
				}
				elseif ($type == 'file')
				{
					$code = '  <input type="file" >';
				}
				elseif ($type == 'dropdown')
				{
					$option = getComponentOptions ($component);
					$my_values = explode(",",$option);
					$count_values = sizeof($my_values);
					$loop_count = 0;
					$code = '<select name="select" id="select">';
					while ($loop_count < $count_values) {
		 					$code = $code. ' <option>'. $my_values[$loop_count]. '</option>';
							 $loop_count++;
					}

					$code =$code. ' </select>';
				}
				elseif ($type == 'custom')
				{
					$data = getCustomComponentData($component);
					$code = '<select name="select" id="select">';
					foreach($data as $value=>$label)
					{
						$code = $code. ' <option>'. $label. '</option>';
					}

					$code =$code. ' </select>';
				}
				elseif ($type == 'date')
				{
					$code = '<input type="text"  id="txtfrom" name="txtfrom"  style="width:40%"  /></p>
      <script type="text/javascript">
      // <![CDATA[
        var opts = {
                // Attach input with an id of "dp-1" and give it a "d-sl-m-sl-Y" date format (e.g. 13/03/1990)
                formElements:{"txtfrom":"d-sl-m-sl-Y"}
        };
        datePickerController.createDatePicker(opts);
      // ]]>
      </script>';
      }
	  elseif ($type == 'user')
				{
					$precurio = new Precurio(0);
					$code = $precurio->getUsers();
					unset($precurio);
      }
	  elseif ($type == 'department')
				{
					$precurio = new Precurio(0);
					$code = $precurio->getDepartments();
					unset($precurio);
      }
	  elseif ($type == 'location')
				{
					$precurio = new Precurio(0);
					$code = $precurio->getLocations();
					unset($precurio);
      }




	return ($code);
	}

	function getComponentDefault($componentid)
	{
		$component = getComponentDetails($componentid);
		return $component->componentdefaultvalue;
	}
	function getComponentlabel($componentid)
	{
		$component = getComponentDetails($componentid);
		return $component->componentlabel;
	}

	/**
	 * Get the component options if any (or returns an empty string if none)
	 * @param int $componentid
	 * @return string
	 */
	function getComponentOptions($componentid)
	{
		$table = new Zend_Db_Table(array('name'=>"options"));
		$row = $table->fetchRow($table->select()->where("componentid = ?",$componentid));
		return $row ? $row->options : "";
	}
	function getCustomComponentData($componentid)
	{
		$table = new Zend_Db_Table(array('name'=>"components"));
		$component = $table->fetchRow($table->select()->where("componentid = ?",$componentid));

		$precurio = new Precurio();
		$db_config = $precurio->getDbConfig();

		$value = $component->frm_value_field;
		$label = $component->frm_label_field;

		$where = $component->frm_where_clause;
		//check if you are getting data from Precurio database
		if($component->frm_database == $db_config['dbname'] || $component->frm_database == 'self')
		{
			$table = new Zend_Db_Table(array('name'=>$component->frm_table));
		}
		else //we are fetching custom data from a different database
		{
			try {
			$table = $precurio->getTable($component->frm_table,$component->frm_database);
			}
			catch (Exception $e)
			{
				return array(1=>'ERROR! Could not connect to data source');
			}
		}

		$rows = $table->fetchAll($where);
		$data = array();
		foreach($rows as $row)
		{
			$data[$row->{$value}] = $row->{$label};
		}
		return $data;
	}

	function getComponentDetails($componentid)
	{
		$table = new Zend_Db_Table(array('name'=>"components"));
		return $table->fetchRow($table->select()->where("componentid = ?",$componentid));
	}

	function manageOptions($componentid,$options)
	{
		$tr = Zend_Registry::get('Zend_Translate');

		//check if option exists for that component
		$table = new Zend_Db_Table(array('name'=>"options"));
		$componentOption = $table->fetchRow($table->select()->where("componentid = ?",$componentid));


		if (empty($componentOption))
		{
			//insert new
			try
			{
				$table->insert(array(
						"componentid"=>$componentid,
						"options"=>$options
				));
				$msg = $tr->translate('Success');
			}
			catch(Exception $e)
			{
				$msg = $tr->translate('Error creating component');
			}
		}
		else
		{
			//update existing record
			try
			{
				$componentOption->options = $options;
				$componentOption->save();
				$msg = $tr->translate('Success');
			}
			catch(Exception $e)
			{
				$msg = $tr->translate('Error creating component');
			}
		}

		return ($msg);
	}

function moveup ($componentid)
{
	$tr = Zend_Registry::get('Zend_Translate');
	$comp= getComponentDetails($componentid);
	$currentRow = $comp['rowid'];
	$form = $comp['componentform'];
	$section = $comp['section'];

	if ($currentRow > 1)
	{
		//get the row of the component before
		$table = new Zend_Db_Table(array('name'=>"components"));
		$row = $table->fetchRow($table->select()->where("componentform = ?",$form)
				->where("rowid < ?",$currentRow)->where("section = ?",$section)
				->order("rowid DESC"));

		$row->rowid = $currentRow;
		$row->save();

		$comp->rowid = $currentRow -1;
		$comp->save();

		return $tr->translate('Success');
	}

	$msg = $tr->translate('Error updating component');
}


function getLastPosition($formid)
{
	$table = new Zend_Db_Table(array('name'=>"sections"));
	$row = $table->fetchRow($table->select()->where("formid = ?",$formid)->order("formposition DESC"));
	return ($row ? $row->formposition : 1);
}


/**
 * Create section and return id
 * @param string $displayname
 * @param in $form
 * @param string $sla
 * @param string $slaemail
 * @param unknown $userselect
 * @param unknown $approve
 * @return int
 */
function addSection ($displayname, $form, $sla, $slaemail,$userselect, $approve)
{
	$tr = Zend_Registry::get('Zend_Translate');
	$position = getLastPosition($form) + 1;

	try
	{
		$table = new Zend_Db_Table(array('name'=>"sections"));
		$id = $table->insert(array(
				'formid'=>$form,
				'formposition'=>$position,
				'displayname'=>$displayname,
				'sla'=>$sla,
				'sla_email'=>$slaemail,
				'userselect'=>$userselect,
				'approval'=>$approve
		));
		if ($approve == 1)
		{
			addComponent ('signature', $form, 'signature', 0, '', $id);
		}

	}
	catch(Exception $e)
	{
		$id = '';
	}
	return ($id);
}

/**
 * @param int $formid
 * @return Zend_Db_Table_Rowset_Abstract
 */
function getFormSections($formid)
{
	$table = new Zend_Db_Table(array('name'=>"sections"));
	return $table->fetchAll($table->select()->where("formid = ?",$formid)->order("formposition ASC"));

}

/**
 * @param int $sectionid
 * @return Zend_Db_Table_Row_Abstract
 */
function getSectionDetails($sectionid)
{
	$table = new Zend_Db_Table(array('name'=>"sections"));
	return $table->fetchRow($table->select()->where("sectionid = ?",$sectionid));
}

function cleanPostData($input)
{
	return $input;
}
?>
