<?php

class Precurio_Widget extends Precurio_Module{
	/**
	 * Returns the position of this widget.Possible options are 'top','left','right','bottom','side'.
	 * @return string
	 */
	public function getPosition()
	{
		return (empty($this->config['position']) ? 'top' : $this->config['position']);
	}
	/**
	 * @return string
	 */
	public function getVersion()
	{
		$author = isset($this->config['version']) ? $this->config['version']  : '2.0';
		return $author;
	}
	/**
	 * Organises an array of Precurio_Widget objects into there respective positons
	 * @param array $widgets
	 * @return array - Array([top]=>Array(Precurio_Widgets...), [left]=>Array(Precurio_Widgets...),....)
	 */
	public static function organize($widgets)
	{
		//first sort widgets order in ascending order
		usort($widgets, array("self", "cmp"));
		
		$arr  = array(
		'top'=>array(),
		'left'=>array(),
		'right'=>array(),
		'bottom'=>array(),
		'side'=>array()
		);
		
		foreach($widgets as $widget)
		{
			$arr[$widget->getPosition()][] = $widget;
		}
		return $arr;
	}
	static function cmp($a, $b)
	{
	    if ($a->getOrder() == $b->getOrder()) {
	        return 0;
	    }
	    return ($a->getOrder() < $b->getOrder()) ? -1 : 1;
	}
	/**
	 * Sets the order
	 * @param int $order 
	 */
	public function setOrder($order) {
		$this->config['order'] = $order;
	}

	/** 
	 * Returns the order of the widget within its container
	 * @return int
	 */
	public function getOrder() {
		return (!isset($this->config['order']) ? 1 : $this->config['order']);
	}

	/**
	 * Sets the position
	 * @param string $position 
	 */
	public function setPosition($position) {
		$this->config['position'] = $position;
	}
	
	/**
	 * Copies some properties of a widget into this one . 
	 * Note, this does not save the newly acquired properties.
	 * @param Precurio_Widget $widget
	 * @return Precuro_Widget
	 */
	public function cloneProperties($widget)
	{
		$this->config['position'] = $widget->getPosition();
		$this->order = $widget->getOrder();
		return $this;
	}
	/**
	 * Gets a widget
	 * @param string $name Name of the widget you want to get
	 * @return Precurio_Widget
	 */
	public static function get($name)
	{
		try
		{
			return new Precurio_Widget($name);
		}catch(Exception $e)
		{
			$tr = Zend_Registry::get('Zend_Translate');
			echo $tr->translate("Widget is not available or has not been properly configured");
		}
		return null;
	}
}

?>