<?php

require_once ('Precurio/FileFn.php');

class Precurio_Upgrade extends Precurio_FileFn {

	private $_path;
	private $_log;
	private $_appPath;//path to precurio
	public function __construct()
	{
		$this->_log = Zend_Registry::get('log');
		$this->_appPath = Zend_Registry::get('root');
	}
	/**
	 * @param $zipPath - full file name (i.e including path) of the upgrade zip file
	 * @return void
	 */
	public function upgrade($zipPath)
	{
		$zip = new dUnzip2($zipPath);
		$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $zipPath);
		$zip->unzipAll($basefilename);

		$filename = basename($zipPath,'.zip');
		$upgradePath = $basefilename.'/'.$filename;//$upgradePath is path to file contents of unziped upgrade file

		$this->_path = $upgradePath;
		if(file_exists($upgradePath.'/upgrade.bat'))
			$cmds = file_get_contents($upgradePath.'/upgrade.bat');
		else
			$cmds = file_get_contents($upgradePath.'/upgrade.pcr');//new file name for Precurio4

		$cmds = explode(";",$cmds);
		foreach($cmds as $cmd)
			$this->executeCommand($cmd);

		$this->deldir($basefilename);
		$zip->close();
		unset($zip);
		unlink($zipPath);

		$tr = Zend_Registry::get('Zend_Translate');
		echo $tr->translate("Upgrade Successful!");
	}

	public function executeCommand($cmd)
	{
		$cmd = trim($cmd);
		$cmd = explode(',',$cmd);
		if(empty($cmd[0]))return;
		switch(strtoupper($cmd[0]))
		{
			case 'COPY'://copy the a contents of one folder to another folder
				$this->filecopy($cmd[1],$cmd[2]);
				break;

			case 'DELETE'://delete folder/file
				$this->filedelete($cmd[1]);
				break;
			case 'RENAME'://renames a file or folder in a particular directory ($cmd[1] is the directory , while 2 and 3 are the old and new names respectively
				$this->filerename($cmd[1],$cmd[2],$cmd[3]);
				break;
			case 'SET'://set a precurio.ini parameter. 1=>parameter, 2=>value, 3=>section where parameter is. (optional)
				if(!isset($cmd[3]))$cmd[3] = "";
				if(Precurio_Utils::isNull($cmd[3]))$cmd[3] = "";
				$this->configset($cmd[1],$cmd[2],$cmd[3]);
				break;
			case 'EXECUTE'://execute an sql statement
				$this->executesql($cmd[1]);
				break;
			case 'INCLUDE'://include a php file during upgrade,to help with performing certain complex upgrades. (use with caution)
				$phpFile = $this->_path.'/'.$cmd[1];
				include($phpFile);
				break;
			case 'COPYICONS'://copy icons in specified folder to the icon directory of all styles in all themes.
				$this->copyimages($cmd[1],true);
				break;
			case 'COPYIMAGES'://copy images in specified folder to the images directory of all styles in all themes.
				$this->copyimages($cmd[1]);
				break;
			case 'APPENDSTYLE'://appends the contents of the specified file to all style.css stylesheets in all themes
				$this->appendStyle($cmd[1]);
				break;
			case 'APPENDTHEME'://appends the contents of the specified file to all theme.css stylesheets of all themes
				$this->appendStyle($cmd[1],true);
				break;
			default :
				echo "Unknown Command, this upgrade may be incompatible with your version of Precurio.";
				exit();

		}
	}
	/**
	 * @param $dir string directory path,MUST contain a leading slash
	 * @return unknown_type
	 */
	private function realDir($dir)
	{
		return $this->_appPath.$dir;
	}

	/**
	 * Handle copying of file or folders
	 * @param $from
	 * @param $to
	 * @return void
	 */
	private function filecopy($from, $to)
	{
		$from = $this->_path.$from; $to = $this->realDir($to);
		$this->copy($from,$to);
	}
	/**
	 * Handles file or folder delete
	 * @param $file
	 * @return void
	 */
	private function filedelete($file)
	{
		$file = $this->realDir($file);
		if(is_dir($file))
		{
			$this->deldir($file);
		}
		else
		{
			if(file_exists($file))
				unlink($file);
		}
	}
	/**
	 * @param $dir path to folder containing file/folder to rename
	 * @param $old
	 * @param $new
	 * @return void
	 */
	private function filerename($dir,$old,$new)
	{
		$dir = $this->realDir($dir);
		$oldWD = getcwd();
		chdir($dir);
		rename($old, $new);
		chdir($oldWD);
	}
	private function configset($param,$value,$section="")
	{
		$root = Zend_Registry::get('root');
		$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true,'skipExtends'=> true,));

		$tempConfig = $config; //copy array
		if(!Precurio_Utils::isNull($section))//check if param is under a section
		{
			 $tempConfig = $config->{$section}; //remove section part from config
		}

		$paramArr = explode(".",$param);
		$this->setParam($tempConfig,$paramArr,$value);

		if(!Precurio_Utils::isNull($section))
		{
			$config->{$section} = $tempConfig; //attach section back to overall config
		}
		else
			$config = $tempConfig;

		$item = new Precurio_ConfigWriter(array('config'   => $config,
                                           'filename' => $this->_appPath.'/application/configs/precurio.ini'));

		$item->write();
		unset($item);
		unset($config);
		unset($tempConfig);
	}

	private function executesql($sqlFile)
	{
		$sqlFile = $this->_path.'/'.$sqlFile;
		$sql = file_get_contents($sqlFile);
		$db = Zend_Registry::get('db');
		$db->query($sql);
	}

	private function setParam(&$arr,$params,$value)
	{
		if(count($params) > 1)
		{
			$param = array_shift($params);
			if(!isset($arr->{$param}))
				$arr->{$param} = array();
			return $this->setParam($arr->{$param},$params,$value);
		}
		else
		{
			$param = array_shift($params);
			$arr->{$param} = $value;
		}
		return $arr;
	}


	/**
	 * Copy additional icons or images to the icons or images folder of all styles in all theme.
	 * @param string $from folder where to copy the icons from
	 * @param boolean $areIcons - Set to true if images are actually icons, this will make them
	 * get copied to the icons folder instead. optional, default=false
	 * @return null
	 */
	private function copyimages($from,$areIcons = false)
	{

		$config = Zend_Registry::get('config');
		$themes = $config->theme->themes->toArray();
		foreach($themes as $themeName=>$theme)
		{
			$styles = $theme['styles'];
			foreach($styles as $n=>$styleName)
			{
				$to = "/public/library/css/$themeName/$styleName/images/";
				if($areIcons) $to .= 'icons/';
				$this->filecopy($from,$to);
			}
		}
		return;
	}

	private function appendStyle($extraFile,$isTheme=false)
	{
		$extraFile = $this->_path.$extraFile;
		$config = Zend_Registry::get('config');
		$themes = $config->theme->themes->toArray();
		foreach($themes as $themeName=>$theme)
		{
			if($isTheme)
			{
				$file = $this->_appPath."/public/library/css/$themeName/theme.css";
				$this->appendFile($file,$extraFile);
			}
			else
			{
				$styles = $theme['styles'];
				foreach($styles as $n=>$styleName)
				{
					$file = $this->_appPath."/public/library/css/$themeName/$styleName/style.css";
					$this->appendFile($file,$extraFile);
				}
			}
		}
	}

	/**
	 * Appends the orginal file with the contents of extra file
	 * @param string $originalFile -  real path to the original file
	 * @param string $extraFile -  real path to the extra file
	 * @return null
	 */
	private function appendFile($originalFile, $extraFile)
	{
		$contents = file_get_contents($extraFile);
		if($contents ===  false)
		{
			echo "Could not read contents of exta file : $extraFile";
			return;
		}
		$contents = "\r\n".$contents;//this might give issue on non windows systems.
		$fp = fopen($originalFile,"a+b");
		fwrite($fp,$contents);
		fclose($fp);
		return;
	}
}

?>