<?php
require_once ('user/models/UserUtil.php');
require('Twilio/Services/Twilio.php');
class Precurio_Sms extends Zend_Service_Abstract {
	/**
	 * @param $activity UserActivity
	 * @return null
	 */
	public function notify($activity)
	{
		if($activity->only_notify_id)
		{
			$users = array();
			try{$users[] = UserUtil::getUser($activity->only_notify_id,true);}
			catch(Precurio_Exception $e){return;}
		}
		else
			$users = $activity->getItem()->getUsers();
	
		if(empty($users) || count($users) == 0)//public activity. See SMS does NOT support public notifcation
		{
			return;
		}
	
		$data = array();
		$data['timestamp'] = Precurio_Date::now()->getTimestamp();
		$data['activity_id'] = $activity->getId();
		foreach($users as $user)
		{
			if(!(is_a($user,'User')))$user = UserUtil::getUser($user->user_id);
			if(empty($user))continue;
			if($user->getId() == $activity->user_id)continue;//do not notify me of my activiy
			$data['to'] = $user->getMobilePhone();
			if(empty($data['to']))$user->getWorkPhone();//use workphone is no mobile phone
			if(empty($data['to']))continue;//no phone number
			$data['message'] = $activity->getMessage('sms',$user->getId());
			$this->sendData($data);
		}
	}
	/**
	 * Handles the actual service call. Override this function to use a different service from Twilio
	 * @param array $data - SMS data  - "to", "message",""timestamp","activity_id"
	 */
	private function sendData($data)
	{
		if(empty($data['to']))return false;//no receipient. don't waste our time.
		
		$config = Zend_Registry::get('config');
		//check if there is twilio configuration
		if(!isset($config->twilio->auth_token) || !isset($config->twilio->account_sid) || !isset($config->twilio->from))return false;//no twilio configuration
		
		$data["from"] = $config->twilio->from;
		
		$client = new Services_Twilio($config->twilio->account_sid, $config->twilio->auth_token);
		try {
			$message = $client->account->messages->create(array("From"=>$data["from"],"To"=>$data["to"],"Body"=>$data["message"]));
		}
		catch(Exception $e)
		{
			$log = Zend_Registry::get("log");
			$str = $e; 
			$str = print_r($str,true);
			$log->info($str);
		}
	}
}

?>