<?php

require_once ('Zend/Session.php');
class Precurio_Session extends Zend_Session {
	const NAMESPACE_USER = "user";
	const NAMESPACE_WORKFLOW = "workflow";
	const NAMESPACE_CHAT = 'chat';
	const NAMESPACE_CONTENT = 'content';
	const NAMESPACE_REPORT = 'report';
	const NAMESPACE_APP = 'app';
	const NAMESPACE_DOCUMENT = 'document';
	const NAMESPACE_EXTRANET = "extranet_user";

	public static function setCurrentUser($user,$extranet=false)
	{
		$ns = $extranet ? new Zend_Session_Namespace(self::NAMESPACE_EXTRANET) : $ns = new Zend_Session_Namespace(self::NAMESPACE_USER);;
		$ns->currentUser = $user;
		$config = Zend_Registry::get('config');
		$expire_after = empty($config->expire_after) ? 1209600 : $config->expire_after;
		$ns->setExpirationSeconds($expire_after);
		self::rememberMe($expire_after);
	}
	public static function logOut()
	{
		self::forgetMe();
		Zend_Session::expireSessionCookie();
		Zend_Session::destroy();
	}
	public static function getCurrentUserId()
	{
		try
		{
			$ns = new Zend_Session_Namespace(self::NAMESPACE_USER);
			$request = Zend_Controller_Front::getInstance()->getRequest(); //we moved request here, so we can also check if this is a user request or a cron job
			if(!isset($ns->currentUser) && $request)//throw a re-login error because session has expired
			{
				//but first check is guest users are allowed
				$config = Zend_Registry::get('config');
				if(!empty($config->allow_anonymous_user))
				{
					$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
					$user =  $table->fetchRow($table->select()->where('identity = "guest"')->order('id desc'));
					if($user)
					{
						$ns->currentUser = $user;
						$ns->setExpirationSeconds(600);//expire session after 10 minutes
						return $user->id;
					}
				}
				
				$actionName = $request->getActionName();$moduleName = $request->getModuleName();$controllerName = $request->getControllerName();
				if($request && !($request->getControllerName() == 'login' ||
						$actionName == 'periodicupdate' || $controllerName == 'error' ||
						$moduleName == 'default' || $moduleName == NULL ||
						$moduleName == 'chat' || $moduleName == 'install' ||
						$moduleName == 'widget'  || $actionName == 'remind' || substr($actionName, 0,6) == 'submit')
				){
					if($request->isDispatched())
					{
						$ns->lastRequest = serialize($request->getRequestUri());
					}
				}
				if(Zend_Registry::isRegistered('Zend_Translate'))
					$tr = Zend_Registry::get('Zend_Translate');
				$msg = isset($tr) ? $tr->translate(PrecurioStrings::SESSIONEXPIRED) : PrecurioStrings::SESSIONEXPIRED;
				throw new Precurio_Exception($msg,Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
			}

			$user = $ns->currentUser;

			return $user->id;
		}
		catch (Zend_Session_Exception $e)//i.e there was a problem retrieving the session user
		{
			return 0;
		}
	}
	public static function getCurrentUserPwd()
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_USER);
		if(!isset($ns->currentUser))//throw a re-login error because session has expired
		{
			$tr = Zend_Registry::get('Zend_Translate');
			throw new Precurio_Exception($tr->translate(PrecurioStrings::SESSIONEXPIRED),Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
		}
		$user = $ns->currentUser;
		return $user->credential;
	}
	/**
	 * @return Precurio_License
	 */
	public static function getLicense()
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_APP);
		if(!isset($ns->license))
		{
			return new Precurio_License();
		}

		return $ns->license;
	}
	/**
	 * @param $license Precurio_License
	 * @return null
	 */
	public static function setLicense($license)
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_APP);
		$ns->license = $license;
		$ns->setExpirationSeconds(3600);
	}
	public static function setStyle($style)
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_USER);
		$ns->style = $style;
	}
	public static function getStyle()
	{
	    return "blue";
		$ns = new Zend_Session_Namespace(self::NAMESPACE_USER);
		if(!isset($ns->style))
		{
			return null;
		}

		return $ns->style;
	}
	/**
	 * @return Precurio_ChatSession
	 */
	public static function getChatSession()
	{
		$ns = new Precurio_ChatSession(self::NAMESPACE_CHAT);
		return $ns;
	}
	/**
	 * @param Zend_Form $form
	 * @return void
	 */
	public static function setCurrentForm($form)
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_WORKFLOW);
		$ns->currentForm = serialize($form);
		//expire current form after 60 mins i.e a user has only an hr to complete a form.
		$ns->setExpirationSeconds(6000,'currentForm');
	}
	/**
	 * @return Zend_Form
	 */
	public static function getCurrentForm()
	{
		$ns = new Zend_Session_Namespace(self::NAMESPACE_WORKFLOW);
		if(!isset($ns->currentForm))
		{
			$tr = Zend_Registry::get('Zend_Translate');
			throw new Precurio_Exception($tr->translate(PrecurioStrings::FORM_SESSION_EXPIRED),Precurio_Exception::EXCEPTION_FORM_SESSION_EXPIRED);
		}

		return unserialize($ns->currentForm);
	}
}

?>