<?php
require_once ('cms/models/MyContents.php');
require_once ('user/models/vo/User.php');
require_once ('user/models/UserUtil.php');
require_once ('employee/models/Employees.php');
require_once ('event/models/Events.php');
require_once ('contact/models/Contacts.php');
require_once ('task/models/Tasks.php');
require_once ('discussion/models/vo/Discussion.php');
require_once ('others/class.pdf2text.php');
class Precurio_Search {
	const PATH_INDEX = "../dict";
	private $index;

	private $error = false;
	public function __construct()
	{
		try
		{
		    Zend_Search_Lucene_Analysis_Analyzer::setDefault(
		    new Zend_Search_Lucene_Analysis_Analyzer_Common_TextNum_CaseInsensitive()
		    );
		    if(!file_exists(self::PATH_INDEX))
		    {
		        $res = mkdir(self::PATH_INDEX);
		        if(!$res)throw new Precurio_Exception("Could not create dict folder",0);

		        $this->index = Zend_Search_Lucene::create(realpath(self::PATH_INDEX));

		        $this->createIndexFromDb();
		    }
		    $this->index = Zend_Search_Lucene::open(realpath(self::PATH_INDEX));
		}
		catch (Exception $e)
		{
		    $this->error = true;
		    $log = Zend_Registry::get('log');
		    $log->err($e);
		}

	}
	/**
	 * Get the index
	 * @throws Precurio_Exception
	 * @return Zend_Search_Lucene_Interface
	 */
	public static function getIndex()
	{
		if(!file_exists(Precurio_Search::PATH_INDEX))
		{
			$res = mkdir(Precurio_Search::PATH_INDEX);

			if(!$res)throw new Precurio_Exception("Could not create dict folder",0);

			$index = Zend_Search_Lucene::create(realpath(Precurio_Search::PATH_INDEX));
		}
		else
			$index = Zend_Search_Lucene::open(realpath(self::PATH_INDEX));

		return $index;
	}
	public function optimize()
	{
		// Optimize index.
		$this->index->optimize();
	}
	private function createIndexFromDb()
	{
		set_time_limit(0);

		$this->indexEvents();
		$this->indexTasks();
		$this->indexUsers();
		$this->indexContents();
		$this->indexDocuments();
		$this->indexDiscussions();
	}

	private function indexDiscussions()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'Discussion'));
		$select = $table->select()->where('active=1');
		$discussions = $table->fetchAll($select);
		foreach($discussions as $discussion)
		{
			$discussion->index();
		}

	}

	private function indexContents()
	{
		$contents = MyContents::getAll(true);
		foreach($contents as $content)
		{
			$content->index();
		}

	}
	private function indexDocuments()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
						->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
						->where('a.active = 1');
		$documents = $table->fetchAll($select);

		foreach($documents as $document)
		{
			$document->index();
		}

	}
	private function indexUsers()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		$select = $table->select()->where('active=1');
		$users = $table->fetchAll($select);
		foreach($users as $user)
		{
			$user->index();
		}

	}
	private function indexEvents()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT, 'rowClass'=>'Event'));
		$events = $table->fetchAll($table->select()->where('active=1'));
		foreach($events as $event)
		{
			$event->index();
		}

	}
	private function indexTasks()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'Task'));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::TASK))
						->join(array('b' => PrecurioTableConstants::TASK_USERS),'a.id = b.task_id',array('user_id','is_proxy','is_transfer','date_assigned'=>'date_created'))
						->where('a.active = 1');
		$tasks = $table->fetchAll($select);
		foreach($tasks as $task)
		{
			$task->index();
		}
	}


	/**
	 * @param $queryStr
	 * @param $module
	 * @return array of Zend_Search_Lucene_Search_QueryHit objects.

	 */
	public function search($queryStr,$module = "")
	{
		Zend_Search_Lucene_Search_Query_Wildcard::setMinPrefixLength(0);
		Zend_Search_Lucene::setTermsPerQueryLimit(100);
		$index = Zend_Search_Lucene::open(realpath(self::PATH_INDEX));
		try
		{
			$hits  = $index->find($queryStr);
		}
		catch (Zend_Search_Lucene_Search_QueryParserException $e)
		{
			echo "Query syntax error: " . $e->getMessage() . "\n";
			$log = Zend_Registry::get('log');
			$log->err($e);
			return;
		}
		return $hits;
	}

}

?>