<?php

class Precurio_Registry {

	/**
	 * @param string $appid - the app id
	 * @param string $type  - Type of activity
	 * @version 4
	 */
	public static function get($appid,$type)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_REGISTRY));
		$select = $table->select()->where('appid = ?',$appid)->where('type = ?',$type)->order('id desc');
		return $table->fetchRow($select);
	}
	/**
	 * Gets the main class used by app.
	 * @param string $appid
	 * @return String
	 */
	public static function getClass($appid,$type="")
	{


	}
	/**
	 * @param string $appid - App ID. e.g. task, news, cms
	 * @param int $object_id - id of object
	 * @param string $type - type of activity
	 * @return Precurio_ObjectInterface
	 */
	public static function getObject($appid,$object_id,$type="",$team_id=0)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_REGISTRY));
		$select = $table->select()->where('appid = ?',$appid)->order('id desc');
		if(!empty($type))
			$select = $select->where('type = ?',$type);

		$register = $table->fetchRow($select);

		if(empty($register))
		{
			throw new Precurio_Exception("APP '$appid' does not register any activity with type '$type'", Precurio_Exception::EXCEPTION_APPLICATION_ERROR);
		}

		$class = $register->class_name;
		$table_name = $register->table_name;
		$class_path = $register->class_path;

		if((empty($class) && $appid != "team") || empty($table_name))
		{
			throw new Precurio_Exception("APP '$appid' with type '$type' is not properly registered", Precurio_Exception::EXCEPTION_APPLICATION_ERROR);
		}
		if($team_id)//we want to get an object for a team activity. by convention the class will be "Team" prepended to it. eg TeamDocument, TeamDiscussion
		{
			$class = "Team".$class;
		}
		if(!empty($class_path))
		{
			require_once $class_path;
			//Zend_Loader::loadClass($class,$class_path);
		}

		$object = @call_user_func(array($class, 'get'),$object_id,$team_id);
		if(!$object)//i.e. class does not have a get method
		{
			$table = new Zend_Db_Table(array('name'=>$table_name,'rowClass'=>$class));
			$object = $table->find($object_id)->current();
		}

		if(empty($object) || !is_a($object, 'Precurio_ObjectInterface'))
		{
			throw new Precurio_Exception("APP '$appid' with type '$type' is registered but does not return valid object", Precurio_Exception::EXCEPTION_APPLICATION_ERROR);
		}

		//$log = Zend_Registry::get('log');
		//$log->err("Object of type ".get_class($object)." gotten for APP '".$appid."',  ID=".$object_id.", Type '".$type."'");

		return $object;
	}
}

?>