<?php
require_once('cms/models/vo/Content.php');

class Precurio_Image {
	
	/* This constants are not used in this class. They are simply a copy of the ones
	 * in the Content class. This is to prevent us from having to add an extra  "require" line
	 * on every page that uses this class.
	 */
	const IMAGE_ICON = 0;
	const IMAGE_THUMBNAIL = 1;
	const IMAGE_LARGE = 2;
	const IMAGE_PROFILE = 3;
	const IMAGE_251 = 4;
	const IMAGE_271 = 5;
	const IMAGE_517 = 6;
	public static function getPath($image_path,$type = null)
	{
		if($type === null)return $image_path;
		
		$filename = basename($image_path);
		$filepath = "";
		
		switch ($type)
		{
			case Content::IMAGE_LARGE:
				$filepath = Content::PATH_PHOTOS;
				break;
			case Content::IMAGE_THUMBNAIL:
				$filepath = Content::PATH_THUMBNAILS;
				break;
			case Content::IMAGE_ICON:
				$filepath = Content::PATH_ICONS;
				break;
			case Content::IMAGE_251:
				$filepath = Content::PATH_CONTENT_IMAGE_251;
				break;	
			case Content::IMAGE_271:
				$filepath = Content::PATH_CONTENT_IMAGE_271;
				break;	
			case Content::IMAGE_517:
				$filepath = Content::PATH_CONTENT_IMAGE_517;
				break;		
			default:
				$filename = $this->image_path;
				break;
		}
		$filename = $filepath.$filename;
		if(!is_file(getcwd().$filename))
			$filename = $image_path;
		return $filename;
	}
}

?>