<?php

require_once ('Zend/Form/Element/File.php');

class Precurio_FileElement extends Zend_Form_Element_File {
	const DIR = '/uploads/workflow';
    public function isValid($value, $context = null)
    {
        // for a file upload, the value is not in the POST array, it's in $_FILES
        $key = $this->getName();
        if(null === $value) {
            if(isset($_FILES[$key])) {
                $value = $_FILES[$key];
            }
        }
        return $value != null;
       
    }
    /**
     * Processes the file, returns null or the filename only
     * For the complete path, use getFileName
     *
     * @return null|string
     */
    public function getValue()
    {
    	$file  = $_FILES[$this->getName()];
		if($file)
		{
			if($file['size'])
			{
				if (is_uploaded_file($file['tmp_name'])) 
				{
			    	$filename = $file['name'];
					$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $filename);
					$ext = preg_replace("/.*\.([^.]+)$/","\\1", $filename);
					$fileFn = new Precurio_FileFn();
					$target_dir = $fileFn->checkDir(self::DIR); 
					if (!move_uploaded_file($file['tmp_name'], $target_dir.'/'.$filename)) 
					{
					    throw new Exception('Cannot upload file from '.$file['tmp_name']. ' to '.$target_dir.'/'.$filename );
					    return;
					}
					return $filename;
				}
			}
		}
		
    }

}

?>