<?php
require_once "others/CreateZipFile.inc.php";
require_once "others/dUnzip2.inc.php";
class Precurio_Backup extends Precurio_FileFn{

	const MAX_RECORDS = 500;
	private $_path = "/backups/";

	private $_log;
	private $_folders = array('application','bin','library/Precurio');//folders to be backed up
	public function __construct()
	{
		$this->_log = Zend_Registry::get('log');
		$config = Zend_Registry::get('config');
		if(isset($config->backup_path))
		{
			$this->_path = $config->backup_path;
		}
		$root = Zend_Registry::get('root');
		$this->_path = $root.$this->_path;
	}
	public function getPath()
	{
		return $this->_path;
	}

	/**
	 * @return array of filenames in backup folder
	 */
	public function getAll()
	{
		$files = array();
		if(!is_dir($this->_path))
		{
			if(!mkdir($this->_path))
			{
				$this->_log->err("Could not create backup directory : ".$this->_path);
				return files;
			}

		}
		$dir = opendir($this->_path);
		 // Read the directory and get the files
	    while (($file = readdir($dir)) !== false) {

	        if ($file[0] == '.'){ continue; }

	        if (is_file($this->_path.$file)){
	        	if(strtolower(preg_replace("/.*\.([^.]+)$/","\\1", $file)) === 'zip')
					$files[] = $this->_path.$file;
	        }
	    }

		return array_reverse($files);

	}

	function fsize($size)
	{
	      $a = array("Bytes", "KB", "MB", "GB", "TB", "PB");
	      $pos = 0;
	      while ($size >= 1024) {
	             $size /= 1024;
	              $pos++;
	      }
	     return round($size,2)." ".$a[$pos];
	}


	function doBackup($title,$db=true,$fs=true)
	{
		//backup file system
		$newBackupPath = $this->_path.$title;

		mkdir($newBackupPath);

		$appPath = Zend_Registry::get('root');

		foreach($this->_folders as $folder)
		{
			$this->copy($appPath.'/'.$folder,$newBackupPath.'/'.$folder);
		}

		$table = $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ANALYTIC));
		if($table->fetchAll()->count() < Precurio_Backup::MAX_RECORDS)
		{
			//now backup database
			$this->backupMySqlDB($title);
		}

		$createZipFile=new CreateZipFile();
		$createZipFile->zipDirectory($newBackupPath.'/',$title.'/');

		$zipName= $newBackupPath.'.zip';
		$fd=fopen($zipName, "wb");
		$out=fwrite($fd,$createZipFile->getZippedfile());
		fclose($fd);

		$this->deldir($newBackupPath);
		return true;
	}

	private function backupMySqlDB($backupFolder)
	{
		$tables = new ReflectionClass('PrecurioTableConstants');
		$tables = $tables->getConstants();

		$backupFolder = $this->_path.$backupFolder.'/database/';
		mkdir($backupFolder);

		$backupFolder = str_replace("\\", "/", $backupFolder);
		$backupFolder = str_replace("//", "/", $backupFolder);

		$db = Zend_Registry::get('db');

		foreach($tables as $tableName)
		{
			$backupFile = $backupFolder.$tableName.'.bk';

			$qry = "SELECT * INTO OUTFILE '$backupFile' FROM $tableName";
			$db->query($qry);
		}

	}
	public function download($archiveName)
	{
		// Security checks
		if( $archiveName == "" ) {
			echo "<html><title>Precurio Backup - Download </title><body><BR><B>ERROR:</B> The download file was NOT SPECIFIED.</body></html>";
			return;
		}

		$filename = preg_replace("/(.*)\.([^.]+)$/","\\1", $archiveName);

		$archiveName = $this->_path.$archiveName;



		try
		{
			if(ini_get('zlib.output_compression')) {
				ini_set('zlib.output_compression', 'Off');
			}
		}
		catch(Exception $e)
		{
			return;
		}

		if ( ! file_exists( $archiveName ) ) {
			echo "<html><title>Precurio Backup - Download </title><body><BR><B>ERROR:</B> File not found.</body></html>";
			return;
		}

		if (headers_sent()) {
  		  	echo 'HTTP header already sent';
  		  	return;
		}

		$response = Zend_Controller_Front::getInstance()->getResponse();
		$response->clearAllHeaders();
		$response->clearBody();
		$response->clearHeaders();
		Precurio_Utils::debug($response);
		header("Precurio: backup");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: private",false);
		header("Content-Type: application/zip");
		header("Content-Length: ".filesize($archiveName).";\n");
		header("Content-Disposition: attachment; filename=\"".basename($archiveName)."\"" );
		header("Content-Transfer-Encoding: binary");
		readfile($archiveName);
	}
	function delete($archiveName)
	{
		$archiveName = $this->_path.$archiveName;
		if ( ! file_exists( $archiveName ) )
		{
			echo "<html><title>Precurio Backup - Delete </title><body><BR><B>ERROR:</B> File not found.</body></html>";
			return;
		}
		unlink($archiveName);
	}


	function doRestore($archiveName,$db=true,$fs=true)
	{
		$archivePath = $this->_path.$archiveName;
		$basefilename = preg_replace("/(.*)\.([^.]+)$/","\\1", $archivePath);
		$zip = new dUnzip2($archivePath);
		$zip->unzipAll($basefilename);

		$filename = preg_replace("/(.*)\.([^.]+)$/","\\1", $archiveName);
		$backupPath = $this->_path.$filename.'/'.$filename;

		$appPath = Zend_Registry::get('root');

		foreach($this->_folders as $folder)
		{
			$this->copy($backupPath.'/'.$folder,$appPath.'/'.$folder);
		}

		//now restore database
		$this->restoreMySqlDB($backupPath);

		$this->deldir($this->_path.$filename);
	}
	function restoreMySqlDB($backupFolder)
	{
		$tables = new ReflectionClass('PrecurioTableConstants');
		$tables = $tables->getConstants();

		$databaseFolder = $backupFolder.'/database/';

		$databaseFolder = str_replace("\\", "/", $databaseFolder);
		$databaseFolder = str_replace("//", "/", $databaseFolder);

		if(!file_exists($databaseFolder.'p2_users.bk'))return;//database was not backed up

		//note that, when doing a restore, our target database definitely already exists.
		$dbStruct = file_get_contents($this->_path.'struct.db');
		$db = Zend_Registry::get('db');
		$db->query($dbStruct);

		foreach($tables as $tableName)
		{
			$backupFile = $databaseFolder.$tableName.'.bk';

			$qry = "LOAD DATA INFILE '$backupFile' INTO TABLE $tableName";
			$db->query($qry);
		}

	}




}

?>