<?php
class Precurio_Activity {
		/**
	 * Create a new activity and triggers notification
	 * @param string $appid - ID of application creating the activity.
	 * @param string $type - type of activity
	 * @param int $item_id - ID of the object itself
	 * @param int $user_id - ID of the user that is the actor for activity (this is "most times" the current user)
	 * @param timestamp $date_created OPTIONAL - defaults to the current timestamp
	 * @param int $onlyNotifyId OPTIONAL - ID of the user you only want to notify. Use if you want notification to be sent to only one user instead of activity item users.
	 *  Defaults to 0. (Used by share document/content).
	 *  Set to -1 to notify extranet user (Content::extranetshare).
	 *  Set to -2 to signify no one in particular, currently Used to just for the purpose of activity feed display in team rooms.(Documents::createNew())
	 * @param int $team_id OPTIONAL - If the activity occured within a team room, this should contain the ID of the team/group
	 * @return int
	 * @version 4
	 */
	public static function create($appid,$type,$item_id,$user_id,$date_created = null,$onlyNotifyId=0,$team_id=0)
	{
		$data['appid'] = $appid;
		$data['type'] = $type;
		$data['item_id'] = $item_id;
		$data['user_id'] = $user_id;
		$data['group_id'] = $team_id;
		$data['date_created'] = empty($date_created) ? Precurio_Date::now()->getTimestamp() : $date_created;
		$date = new Precurio_Date($data['date_created']);
		$data['activity_date'] = $date->get(Zend_Date::DATETIME_FULL);
		try
		{
			$data['session_user_id'] = Precurio_Session::getCurrentUserId();//this is for analytics purpose.
		}
		catch(Exception $e)
		{
			try{
				$data['session_user_id'] = Precurio_Extranet::getCurrentUserId();//this is for analytics purpose.
			}
			catch(Exception $e)
			{
				$data['session_user_id'] = 0;
			}

		}
		$data['active'] = 1;
		$data['only_notify_id'] = $onlyNotifyId;

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
		$activity_id = $table->insert($data);;

		//now put into activity effects. Note, if feed was disabled, no need to store.
		try
		{
			$object = Precurio_Registry::getObject($appid, $item_id,$type,$team_id);
		}
		catch (Precurio_Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err("There was a problem logging this activity".serialize($e));
			return $activity_id;
		}
		$activityR = Precurio_Registry::get($appid, $type);
		if($activityR->feed_enabled)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_EFFECT));
			if($onlyNotifyId)
			{
				$users = array();
				try{$users[] = UserUtil::getUser($onlyNotifyId,true);}
				catch(Precurio_Exception $e){return $activity_id;}
			}
			else
				$users = $object->getUsers();

			if(empty($users) || count($users) == 0)//if getUsers returns nothing, this is a sign that the activity is public. e.g. when uploading a document to a public folder.
			{
				$table->insert(array('activity_id'=>$activity_id,'subject_id'=>0,'date_created'=>$data['date_created'],'active'=>1));
			}
			else
			{
				foreach($users as $user)
				{
					$subject_id = empty($user->user_id) ? $user->getId() : $user->user_id;
					$table->insert(array(
							'activity_id'=>$activity_id,
							'subject_id'=>$subject_id,
							'date_created'=>$data['date_created'],
							'active'=>1
					));
				}
			}

		}



		//now trigger notification.
		try
		{
			new Precurio_Notification($activity_id);
		}
		catch (Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err("There was a problem with sending notifications \n".serialize($e));
		}

		return $activity_id;
	}
	/**
	 * Gets activity updates for a particular user.
	 * @param int $user_id - The user for which to get activity updates for.
	 * @param timestamp $since OPTIONAL - Updates should not be earlier than $since.
	 * @param int $limit OPTIONAL default to 20.
	 * @param boolean $onlyMine OPTIONAL Determines if you only want to fetch activities trigger by the user. Useful when trying to get a user's activities .default = false
	 * @return array
	 */
	public static function getUpdates($user_id,$since=null,$limit = 20,$onlyMine=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_EFFECT, 'rowClass'=>'UserActivity'));
		$select  = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::ACTIVITY_EFFECT))
		->join(array('b' => PrecurioTableConstants::ACTIVITY_LOG),'a.activity_id = b.id',array('appid','type','item_id','date_created','user_id','session_user_id','group_id'))
		->order('a.date_created DESC')
		->where('a.active = 1 AND b.active=1')
		->where('a.subject_id = ? OR a.subject_id = 0',$user_id)
		->limit(100);//must NOT fetch more than 100. $limit variable is implemented in loop below.

		if(!empty($since))
		{
			$select = $select->where('b.date_created > ?',$since);
		}

		$activities = $table->fetchAll($select);

		$temp = array();
		$session_user_id = Precurio_Session::getCurrentUserId();
		foreach($activities as $activity)
		{
			if($onlyMine)
			{
				//ignore other people activities
				if($activity->session_user_id != $user_id)continue;
			}
			else
			{
				//ignore my own activities
				if($activity->session_user_id == $user_id)continue;
			}
			if($activity->getItem() == null)continue;
			//check if user blocked me
			$activityOwner = UserUtil::getUser($activity->user_id);
			if(empty($activityOwner))continue;//the user that created the activity has been deleted
			if($activityOwner->isBlocked($user_id))continue;

			$key = $activity->appid.$activity->type.$activity->item_id;
			//then check if logged in user can see the activity
			if($activity->canSee($session_user_id) && empty($temp[$key]))
				$temp[$key] = $activity;

			if(count($temp) >= $limit)break;
		}
		unset($activities);
		return $temp;
	}
	/**
	 * Get the message for an activity.
	 * The returned string will contain placeholders that will be replace in this manner
	 * {1} == name of actor
	 * {2} == pronoun i.e his or her
	 * {3} == url
	 * {4} == name of subject i.e. person receiving the notification
	 * {5} == the id of the actor
	 * {6} = the id of the subject
	 * {7} = web url of the application
	 * {8} = a label for the activity, eg the event name, content name etc
	 * {9} = URL to the actor profile
	 * @param UserActivity $activity
	 * @param string $form (feed,mail or sms)
	 * @return String
	 */
	public static function getMessageFormat($activity,$form="feed")
	{
		$format = $form."_format";
		$activityR = $activity->getRegistry();
		$messageFormat = $activityR->{$format};
		if(empty($messageFormat) || strlen(trim($messageFormat)) < 5)//default to feed format
			$messageFormat = $activityR->feed_format;
		return $messageFormat;
	}
	/**
	 * Determines if an activity was already performed.
	 * @param string $appid - App that created the activity
	 * @param string $type - type of activity
	 * @param int $item_id - ID of the app object itself
	 * @param int $user_id - User that triggered the activity
	 * @return boolean
	 */
	public static function exists($appid,$type,$item_id,$user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
		$row = $table->fetchRow($table->select()->where('appid = ?',$appid)->where('type = ?',$type)->where('item_id = ?',$item_id)->where('user_id = ?',$user_id));
		return !(empty($row));
	}
}

?>