<?php

require_once ('Zend/Db/Table/Row/Abstract.php');
require_once 'user/models/UserUtil.php';
require_once 'workflow/models/vo/Process.php';
class ProcessState extends Zend_Db_Table_Row_Abstract{
	/**
	 * get the id
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}
	/**
	 * get the process_id
	 * @return int
	 */
	public function getProcessId()
	{
		return $this->process_id;
	}
	/**
	 * get the actual name of a state, this should probably be a generated code
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}
	public function getTitle()
	{
		return $this->getDisplayName();
	}
	/**
	 * get the display name of the state
	 * @return string
	 */
	public function getDisplayName()
	{
		return Precurio_Utils::isNull($this->display_name) ?  $this->name : $this->display_name;
	}
	/**
	 * Returns the maximum number of hours this state should take
	 * @return int
	 */
	public function getDuration()
	{
		return $this->duration;
	}
	/**
	 * Returns the positon of the state in the overall process flow
	 * @return int
	 */
	public function getPosition()
	{
		return $this->position;
	}

	/**
	 * Determines whether this state is departmental or not,
	 * a departmental state can only be approved by a user in the same department.
	 * @return Boolean
	 */
	public function isDepartmental()
	{
		return $this->departmental;
	}
	/**
	 * Determines whether this state is location based or not,
	 * a location based state can only be approved by a user in the same location.
	 * @return Boolean
	 */
	public function isLocational()
	{
		return $this->locational;
	}

	/**
	 * Determines whether the state must be approved by the supervisor or boss of the previous approver (or requester)
	 * This setting overrides isDepartmental and isLocational
	 * @return true
	 */
	public function useSupervisor()
	{
		return $this->use_supervisor;
	}

	/**
	 * Determines if a state is an approval state.
	 * Currently, all non start states are approval states
	 * @return boolean
	 */
	public function isApproval()
	{
		return $this->is_approval;
	}
	public function isStartState()
	{
		return $this->position == 0;
	}

	public function isEndState()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES,'rowClass'=>'ProcessState'));
		$states = $table->fetchAll($table->select()->where('process_id = ?',$this->getProcessId())
															->where('position = ?',($this->getPosition()+1)));
		return $states->count() == 0;
	}
	/**
	 * Gets the names of visible fields for this state
	 * @return Array
	 */
	public function getFields()
	{
		$fields = array();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATE_FIELDS));
		$rows = $table->fetchAll($table->select()->where('state_id = ?',$this->getId()));
		foreach($rows as $row)
		{
			$fields[] = $row['field_name'];
		}
		return $fields;
	}

	/**
	 * Indicates if a user can change the approval level for this state.
	 * @return boolean
	 */
	public function userCanChangeApprover()
	{
		return $this->is_approval && $this->allow_approver_change;
	}

	/**
	 * Returns the next state after this one. Note that this function also exists in ProcessManager
	 * but the difference is, this one always returns one state. This one is actually only used
	 * for the 'User can change approver' scenerio
	 * @return ProcessState
	 */
	public function getNextState()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES,'rowClass'=>'ProcessState'));
		$state = $table->fetchRow($table->select()->where('process_id = ?',$this->getProcessId())
															->where('position = ?',($this->getPosition()+1)));

		return $state;
	}

	/**
	 * Returns the previous state if any.
	 * @return ProcessState
	 */
	public function getPreviousState()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES,'rowClass'=>'ProcessState'));
		$state = $table->fetchRow($table->select()->where('process_id = ?',$this->getProcessId())
				->where('position = ?',($this->getPosition()-1)));

		return $state;
	}

	/**
	 * Gets a workflow state
	 * @param int $id
	 * @return ProcessState
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES,'rowClass'=>'ProcessState'));
		return $table->fetchRow($table->select()->where('id = ?',$id));
	}

	/**
	 * Gets the workflow associated with the state
	 * @return Process
	 */
	public function getProcess()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		return $table->fetchRow($table->select()->where('id = ?',$this->process_id));
	}

	/**
	 * Gets a collection of objects containing allowed users or groups [{id:1,user_id:23,group_id:0}]
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getAccessList()
	{
		if(!$this->isApproval())
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_REQUEST_ACCESS));
			$items =  $table->fetchAll($table->select()->where('process_id= ? ',$this->getProcessId()));
		}
		else
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_APPROVAL_ACCESS));
			$items =  $table->fetchAll($table->select()->where('state_id= ? ',$this->getId())->where('process_id = ?',$this->getProcessId()));
		}
		return $items;
	}
}

?>