<?php
require_once ('widget/controllers/IndexController.php');
/**
 * FeaturedEmployeeController
 *
 * @author Mayor Brain
 * @version
 */

class Widget_FeaturedEmployeeController extends Widget_IndexController {

    public function configureAction()
    {
    	if(!UserUtil::isAllowed('admin_index'))
    	{
    		throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_INVALID_ROLE);
    		return;
    	}
        $userSetting = UserUtil::getUser()->getSettings();
        $this->view->widget = $userSetting->getWidget('featured-employee');
        $this->renderScript('views/home/featured-employee_configure.phtml');
    }
    public function deleteAction()
    {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        $id = $this->getRequest()->getParam('id',0);
        if(!is_numeric($id))
        {
            echo "Invalid Parameter $id";
            return;//we are expecting an integer here.
        }
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::FEATURED_USER));
        $row = $table->find($id)->current();
        if(empty($row))
        {
            echo "No such record";
            return;
        }
        $row->active = 0;
        $row->save();
    }
    public function postSubmitConfig($formData)
    {
        if(!UserUtil::isAllowed('admin_index'))return;
        //delete all user setting to reset dashboard.
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_SETTING));
        $table->delete('id > 0');

        $root = Zend_Registry::get('root');
        $config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true,'skipExtends'=> true,));

        $widget_name = 'featured-employee';
        $config->{$widget_name}->{$widget_name}->title = $formData['title'];
        $config->{$widget_name}->{$widget_name}->order = $formData['order'];
        $config->{$widget_name}->{$widget_name}->position = $formData['position'];


        $item = new Precurio_ConfigWriter(array('config'   => $config,
            'filename' => $root.'/application/configs/precurio.ini'));

        $item->write();

        if(!empty($formData['user_id']))
        {
            $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::FEATURED_USER));
            $table->insert(array(
            	'user_id'=>$formData['user_id'],
                'comment'=>$formData['comment'],
                'expires'=>mktime(23,59,59,$formData['month'],$formData['day']),
                'date_created'=>time(),
                'active'=>1

            ));
        }


        return $this->_redirect('/widget/featured-employee/configure');
    }
}
?>