<?php
require_once ('widget/controllers/IndexController.php');
require_once ('cms/models/vo/Category.php');
class Widget_AnnouncementController extends Widget_IndexController
{
	public function configureAction()
	{
		if(!UserUtil::isAllowed('admin_index'))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_INVALID_ROLE);
			return;
		}
		$userSetting = UserUtil::getUser()->getSettings();
		$this->view->widget = $userSetting->getWidget('announcement');
		$this->renderScript('views/home/announcement_configure.phtml');
	}
	public function postSubmitConfig($formData)
	{
		if(!UserUtil::isAllowed('admin_index'))return;
		//delete all user setting to reset dashboard.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_SETTING));
		$table->delete('id > 0');

		$root = Zend_Registry::get('root');
		$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true,'skipExtends'=> true,));

		$config->announcement->announcement->title = $formData['title'];
		$config->announcement->announcement->order = $formData['order'];
		$config->announcement->announcement->position = $formData['position'];
		$config->announcement->announcement->category_id = $formData['category_id'];
		$config->announcement->announcement->maximum_age = $formData['maximum_age'];


		$item = new Precurio_ConfigWriter(array('config'   => $config,
	                                           'filename' => $root.'/application/configs/precurio.ini'));

		$item->write();
		return $this->_redirect('/widget/announcement/configure');
	}
}
?>