<?php
require_once ('widget/controllers/IndexController.php');
/**
 * AdsController
 *
 * @author
 * @version
 */

class Widget_AdsController extends Widget_IndexController {

	public function configureAction()
	{
		if(!UserUtil::isAllowed('admin_index'))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_INVALID_ROLE);
			return;
		}
		$userSetting = UserUtil::getUser()->getSettings();
		$this->view->widget = $userSetting->getWidget('ads');
		$this->renderScript('views/home/ads_configure.phtml');
	}
	public function postSubmitConfig($formData)
	{
		if(!UserUtil::isAllowed('admin_index'))return;
		//delete all user setting to reset dashboard.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_SETTING));
		$table->delete('id > 0');

		$root = Zend_Registry::get('root');
		$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true,'skipExtends'=> true,));

		$config->ads->ads->title = $formData['title'];
		$config->ads->ads->order = $formData['order'];
		$config->ads->ads->position = $formData['position'];
		$config->ads->ads->category_id = $formData['category_id'];
		$config->ads->ads->maximum_age = $formData['maximum_age'];


		$item = new Precurio_ConfigWriter(array('config'   => $config,
				'filename' => $root.'/application/configs/precurio.ini'));

		$item->write();
		return $this->_redirect('/widget/ads/configure');
	}

}
?>