<?php

require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('team/models/vo/TeamActivity.php');
class UserActivity extends Zend_Db_Table_Row_Abstract {

	protected $item;
	public function getProfilePicture()
	{
		return UserUtil::getUser($this->user_id)->getProfilePicture();
	}
	public function getBaseUrl()
	{
		return Zend_Controller_Front::getInstance()->getBaseUrl();
	}
	/**
	 * Gets the activity message
	 * @param string $form  - Form in which the message is need. Options are "feed","sms", "mail"
	 * @param int $subject_id [OPTIONAL] - ID of subject, usually passed by Mail Notification
	 * @param boolean $extranet [OPTIONAL] - Is the message to be sent to an extranet user? Defaults to False
	 * @return String
	 */
	public function getMessage($form = "feed",$subject_id = 0,$extranet=false)
	{
		$format = Precurio_Activity::getMessageFormat($this,$form);

		if(empty($this->subject_id))$this->_data['subject_id'] = $subject_id;

		try
		{
			$user = UserUtil::getUser($this->user_id);
			$subject = UserUtil::getUser($this->subject_id);
		}
		catch (Precurio_Exception $e)
		{
			$subject = "";
		}
		if($extranet)
		{
			$baseUrl = Precurio_Extranet::getBaseUrl();
			$messageUrl = "";
			$object = $this->getItem();
			if(is_a($object,'Precurio_ExtranetInterface'))
				$messageUrl = $object->getExtranetUrl();
			$messageUrl = $baseUrl.$messageUrl;
		}
		else
		{
			$baseUrl = $this->getBaseUrl();
			if($form == 'mail')
			{
				$config = Zend_Registry::get('config');
				$baseUrl = $config->base_url;
				if($baseUrl[strlen($baseUrl)-1] == "/")
					$baseUrl = substr($baseUrl,0, -1);//remove the last slash
			}

			$messageUrl = $baseUrl.$this->getMessageUrl();
		}
		$format = urldecode($format);
		$format = stripcslashes($format);
		$message = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$messageUrl,$subject,$this->user_id,$this->subject_id,$baseUrl,$this->getLabel(),$baseUrl.$user->getUrl());

		if($form == 'sms')
		    $message = strip_tags($message);
		    
		return $message;
	}
	/**
	 * Get the Item/Object that triggered the activity.
	 * @return Precurio_ObjectInterface
	 */
	public function getItem()
	{
		if(empty($this->item))
		{
			try
			{
				$this->item = Precurio_Registry::getObject($this->appid,$this->item_id,$this->type,$this->group_id);
			}
			catch(Exception $e)
			{
				$log = Zend_Registry::get('log');
				$log->err("There was a problem getting object for APP '".$this->appid."',  ID=".$this->item_id.
						", Type '".$this->type."', Group=".$this->group_id."   <br/>".serialize($e));;
				return null;
			}
		}
		return $this->item;
	}
	public function getSinceWhen()
	{
		$date = new Precurio_Date($this->date_created);
		return $date->getHowLongAgo();

	}
	public function getComments()
	{
		return Comment::getAll($this->activity_id, $this->appid);
	}

	/**
	 * Determines where $user_id should be able to see this activity
	 * @param $user_id
	 * @return Boolean
	 */
	public function canSee($user_id)
	{
		$object = $this->getItem();
		if(empty($object))return false;
		if(!$object->isActive())return false;
		if(empty($this->subject_id))return true;//no subject id means a public activity
		return $object->canAccess($user_id);
		/*
		 * For performance reasons,we have replaced the code block below with $object->canAccess().
		 * It seemed faster than getting all users and looping through them.
		 *
		$users = $object->getUsers();

		if($users == null)return true;//null is usually return if the object can be access by all users
		foreach($users as $user)
		{
			if($user->user_id == $user_id)return true;
		}
		return false;//default is no access.
		*/
	}

	//%1\$s == name of actor
	//%2\$s == pronoun i.e his or her
	//%3\$s == url
	//%4\$s == name of subject.
	public function getMessageUrl()
	{
		$object = $this->getItem();
		return $object->getUrl();
	}
	/**
	 * Returns a label for the activity, eg for an event, it returns the name of the event, for a content, it returns the name of the content
	 * @return string
	 */
	public function getLabel()
	{
		$object = $this->getItem();
		return $object->getTitle();
	}
	/**
	 * Get user who performed/trigger this activity
	 * @return User
	 */
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}
	/**
	 * Get the data activity was performed
	 * @return Precurio_Date
	 */
	public function getDate()
	{
		return new Precurio_Date($this->date_created);
	}
	/**
	 * Gets the activity registy. An object of the activity_registry table
	 */
	public function getRegistry()
	{
		return Precurio_Registry::get($this->appid, $this->type,$this->group_id);
	}
	/**
	 * Get subject for the mail message
	 * @param int $subject_id -OPTIONAL (Just incase we want to reference someone)
	 */
	public function getMailSubject($subject_id=0)
	{
		$activityR = $this->getRegistry();
		$format = $activityR->mail_subject;
		$tr = Zend_Registry::get('Zend_Translate');
		if(empty($format))
			return $tr->translate('[PRECURIO] New Activity');


		try
		{
			$user = UserUtil::getUser($this->user_id,true);
		}
		catch (Precurio_Exception $e)
		{
		}
		$baseUrl = $this->getBaseUrl();
		return getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),"","",0,0,"",$this->getLabel(),"");
	}
	/**
	 * @param int $activity_id
	 * @return UserActivity|TeamActivity
	 */
	public static function get($activity_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG, 'rowClass'=>'UserActivity'));
		$item = $table->fetchRow($table->select()->where('id = ?',$activity_id));
		if($item->group_id == 1)//this was a team activity
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG, 'rowClass'=>'TeamActivity'));
			$item = $table->fetchRow($table->select()->where('id = ?',$activity_id));
		}
		return $item;
	}
	public function getId()
	{
		return $this->id;
	}
}

?>