<?php

require_once ('Zend/Db/Table/Row/Abstract.php');
require_once ('cms/models/vo/Content.php');
require_once ('cms/models/vo/Category.php');
require_once ('user/models/UserSetting.php');
require_once ('user/models/UserUtil.php');
class User extends Zend_Db_Table_Row_Abstract implements Precurio_ObjectInterface, Precurio_SearchableInterface{
	public $full_name;
	public $fieldWeights = array(
		'first_name'=>'5',
		'last_name'=>'5',
		'work_phone'=>'5',
		'mobile_phone'=>'10',
		'birth_day'=>'5',
		'birth_month'=>'5',
		'gender'=>'5',
		'profile_picture_id'=>'20',
		'location_id'=>'5',
		'job_title'=>'10',
		'department_id'=>'5',
		'job_description'=>'10',
		'skills'=>'10',
		'password'=>'0',
		'email'=>'0'
	);
	const APPID = "user";
	const ACTIVITY_NEW_STATUS = "status";
	const ACTIVITY_CHANGE_PROFILE_PICTURE="picture";
	const ACTIVITY_CHANGE_PHONE_NUMBER = "phone";
	const ACTIVITY_CHANGE_LOCATION = "location";
	const ACTIVITY_CHANGE_JOB_TITLE = "job";
	const ACTIVITY_CHANGE_DEPARTMENT = "department";
	const ACTIVITY_CHANGE_PASSWORD = "password";
	const ACTIVITY_FORGOT_PASSWORD = "forgot";
	const ACTIVITY_NEW = "new";

	public function init()
	{
		//$this->id = $this->user_id;//this is a bug that comes alive when id <> user_id in table `user_details`
		//full_name property is used by contacts module,
		// where user objects also acts as contacts as in Co-workers.
		$this->full_name = $this->getFullName();
		//insert into data array so it is accessible as $row['full_name'] just like the other table fields
		$this->_data['full_name'] = $this->full_name;
	}
	/**Returns the user id.
	 * @return int
	 */
	public function getId()
	{
		//return $this->id;
		return $this->user_id;
	}
	/**
	 * @return string
	 */
	public function getEmail()
	{
		return $this->email;
	}
	/**
	 * First name
	 * @return string
	 */
	public function getFirstName($thirdPerson = false)
	{
		if($thirdPerson)return $this->first_name."'s";
		return $this->first_name;
	}
	/**Last name
	 * @return string
	 */
	public function getLastName()
	{
		return $this->last_name;
	}
	public function getWorkPhone()
	{
		return $this->work_phone;
	}
	public function getMobilePhone()
	{
		return $this->mobile_phone;
	}
	public function getBirthDay()
	{
		return $this->birth_day;
	}
	public function getBirthMonth()
	{
		return $this->birth_month;
	}
	/**
	 * Get birthday as date object
	 * @param string $format - Set format parameter to return data as string in specified format.[OPTIONAL]
	 * @return Zend_Date|string
	 */
	public function getBirthDate($format='')
	{
		$date = new Zend_Date();
		if($this->birth_day)$date->set($this->birth_day,Zend_Date::DAY);
		if($this->birth_month)$date->set($this->birth_month,Zend_Date::MONTH);
		if($this->birth_year)$date->set($this->birth_year,Zend_Date::YEAR);
		return empty($format) ? $date : $date->toString($format);;
	}
	public function getGender()
	{
		return $this->gender;
	}
	public function getLocationId()
	{
		return $this->location_id;
	}
	public function getJobTitle()
	{
		if(empty($this->job_title))return $this->job_title;
		return $this->job_title.(empty($this->department_id) ? ", ".$this->company : "" );//if there is not department, append company name
	}
	public function getDepartmentId()
	{
		return $this->department_id;
	}
	public function getJobDescription()
	{
		return $this->job_description;
	}
	public function getSkills()
	{
		return $this->skills;
	}
	public function getAddress()
	{
		return $this->address;
	}
	public function getProfilePictureId()
	{
		return $this->profile_picture_id;
	}
	public function getDateCreated()
	{
		return $this->date_created;
	}
	public function getDateJoined()
	{
		$date = new Precurio_Date($this->date_created);
		return $date->get(Zend_Date::DATETIME);
	}
	public function getLastUpdated()
	{
		return $this->last_updated;
	}
	public function getPercentageComplete()
	{
		$this->setPercentageComplete($this->calculateWeight());
		return $this->percentage_complete;
	}
	public function setPercentageComplete($value)
	{
		$this->percentage_complete = $value;
	}
	public function isActive()
	{
		return $this->active;
	}
	public function isOutOfOffice()
	{
		return $this->out_of_office;
	}
	public function isGuest()
	{
		return $this->isAnonymous();
	}
	public function isAnonymous()
	{
		return (strtolower(substr($this->getUsername(),0,5)) == 'guest');
	}
	/**
	 * Determines if the user is blocking any particular user
	 * @param int $user_id (id of user that may be blocked by this user)
	 * @return boolean
	 */
	public function isBlocked($user_id)
	{
		if($this->getId() == $user_id)return false;//you most certainly cannot block yourself.
		$blockedList = $this->getSettings()->getBlockedUsers();
		return (array_search($user_id, $blockedList) !== false);
	}
	/**
	 * Gets the out of office object, returns null if user is not out of office
	 * Serves as a proxy to outOfOffice()
	 * @return OutOfOffice
	 */
	public function getOutOfOffice()
	{
		return $this->outOfOffice();
	}

	/**
	 * Returns the total number of contents this user has on the intranet
	 * @return int
	 */
	public function getNumOfContents()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT));
		$contents = $table->fetchAll($table->select()->where('user_id= ? ',$this->getId()));
		return $contents->count();
	}
	/**
	 * Returns the total number of comments this user has on the intranet
	 * @return int
	 */
	public function getNumOfComments()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::COMMENTS));
		$comments = $table->fetchAll($table->select()->where('user_id= ? ',$this->getId()));
		return $comments->count();
	}
	/**
	 * Gets the user settings object
	 * @return UserSetting
	 */
	public function getSettings()
	{
		return new UserSetting($this->getId());
	}
	/**
	 * @param boolean $includeParents - Determine if you want to include entire parent tree (i.e. parents and grandparents of individual user group) - Defaults to false
	 * @return Zend_Db_Table_Rowset -  Collection of Group  objects the user belongs to.
	 */
	public function getGroups($includeParents = false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS, 'rowClass'=>'Group'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::GROUPS))
						->join(array('b' => PrecurioTableConstants::USER_GROUPS),'a.id = b.group_id',array('date_joined'=>'date_created'))
						->where('b.user_id = ? ',$this->getId())
						->where('a.active=1')
						->order('a.id DESC');

		$all = $table->fetchAll($select);
		if(!$includeParents)
			return $all;
		$groups = array();
		foreach($all as $group)
		{
			$groups[] = $group;
			$parent = $group->getParent();
			while($parent)
			{
				$groups[] = $parent;
				$parent = $parent->getParent();
			}
		}
		return $groups;
	}

	/**
	 * Returns the user roles
	 * @return array
	 */
	public function getRoles()
	{
		$groups  = $this->getGroups();
		$roles = array();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ROLES,'rowClass'=>'Role'));


		foreach($groups as $group)
		{
			if($group->is_role)
			{
				$role = $table->fetchRow($table->select()->where('group_id = ?',$group->id));
				$roles[] = $role;
			}
		}
		return $roles;
	}

	/**
	 * Returns the user's date of birth  e.g. "April 15"
	 * @return String
	 */
	public function getDOB()
	{
		try
		{
			$date =  new Precurio_Date();
			$date->setDay($this->getBirthDay());
			$date->setMonth($this->getBirthMonth());
			$str = $date->toString("MMMM dd");
		}
		catch(Exception $e)
		{
			$str = "";
		}


		return $str;
	}
	/**
	 * Returns all currently active contents created by the user.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getMyContents()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT, 'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT))
						->join(array('b' => PrecurioTableConstants::USERS),'a.user_id = b.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.user_id= ? ',$this->getId())
						->where('a.is_photo= 0')
						->where('a.active=1')
						->order('id DESC');

		$all = $table->fetchAll($select);
		return $all;
	}
	/**
	 * Alias to getCategorys
	 */
	public function getMyCategorys()
	{
		return $this->getCategorys();
	}

	/**
	 * Returns all currently active contents that has been shared with the user.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getSharedContents()
	{

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::SHARED_CONTENTS, 'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('b' => PrecurioTableConstants::CONTENT))
						->join(array('a' => PrecurioTableConstants::SHARED_CONTENTS),'a.content_id = b.id',array('user_id'))
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.sharer_id= ? ',$this->getId())
						->where('b.active=1')
						->order('id DESC');

		$all = $table->fetchAll($select);
		return $all;


	}
	public function getPhotos()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT, 'rowClass'=>'Content'));
		$photos = $table->fetchAll($table->select()->where('user_id= ? ',$this->getId())
														->where('is_photo = ? ',1)
														->where('active=1')
														->order('id DESC'));
		return $photos;
	}

	public function getGenderPronoun($thirdPerson = false)
	{
		$translate = Zend_Registry::get('Zend_Translate');
		if(strtolower($this->gender) == 'male' )
		{
			if($thirdPerson)
				return $translate->translate('him');
			else
				return $translate->translate('his');
		}
		return $translate->translate('her');
	}
	/**
	 * Gets the out of office object, returns null if user is not out of office
	 * @return OutOfOffice
	 */
	public function outOfOffice()
	{
		if(!$this->out_of_office)return null;//dont waste the cpu's time
		$obj =  OutOfOffice::get($this->getId());
		if($obj->isExpired())
		{
			$obj->deactivate();
			return null;
		}
		return $obj;
	}
	public function getLocation()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LOCATIONS,'rowClass'=>'Location'));
		$location = $table->fetchRow($table->select()->where('id= ? ',$this->getLocationId()));
		return $location == null ? '' : $location->getTitle();
	}
	/**
	 * Returns path to user profile picture
	 * @return string
	 */
	public function getProfilePicture()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PROFILE_PICS));
		$pic = $table->fetchRow($table->select()->where('id= ? ',$this->getProfilePictureId()));
		$config = Zend_Registry::get('config');
		return $pic == null ? '/library/themes/'.$config->theme->default.'/css/upload/staff-graphic.png' : $pic->image_path;
	}

	/**
	 * Returns all categorys the user has access to (i.e. private, public, shared)
	 * @param $getFolders boolean - Get folders instead of categories. Default = false.
	 * @return array
	 */
	public function getCategorys($getFolders=0)
	{
		$public = Category::getPublicCategorys($getFolders);
		$private = Category::getPrivateCategorys($this->getId(),$getFolders);
		$shared = Category::getSharedCategorys($this->getId(),$getFolders);
		$arr = array($public,$private,$shared);
		$result = array();
		foreach($arr as $item)
		{
			foreach($item as $category)
			{
				$result[] = $category;
			}
		}
			function fn($a,$b)
			{
				$a = strtolower($a->title);$b=strtolower($b->title);
				return ($a == $b) ? 0 : (($a > $b)? 1 : -1);
			}
		usort($result, 'fn');//sort categorys by title, in ascending order
		return $result;
	}

	/**
	 * Strips the username from the email address
	 * @return String
	 */
	public function getUsername()
	{
		return $this->username;
	}
	/**
	 * Accepts the image path, inserts in into the DB and returns the last insert id
	 * @param String $imagePath Path to the new profile picture
	 * @return int profile_pic_id
	 */
	public function newProfilePic($imagePath)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::PROFILE_PICS));
		$insertId = $table->insert(array('image_path'=>$imagePath,'user_id'=>$this->getId()));
		return $insertId;
	}
	/**
	 * Called by getPercentageComplete only when it percentage_complete is zero.
	 * @return int
	 */
	private function calculateWeight()
	{
		$totalWeight = 0;
		foreach($this->fieldWeights as $field=>$weight)
		{
			if(!Precurio_Utils::isNull($this[$field]))
			{
				$totalWeight += $weight;
			}
		}
		return $totalWeight;
	}
	public function getDepartment()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DEPARTMENTS,'rowClass'=>'Department'));
		$department = $table->fetchRow($table->select()->where('id= ? ',$this->getDepartmentId()));
		return $department ==  null ? '' :$department->getTitle();
	}
	public function getFullName()
	{
		return $this->first_name .' '. $this->last_name;
	}
	public function update($params)
	{
		$url = '/user/profile/view/'.$this->getId();
		$currentWeight = $this->getPercentageComplete();
		foreach($this->fieldWeights as $field=>$weight)
		{
			if(!isset($params[$field]))continue;//parameter does not exist
			if($this[$field] == $params[$field])continue;//new value is same as previous value
			if(Precurio_Utils::isNull($this[$field]))
			{
				//i.e previous value is  null and you are updating with a real value
				if(!Precurio_Utils::isNull($params[$field]))
				{
					$currentWeight += $weight;
					if($field == 'profile_picture_id')//send add profile picture activity.
						Precurio_Activity::create(User::APPID, User::ACTIVITY_CHANGE_PROFILE_PICTURE, $this->getId(), $this->getId());
					if($field == 'location_id')$this->locationChanged($this['location_id'],$params['location_id']);
					if($field == 'department_id')$this->departmentChanged($this['department_id'],$params['department_id']);
				}
			}
			else
			{
				//i.e previous value is not null and you are updating with a null value
				//this should hardly ever happen
				if(Precurio_Utils::isNull($params[$field]))
					$currentWeight -= $weight;
				else//you are changing it. points wont apply, but that is a portal update
				{

					$activityType = "";
					switch($field)
					{
						case 'profile_picture_id':
							$activityType = self::ACTIVITY_CHANGE_PROFILE_PICTURE;
							break;
						case 'work_phone':
						case 'mobile_phone':
							$activityType = self::ACTIVITY_CHANGE_PHONE_NUMBER;
							break;
						case 'location_id':
							$activityType = self::ACTIVITY_CHANGE_LOCATION;
							$this->locationChanged($this['location_id'],$params['location_id']);
							break;
						case 'job_title':
							$activityType = self::ACTIVITY_CHANGE_JOB_TITLE;
							break;
						case 'department_id':
							$activityType = self::ACTIVITY_CHANGE_DEPARTMENT;
							$this->departmentChanged($this['department_id'],$params['department_id']);
							break;
						case 'email'://this is one wont be broadcasted.
							$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
							$row = $table->fetchRow($table->select()->where('id = ?',$this->user_id));
							$row->identity = $params['email'];
							$row->save();
							//set username too
							$params['username'] = substr($params['email'],0,stripos($params['email'], '@'));
							break;
						case 'password':
							$this->updatePassword($params['password']);
							break;
					}
					if($activityType != "")
						Precurio_Activity::create(User::APPID, $activityType, $this->getId(), $this->getId());
				}

			}
		}
		$this->setPercentageComplete($currentWeight);
		$param['percentage_complete'] = $currentWeight;//include into update list

		//now perform the update
		foreach ($params as $param=>$value)
		{
			if(isset($this[$param]) && $param != "password") //do not update password with raw value. Already done in updatePassword method
				$this[$param] = $value;
		}

		$this->save();
		$this->index();
	}

	public function toCSVString()
	{
		$data = array($this->getFullName(),$this->company,$this->email,$this->job_title,
		'',$this->mobile_phone,$this->work_phone,'',''
		);
		array_walk($data,'self::pdStr');
		return implode(",",$data);

	}
	public function __toString()
	{
		return $this->getFullName();
	}
	private function pdStr(&$value,$key)
	{
		$value = ltrim($value);
		if($value[0] == '+' && stripos($value,' ')===FALSE)
		{
			str_ireplace('-',' ',$value);
			$i = stripos($value,'-');
			$value[$i] = ' ';
		}
		$value = '"'.$value.'"';
	}

	private function locationChanged($old_location_id,$new_location_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LOCATIONS));
		$old_location = $table->find($old_location_id)->current();
		if($old_location)$old_group_id = $old_location['group_id'];

		$new_location = $table->find($new_location_id)->current();
		$new_group_id = $new_location['group_id'];

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_GROUPS));
		if($old_location)
			$row = $table->fetchRow($table->select()->where('user_id = ?',$this->user_id)->where('group_id = ?',$old_group_id));
		if($row)$row->delete();

		UserUtil::addUserToGroup($this->user_id,$new_group_id);

	}

	private function departmentChanged($old_department_id,$new_department_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DEPARTMENTS));
		$old_department = $table->find($old_department_id)->current();
		if($old_department)$old_group_id = $old_department['group_id'];

		$new_department = $table->find($new_department_id)->current();
		$new_group_id = $new_department['group_id'];

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_GROUPS));
		if($old_department)
			$row = $table->fetchRow($table->select()->where('user_id = ?',$this->user_id)->where('group_id = ?',$old_group_id));
		if($row)$row->delete();

		UserUtil::addUserToGroup($this->user_id,$new_group_id);
	}
	/**
	 * This does not actually create a user, it simple creates a user object.
	 * For object testing purposes only.
	 * @return User
	 */
	public static function createNew()
	{
		$user = new User(array(
		'table'=>new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User')),
		'data'=>array(
			'id'=>0,
			'user_id'=>0,
			'first_name'=>'',
			'last_name'=>'',
			'work_phone'=>'',
			'mobile_phone'=>'',
			'birth_day'=>'',
			'birth_month'=>'',
			'gender'=>'',
			'profile_picture_id'=>'',
			'location_id'=>'',
			'job_title'=>'',
			'department_id'=>'',
			'job_description'=>'',
			'skills'=>''
		)
		));
		return $user;
	}
	public function updatePassword($password)
	{
		$this->password = md5($password);
		$this->save();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->find($this->user_id)->current();
		$row->credential = md5($password);
		$row->save();

		if(Bootstrap::usesDatabase())
		{
			Precurio_Activity::create(User::APPID, self::ACTIVITY_CHANGE_PASSWORD, $this->getId(), $this->getId());
		}
		return;
	}
	/**
	 * Get the maximum disk space allotted to a user.
	 * @retun int - size of disk in MB
	 */
	public function getDiskQuota()
	{
		$config = Zend_Registry::get('config');
		if(!empty($config->max_user_disk_size))
		{
			return $config->max_user_disk_size;
		}
		return 100;//100MB is application default.
	}

	/**
	 * Get all tasks assigned to users that is currently open.
	 * Currently used by ProcessManager to get the user with least open tasks
	 * @return Ambiguous
	 */
	public function getOpenTasks()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'Task'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::TASK))
						->join(array('b' => PrecurioTableConstants::TASK_USERS),'a.id = b.task_id',array('user_id','is_proxy','is_transfer','date_assigned'=>'date_created'))
						->join(array('c' => PrecurioTableConstants::USERS),'a.creator_user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.active=1')
						->where('b.active=1')
						->where('b.user_id = ?' ,$this->getId())
						->where('a.status = ?' ,Task::STATUS_OPEN)
						->order('id desc');
		return $table->fetchAll($select);
	}
	/**
	 * Get url to user profile
	 * @return string
	 */
	public function getUrl()
	{
		return '/user/profile/view/'.$this->getId();
	}
	/**
	 * Gets the most recent personal message of the user
	 * @return string
	 */
	public function getPersonalMessage()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATUS_MESSAGES,'rowClass'=>'UserStatus'));
		$row  = $table->fetchRow($table->select()->where('user_id = ?',$this->getId())->order('id DESC'));
		return empty($row) ? '' : $row->message;
	}
	/**
	 * Returns a string that would be searched.
	 * @return string
	 */
	public function getSearchStr()
	{
		return $this->getFullName().' '.$this->getEmail().' '.$this->getJobTitle().' '.$this->getJobDescription().' '.$this->getSkills();
	}
	/**
	 * See if a string can be found in any user information.
	 * Returns true if found.
	 * @param string $str
	 * @return boolean
	 */
	public function search($str)
	{
		return (stripos($this->getSearchStr(),$str) !== FALSE) ? true: false;
	}
	/**
	 * Returns the full name of the user
	 * Every precurio object should have a getTitle method.
	 * @return string
	 */
	public function getTitle()
	{
		return $this->getFullName();
	}
	/**
	 * Determine if user is an extranet/external user
	 * @return boolean
	 */
	public function isExternal()
	{
		return $this->is_external;
	}
	public function canAccess($user_id)
	{
		return !$this->isBlocked($user_id);
	}
	public function getItemId()
	{
		return $this->getId();
	}
	public function getUsers()
	{
		return array();
	}
	public function index()
	{
		$index = Precurio_Search::getIndex();

		//first remove user from the index if it exists
		$hits = $index->find('id:' . $this->getId().' AND module:'.self::APPID);
		foreach ($hits as $hit)
			$index->delete($hit->id);
		$index->commit();

		if(!$this->isActive())return;

		$user = $this;

		$doc = new Zend_Search_Lucene_Document();
		$doc->addField(Zend_Search_Lucene_Field::keyword('id',$user->getId()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('user_id',$user->getId()));
		$doc->addField(Zend_Search_Lucene_Field::text('title',$user->getFullName()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('job',$user->getJobTitle()));
		$doc->addField(Zend_Search_Lucene_Field::text('fullname',$user->getFullName()));
		$doc->addField(Zend_Search_Lucene_Field::text('email',$user->getEmail()));
		$doc->addField(Zend_Search_Lucene_Field::text('location',$user->getLocation()));
		$doc->addField(Zend_Search_Lucene_Field::text('department',$user->getDepartment()));
		$doc->addField(Zend_Search_Lucene_Field::text('skill',$user->getSkills()));
		$doc->addField(Zend_Search_Lucene_Field::text('description',$user->getJobDescription()));
		$doc->addField(Zend_Search_Lucene_Field::unIndexed('profile_picture',$user->getProfilePicture()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('mobile',$user->getMobilePhone()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('work',$user->getWorkPhone()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('tag','staff'));
		$doc->addField(Zend_Search_Lucene_Field::text('power',$user->getFullName()));
		$doc->addField(Zend_Search_Lucene_Field::text('url',$this->getUrl()));
		$doc->addField(Zend_Search_Lucene_Field::keyword('module',self::APPID));

		$index->addDocument($doc);
	}

	/**
	 * Get the last activity performed by the user
	 * @return UserActivity
	 */
	public function getLastActivity()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG, 'rowClass'=>'UserActivity'));
		$row = $table->fetchRow($table->select()->where("user_id = ?",$this->getId())->order("date_created DESC"));
		return $row;
	}
	/**
	 * Gets the userid of the boss
	 * @return int
	 */
	public function getBossId()
	{
		return $this->boss_id;
	}
	/**
	 * @return Ambigous <User, NULL, Zend_Db_Table_Row_Abstract, unknown>
	 */
	public function getBoss()
	{
		if(empty($this->boss_id))return null;
		return UserUtil::getUser($this->boss_id);
	}
	/**
	 * Proxy to getBoss method
	 * @return Ambigous <Ambigous, NULL, User, Zend_Db_Table_Row_Abstract, unknown>
	 */
	public function getSupervisor()
	{
		return $this->getBoss();
	}
	/**
	 * Gets the company the user belongs to.
	 * @return string
	 */
	public function getCompany()
	{
		return $this->company;
	}
	public function deactivate()
	{
		$this->active = 0;
		$this->save();
	}
}

?>