<?php
require_once ('document/models/vo/RootFolder.php');

class TeamRootFolder extends RootFolder {

	public function __construct($team_id)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		$this->_data = array(
				'id'=>0,
				'group_id'=>$team_id,
				'user_id'=>0,
				'parent_id'=>RootFolder::SPECIAL_ID_SHARED,
				'title'=>$tr->translate('Team Documents'),
				'description'=>'',
				'access_type'=> Category::ACCESS_SHARED,
				'special_id'=>RootFolder::getSpecialIdFromAccessType(Category::ACCESS_SHARED)
		);
		return $this;
	}
	public function getUrl()
	{
		$team = Team::get($this->group_id);
		return $team->getUrl('document');
	}
	/**
	 * Returns the sub-categorys of a root folder
	 * @param boolean $recursive |default true| - IGNORED
	 * @param int $category_id |default 0| - IGNORED
	 * @return array
	 */
	public function getCategoryChildren($recursive = true,$category_id=0)
	{

		$result = array();

		//Get categories shared with this team
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'TeamFolder'));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
		->join(array('b' => PrecurioTableConstants::GROUP_CATEGORYS),'a.id = b.category_id',array('sharer_id'=>'user_id','group_id'))
		->where('a.active = 1')
		->where('b.active = 1')
		->where('a.parent_id = 0')
		->where('a.is_folder = 1')
		->where('b.group_id = ?',$this->group_id);
		$groupShared = $table->fetchAll($select);
		foreach($groupShared as $category)
		{
			$result[$category->id] = $category;//using $result[$t->id] solves the issue of duplicate category, since  already existing categorys will replace themselves
		}

		return $result;
	}

	/**
	 * Returns the documents of a root folder
	 * @param boolean $recursive |default true| - IGNORED
	 * @param int $category_id |default 0| - IGNORED
	 * @return array
	 */
	public function getContentChildren($recursive = true)
	{

		$result = array();

		//get all root documents shared with user
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'TeamDocument'));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
		->join(array('c' => PrecurioTableConstants::CONTENT_CATEGORYS),'a.id = c.content_id',array())
		->join(array('d' => PrecurioTableConstants::GROUP_CONTENTS),'a.id = d.content_id',array('group_id'))
		->where('c.category_id <=0')
		->where('c.category_id > ?',RootFolder::SPECIAL_ID_HELPDESK)
		->where('d.group_id = ?',$this->group_id)
		->order('b.last_modified desc');

		$rows = $table->fetchAll($select);

		foreach($rows as $document)
		{
			$result[$document->id] = $document;
		}
		return $result;
	}

	public function addContents($content_ids,$access_type = Category::ACCESS_SHARED)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		if(!is_array($content_ids))$content_ids = array($content_ids);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$table2 = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_CONTENTS));
		foreach($content_ids as $content_id)
		{
			$table->insert(array(
					'category_id'=>$this->special_id,
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1
			));
			$table2->insert(array(
					'content_id'=>$content_id,
					'group_id'=>$this->group_id,
					'task_id'=>0,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1
			));
		}

		return;
	}

	public function getGroups()
	{
		$groups = array();
		$groups[] = UserUtil::getGroup($this->group_id);

		return $groups;
	}
}

?>