<?php

require_once ('document/models/vo/Document.php');
require_once ('team/models/vo/TeamFolder.php');
require_once ('team/models/vo/TeamRootFolder.php');
class TeamDocument extends Document {
	const VIEW_URL = '/team/document/view/id/{1}/t_id/{2}';
	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId(),$this->group_id);
	}

	/**
	 * Gets a document by its Id
	 * @param int $id
	 * @throws Precurio_Exception
	 * @return TeamDocument
	 */
	public static function get($id,$group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'TeamDocument'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id')
		->join(array('c' => PrecurioTableConstants::GROUP_CONTENTS),'c.group_id = '.$group_id,array('group_id'))
		->where('b.id = ?',$id);
		$row = $table->fetchRow($select);

		$tr = Zend_Registry::get('Zend_Translate');
		if(empty($row))
			throw new Precurio_Exception($tr->translate(PrecurioStrings::INVALIDCONTENT),Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		return $row;
	}
	public function init()
	{
		parent::init();
		if(!isset($this->_data['group_id']))$this->_data['group_id'] = 0;
	}
}

?>