<?php

require_once("discussion/models/vo/Discussion.php");
require_once("team/models/vo/Team.php");
class TeamDiscussion extends Discussion {

	const VIEW_URL = "/team/discussion/view/id/{1}/t_id/{2}";
	const ACTIVITY_ADD_TEAM = "add_group";
	public static function getAll($team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'TeamDiscussion'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::DISCUSSIONS))
		->join(array('b' => PrecurioTableConstants::DISCUSSION_GROUPS),'a.id = b.discussion_id',array('group_id'))
		->where('a.active = 1')
		->where('b.group_id = ?',$team_id)
		->order('last_updated desc');
		$items = $table->fetchAll($select);
		//remove duplicates caused by joining tables
		$result = array();
		foreach($items as $item)
		{
			$result[$item->id] = $item;
		}
		return $result;

	}
	public function getUrl()
	{
		return getLocalizedString(self::VIEW_URL,$this->getId(),$this->group_id);
	}
	/**
	 * Returns a collection of User objects that have access to the discussion.
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getUsers()
	{
		return UserUtil::getGroup($this->group_id)->getUsers();
	}

	/**
	 * Gets a discussion object.
	 * Returns null if object does not exist
	 * @param int $id - ID of the discussion
	 * @param int $team_id - ID of the team
	 * @return TeamDiscussion
	 */
	public static function get($id,$team_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'TeamDiscussion'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
		->from(array('a' => PrecurioTableConstants::DISCUSSIONS))
		->join(array('b' => PrecurioTableConstants::DISCUSSION_GROUPS),'a.id = b.discussion_id',array('group_id'))
		->where('b.group_id = ?',$team_id)
		->where('a.id = ?',$id);
		return $table->fetchRow($select);
	}
	/**
	 * Determines if a user has access to the discussion
	 * @param int $user_id
	 * @return boolean
	 */
	public function canAccess($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSION_GROUPS));
		$rows = $table->fetchAll($table->select()->where('discussion_id = ?',$this->getId())->where('active = 1'));
		foreach($rows as $row)
		{
			$team = Team::get($row->group_id);
			if($team->containsMember($user_id))return true;
		}
		return false;//user is not a member of any group with access to this task
	}
	/**
	 * Determines if a team has access to the discussion
	 * @param int $group_id
	 * @return boolean
	 */
	public function canTeamAccess($group_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSION_GROUPS));
		$row = $table->fetchRow($table->select()->where('discussion_id = ?',$this->getId())->where('active = 1')->where('group_id = ?',$group_id));
		return !empty($row);
	}
	/**
	 * Creates a discussion object
	 * @param $data
	 * @param $team_id
	 * @return Discussion
	 */
	public static function createNew($data,$team_id)
	{
		$data['is_team'] = 1;
		if(!isset($data['category_id']))$data['category_id'] = 0;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS,'rowClass'=>'TeamDiscussion'));
		$row = $table->createRow();
		$row->setFromArray($data);
		$id = $row->save();

		$row->addTeam($team_id,$data['creator_user_id']);

		Precurio_Activity::create(Discussion::APPID,Discussion::ACTIVITY_NEW,$id,$data['creator_user_id'],null,0,$team_id);

		//initialise
		if(!empty($data['message']))
		{
			Comment::create($data['creator_user_id'],$data['message'], $id, Discussion::APPID,$team_id);
		}

		return self::get($id,$team_id);
	}
	public function addTeam($team_id,$user_id = 0)
	{
		if(empty($team_id))return;
		if(empty($user_id))$user_id = Precurio_Session::getCurrentUserId();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSION_GROUPS));
		$time = Precurio_Date::now()->getTimestamp();
		$table->insert(array('group_id'=>$team_id,'discussion_id'=>$this->getId(),'date_created'=>$time,'active'=>1));

		Precurio_Activity::create(Discussion::APPID,self::ACTIVITY_ADD_TEAM,$this->getId(),$user_id,null,0,$team_id);
	}
	/**
	 * Posts a message or comment in the discussion
	 * @param int $user_id
	 * @param string $message
	 */
	public function postMessage($user_id,$message)
	{
		$message = trim($message);
		if(!empty($message))
			Comment::create($user_id, $message, $this->getId(), self::APPID,$this->group_id);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DISCUSSIONS));
		$table->update(array('last_updated'=>Precurio_Date::now()->getTimestamp()), "id = ".$this->getId());
	}
}

?>