<?php

require_once ('user/models/vo/Group.php');
require_once ('team/models/vo/TeamActivity.php');
require_once ('team/models/vo/Template.php');
class Team extends Group implements Precurio_ObjectInterface
{
	const APPID = "team";
	const ACTIVITY_ADD_USER = "add_user";
	const ACTIVITY_NEW = "new";
	public function getApps()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_APPS));
		$rows = $table->fetchAll($table->select()->where('group_id = ?',$this->getId())->where('active = 1'));
		$apps = array();
		foreach($rows as $row)
		{
			try{$apps[] = new Precurio_Module($row->appid);}
			catch(Exception $e){/*do nothing upon seeing an invalid app*/};
		}
		return $apps;
	}
	/**
	 * @param int $user_id
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS, 'rowClass'=>'Team'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::GROUPS))
		->join(array('b' => PrecurioTableConstants::USER_GROUPS),'a.id = b.group_id',array('date_joined'=>'date_created'))
		->where('b.user_id = ? ',$user_id)
		->where('a.active=1')
		->where('a.is_team = 1')
		->order('a.id DESC');

		return $table->fetchAll($select);
	}

	/**
	 * @param int $user_id
	 * @param string $filtered_by
	 * @return Zend_Db_Table_Rowset_Abstract
	 * @author nifemi
	 */
	public static function getfilteredAll($user_id, $filtered_by)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS, 'rowClass'=>'Team'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::GROUPS))
			->join(array('b' => PrecurioTableConstants::USER_GROUPS),'a.id = b.group_id',array('date_joined'=>'date_created'))
			->where('b.user_id = ? ',$user_id)
			->where('a.title like ?', '%'.$filtered_by.'%')
			->where('a.active=1')
			->where('a.is_team = 1')
			->order('a.id DESC');

		return $table->fetchAll($select);
	}
	/**
	 * Gets a team object
	 * @param int $id - Primary Key/ID of Team
	 * @return Team
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS,'rowClass'=>'Team'));
		return $table->fetchRow($table->select()->where('id = ? ',$id)->where('is_team = 1'));
	}
	/**
	 * Gets url to a team app.
	 * @param string $appid
	 * @return string
	 */
	public function getUrl($appid="document")
	{
		if(empty($appid))
			return '/team/view/'.$this->getId();
		return '/team/'.$appid.'/index/t_id/'.$this->getId();

	}
	public function getUpdates($since=null,$limit = 20)
	{
		return TeamActivity::getUpdates($this->getId(),$since,$limit);
	}
	public function getItemId()
	{
		return $this->id;
	}
	public function canAccess($user_id)
	{
		return $this->containsMember($user_id);
	}
	public function addUserMember($user_id)
	{
		parent::addUserMember($user_id);
		Precurio_Activity::create(Team::APPID,Team::ACTIVITY_ADD_USER,$this->getId(),Precurio_Session::getCurrentUserId(),null,$user_id,$this->getId());
	}
	/**
	 * Creates a team.
	 * @param array $data
	 */
	public static function create($data)
	{
		if(empty($data['title']))
		{
			throw new Precurio_Exception("Could not create group, no title provided", $type);
		}
		if(empty($data['active']))$data['active'] = 1;
		if(empty($data['user_id']))$data['user_id'] = Precurio_Session::getCurrentUserId();
		if(empty($data['date_created']))$data['date_created'] = Precurio_Date::now()->getTimestamp();
		$data['is_department'] = 0;
		$data['is_location'] = 0;
		$data['is_role'] = 0;
		$data['is_default'] = 0;
		$data['is_team'] = 1;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS));
		$row = $table->createRow();
		$row->setFromArray($data);
		$id = $row->save();
		$team = self::get($id);
		$activity_id = Precurio_Activity::create(Team::APPID,Team::ACTIVITY_NEW,$id,$data['user_id'],null,0,$id);

		//create team folder
		//this is done so that all folders created in the teamroom are neatly placed in this folder, and are hidden from main documents view
		$folder_id = Folders::createNew(array(
				"title"=>$data['title'],
				"user_id"=>$data['user_id'],
				"appid"=>Team::APPID,
				"access_type"=>TeamFolder::ACCESS_SHARED,
				"group_id"=>$id,
				"date_created"=>Precurio_Date::now()->getTimestamp(),
				"active"=>0 //delete folder so it doesn't show up in main documents
		));
		
		//activate team apps
		if($data['apps'])
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_APPS));
			foreach($data['apps'] as $app)
			{
				$table->insert(array('group_id'=>$id,'appid'=>$app,'active'=>1,'date_created'=>$data['date_created']));
			}
		}


		if(!isset($data['users']))$data['users'] = array();
		//first get group members
		if($data['groups'])
		{
			foreach($data['groups'] as $group_id)
			{
				$group = UserUtil::getGroup($group_id);
				$members = $group->getUsers();
				foreach($members as $user)
				{
					$data['users'][] = $user->getId();
				}
			}
		}

		//now add users to team
		if($data['users'])
		{
			foreach($data['users'] as $user_id)
			{
				$team->addUserMember($user_id);
			}
		}

		//also invite external users
		if($data['emails'])
		{
			foreach ($data['emails'] as $email)
			{
				Precurio_Extranet::invite($data['user_id'], $email, $activity_id);
			}
		}
		//perform template actions
		if(isset($data['team_template_id']) && $data['team_template_id'] == 1)
		{
			$template = Template::get($data['team_template_id']);
			$template->applyTo($team);
		}
		
		return $id;
	}
	/**
	 * Get the last time the workspace was updates. Uses the activity log to determine when last a create or edit action was called.
	 * @return Precurio_Date
	 */
	public function getDateUpdated()
	{
	    $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG));
	    $row = $table->fetchRow($table->select()->where('group_id = ?',$this->getId())->where('type = ?','new')->orWhere('type = ?','add')->orWhere('type = ?','create')->orWhere('type = ?','edit')->order('date_created desc'));
	    $timestamp = empty($row) ? $this->date_created : $row->date_created;
	    return new Precurio_Date($timestamp);
	}

	public function setApps($apps)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_APPS));
		$table->delete("group_id = ".$this->getId());
		foreach($apps as $app)
		{
			$table->insert(array('group_id'=>$this->getId(),'appid'=>$app,'active'=>1,'date_created'=>time()));
		}
	}
	/**
	 * @return TeamFolder | TeamRootFolder
	 */
	public function getFolder()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CATEGORYS))
		->join(array('b' => PrecurioTableConstants::GROUP_CATEGORYS),'a.id = b.category_id',array('group_id','category_id'))
		->where('a.parent_id = 0')
		->where('b.group_id = ?',$this->getId())
		->where('a.access_type = ?',TeamFolder::ACCESS_SHARED)
		->where('a.appid = ?', Team::APPID);//Note that the previous 3 where clause will select all folders in the 
											//team room (in previous versions), but from this version, only team folders 
											//have appid = team
		$item = $table->fetchRow($select);
		
		if($item)
			return TeamFolder::get($item->id, $this->getId());
		else 
			return new TeamRootFolder($this->getId());
	}
	public function do_delete()
	{
		$this->active = 0;
		$this->save();
		
		//Delete all associated tasks.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK));
		$table->update(array("active"=>0), "creator_group_id = ".$this->getId());
		
		//Note: There is no need to delete associated folders, since the teamfolder is hidden. @mayorbrain 05/Nov/2014
	}
}

?>