<?php

/**
 * NoteController
 *
 * @author
 * @version
 */

require_once 'team/controllers/BaseController.php';
require_once "team/models/vo/TeamNote.php";

class Team_NoteController extends Team_BaseController {

	public function indexAction()
	{
		$team = $this->view->team;
		$notes = TeamNote::getAll($team->getId());

		$tag = $this->getRequest()->getParam('tag','');

		if(!empty($tag))
		{
			$result = array();
			foreach($notes as $note)
			{
				if($note->isTagged($tag))
				{
					$result[] = $note;
				}
			}
		}

		$this->view->tag = $tag;
		$this->view->notes = isset($result) ? $result : $notes;

	}
	public function viewAction()
	{
		$team = $this->view->team;
		$id = $this->getRequest()->getParam('id');
		$note = TeamNote::get($id,$team->getId());
		if(empty($note) || !$note->canTeamAccess($this->getParam('t_id')))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		if(!$note->isActive())
		{
			$this->_redirect($team->getUrl('note'));
		}
		$this->view->note  = $note;
		Precurio_Activity::create(TeamNote::APPID,TeamNote::ACTIVITY_VIEW,$id,Precurio_Session::getCurrentUserId(),null,0,$team->getId());
	}
	/**
	 *Display create note form
	 */
	public function addAction()
	{

	}
	public function editAction()
	{
		$team = $this->view->team;
		$id = $this->getRequest()->getParam('id');
		$note = TeamNote::get($id,$team->getId());
		if(empty($note) || !$note->canTeamAccess($this->getParam('t_id')))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		if(!$note->isActive())
		{
			$this->_redirect($team->getUrl('note'));
		}
		$this->view->note  = $note;
	}
	public function deleteAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$team = $this->view->team;
		$id = $this->getRequest()->getParam('id');
		$note = TeamNote::get($id,$team->getId());
		if(empty($note) || !$note->canTeamAccess($this->getParam('t_id')))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		if(!$note->isActive())
		{
			$this->_redirect($team->getUrl('note'));
		}
		$this->view->note  = $note;
	}
	/**
	 * Action called on submit create new note
	 */
	public function submitAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$time = Precurio_Date::now()->getTimestamp();
		$user_id = Precurio_Session::getCurrentUserId();
		//$params['message'] = trim($params['message']);
		$data = array('creator_user_id'=>$user_id,'title'=>$params['subject'],'body'=>$params['message'],'date_created'=>$time,'last_updated'=>$time,'active'=>1);

		$note = TeamNote::createNew($data,$this->getParam('t_id'));

		$this->_redirect($note->getUrl());
	}
	public function updateAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getParams();
		$note = TeamNote::get($params['id'],$params['t_id']);


		if(isset($params['delete']))
		{
			$note->do_delete();
			return $this->_redirect($this->view->team->getUrl('note'));
		}

		if(empty($params['team_edit']))$params['team_edit'] = 0;
		if(isset($params['message']));
			$note->updateContent($params['message'],$params['team_edit']);

		$this->_redirect($note->getUrl());
	}
	protected  function getAppName()
	{
		return "note";
	}

}
