<?php
require_once ('document/models/Folders.php');
require_once ('document/models/vo/ISpecialFolder.php');

class TaskFolder extends Folder implements ISpecialFolder
{
	protected $item_id;
	public function __construct($task_id)
	{

		$tr = Zend_Registry::get('Zend_Translate');
		$this->_data = array(
		'id'=>RootFolder::SPECIAL_ID_TASK,
		'user_id'=>0,
		'parent_id'=>RootFolder::SPECIAL_ID_SHARED,
		'title'=>$tr->translate('Task Documents'),
		'description'=>'',
		'access_type'=>RootFolder::ACCESS_SHARED,
		'special_id'=>RootFolder::SPECIAL_ID_TASK
		);
		$this->item_id = $task_id;
	}
	public function getUrl()
	{
		return getLocalizedString(Task::VIEW_URL,$this->getItemId());
	}
	public function getAppId()
	{
		return Task::APPID;
	}
	public function getItemId()
	{
		return $this->item_id;
	}
	public function getActivityType()
	{
		return Task::ACTIVITY_ADD_FILE;
	}
	public function addContents($content_ids,$access_type = Category::ACCESS_PRIVATE)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		if(!is_array($content_ids))$content_ids = array($content_ids);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$table2 = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		foreach($content_ids as $content_id)
		{
			$table->insert(array(
					'category_id'=>$this->special_id,
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1
			));
			$table2->insert(array(
					'appid'=>$this->getAppId(),
					'item_id'=>$this->getItemId(),
					'content_id'=>$content_id,
					'user_id'=>$user_id,
					'date_created'=>Zend_Date::now()->getTimestamp(),
					'active'=>1

			));
			Precurio_Activity::create($this->getAppId(),$this->getActivityType(),$this->getItemId(),$user_id);
		}
		return;
	}
	public function getContentChildren($recursive = true)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		$rows =  $table->fetchAll($table->select()->where('appid = ?',$this->getAppId())
											->where('item_id = ?',$this->getItemId())
											->where('active = 1'));
		$result = array();
		foreach($rows as $row)
		{
			$doc = Documents::getDocument($row->content_id,false);
				if($doc && $doc->isActive())
					$result[] = $doc;
		}
		return $result;
	}
	/**
	 * Remove content from category, this does not delete the contents themeselves.
	 * It simply removes the relationship
	 * @param array|int $content_ids
	 * @return null
	 */
	public function removeContents($content_ids)
	{
		if(!is_array($content_ids))$content_ids = array($content_ids);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$table2 = new Zend_Db_Table(array('name'=>PrecurioTableConstants::APP_DOCUMENTS));
		$id = $this->id;
		$appid = $this->getAppId();
		$item_id = $this->getItemId();
		foreach($content_ids as $content_id)
		{
			$table->delete("content_id = $content_id and category_id = $id");
			$table2->update(array('active'=>0),"item_id = $item_id AND appid = '$appid' AND content_id = $content_id");
		}
		return;
	}
	public function isPublic()
	{
		return true;
	}

}
?>