<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once('user/models/UserUtil.php');
require_once('user/models/vo/UserTag.php');
class Link extends Zend_Db_Table_Row_Abstract
{
	protected $_activity_id;
	public function getId()
	{
		return $this->id;
	}
	public function getTitle()
	{
		return $this->title;
	}
	public function getUrl()
	{
		$this->url = trim($this->url);
		if(empty($this->url) || $this->url == "#" )return '#';
		if(strtolower(substr($this->url,0,4)) != 'http')
		{
			$baseUrl =  Zend_Controller_Front::getInstance()->getBaseUrl();
			if(strtolower(substr($this->url,0,1)) == '/')
				$this->url = $baseUrl.$this->url;
			else
				$this->url = 'http://'.$this->url;
		}
		return $this->url;
	}
	public function getDescription()
	{
		return $this->description;
	}
	public function getTarget()
	{
		return $this->target;
	}
	public function getDate()
	{
		return new Precurio_Date($this->date_created);
	}
	public function getActivityId()
	{
		$type = Precurio_Activity::SHARED_LINK;
		$tr = Zend_Registry::get('Zend_Translate');
		if($this->_activity_id == 0)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY));
			$all = $table->fetchAll($table->select()
						->where('activity_id= ? ',$this->id)
						->where('type = ?',$type));
			if($all->count() < 1)//the is an application logic error
			{
				return 0;
				//delete the item
				//$this->do_delete();
				//throw new Precurio_Exception($tr->translate(PrecurioStrings::APPLICATION_LOGIC_ERROR).$this->id,Precurio_Exception::EXCEPTION_APPLICATION_ERROR,1001);
			}
			$this->_activity_id =  $all->current()->id;
		}

		return $this->_activity_id;
	}
	/**
	 * Get user who submited the link
	 * @return User
	 */
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}

	/**
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getTags()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS, 'rowClass'=>'UserTag'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);

		$select = $select->distinct()
						->from(array('a' => PrecurioTableConstants::USER_TAGS))
						->join(array('b' => PrecurioTableConstants::TAGS),'a.tag_id = b.id',array('title'))
						->where('item_id = ?',$this->getId())
						->where('type = ?',UserTag::TYPE_LINK)
						->where('active = 1')
						->order('a.id desc');

		return $table->fetchAll($select);
	}
	/**
	 * Enter description here ...
	 * @param string|UserTag $tag
	 */
	public function addTag($tag)
	{
		return UserTag::createNew($tag, Precurio_Session::getCurrentUserId(), $this->id,UserTag::TYPE_LINK);
	}

	/**
	 * Update link info
	 * @param array $data - post data
	 * @return Link
	 */
	public function update($data)
	{
		unset($data['id']);
		$tags = $data['tags'];
		unset($data['tags']);
		$tr = Zend_Registry::get('Zend_Translate');
		$this->setFromArray($data);
		$this->save();
		//now take care of tag changes
		$oldTags = Precurio_Utils::getSecondLevelArray($this->getTags()->toArray(),'title');
		$tags = explode(",",$tags);

		function fn(&$i){$i = strtolower(trim($i));return true;}
		array_walk($tags, 'fn');

		$newTags = array_diff($tags,$oldTags);
		$removedTags = array_diff($oldTags,$tags);

		if(count($newTags))
		{
			$newTags = array_unique($newTags);
			foreach($newTags as $tag)
				$this->addTag($tag);
		}

		if(count($removedTags))
		{
			$removedTags = array_unique($removedTags);
			foreach($removedTags as $tag)
				UserTag::remove($tag,Precurio_Session::getCurrentUserId(), $this->id,UserTag::TYPE_LINK);
		}
		return $this;
	}
	/**
	 *  Deletes the link and its tags, always use this method to delete links.
	 */
	public function do_delete()
	{
		$this->active = 0;
		$this->save();
		//now delete tags

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_TAGS));
		$id = $this->id;$type = UserTag::TYPE_LINK;
		$table->update(array('active'=>0),"item_id = $id AND type = '$type'");
	}
	public function __toString()
	{
		return $this->getTitle();
	}
}
?>