<?php
require_once ('document/models/vo/Document.php');
require_once ('document/models/Folders.php');
require_once ('document/models/FolderHistory.php');
class Documents {

	/**
	 * Get all documents uploaded by the user, shared directly with the user and public documents
	 * @param int $user_id
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public static function getAll($user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
		->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id')
		->joinLeft(array('c' => PrecurioTableConstants::SHARED_CONTENTS),'a.id = c.content_id',array())
		->where('a.active = 1')
		->where('a.is_public = 1 OR a.user_id = ? OR c.user_id = ?',$user_id,$user_id);

		$rows = $table->fetchAll($select);

		return $rows;
	}
	/**
	 * Gets a document from its content id. To get a document from its own ID use Document::get().
	 * @param $content_id int -Id of the content
	 * @return Document
	 */
	public static function getDocument($content_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
						->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id')
						->where('a.id = ?',$content_id);

		$rows = $table->fetchAll($select);
		$c = $rows->count();
		$tr = Zend_Registry::get('Zend_Translate');
		if($c == 0)
			throw new Precurio_Exception($tr->translate(PrecurioStrings::INVALIDCONTENT),Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		$doc = $rows->current() ;
		return $doc;
	}
	/**
	 * Get documents to be displayed in the browser view
	 * @param array|string $type - An array of valid types to return.
	 */
	public static function getBrowserDocs($type=null)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
			->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
			->where('a.is_public = 1')
			->order('b.date_created DESC');
		$rows = $table->fetchAll($select);
		if(empty($type))
			return $rows;
		if(is_string($type))
			$type = array($type);
		$temp = array();
		foreach($rows as $document)
		{
			if(in_array(strtolower($document->getType()),$type))
				$temp[] = $document;
		}
		return $temp;
	}
	/**
	 * @param number $limit - Limit the number of documents (default is 5)
	 * @param number $user_id - Get only documents by a specified user (default is null)
	 * @return array
	 */
	public static function getRecent($limit=5,$user_id=0)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Document'));

		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
						->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.id = b.content_id',Document::$requiredDocumentProp)
						->where('a.active = 1')
						->where('a.is_site = 0')
						->order('b.last_modified desc');
		if($user_id)
			$select = $select->where('a.user_id = ?',$user_id);
		$rows = $table->fetchAll($select);
		$documents = array();
		foreach($rows as $document)
		{
			if(count($documents) >= $limit)break;
			if($document->canAccess(Precurio_Session::getCurrentUserId()) && !$document->isFromOtherModule())
			{
				$documents[] = $document;
			}
		}
		return $documents;
	}

	/**
	 * Creates a new document
	 * @param array $data
	 * @param Folder $folder
	 * @return int - Id of created document
	 */
	public static function createNew($data,$folder)
	{
		$filename = $data['file'];
		$root = Zend_Registry::get('root');
		$filePath = $root.'/public/'.Content::PATH_TMP.$filename;
		$fileFn = new Precurio_FileFn();

		if($fp = fopen($filePath,'rb'))
		{
			$file_content = fread($fp,filesize($filePath));
			fclose($fp);

			try {
				$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DOCUMENTS));
				$row = $table->createRow(array(
					'content_id'=>-1,
					'file_name'=>$fileFn->getFileTitle($filename),
					'file_type'=>$fileFn->getFileExt($filename),
					'file_size'=>filesize($filePath),
					'file_author'=>$fileFn->getFileOwner($filePath),
					'file_date_created'=>filemtime($filePath),
					'file_content'=>$file_content,
					'active'=>1,
					'date_created'=>$data['date_created']
				));
				$document_id = $row->save();
			}
			catch(Exception $e)
			{
				$log = Zend_Registry::get('log');
				$log->err($e);
				throw $e;
				return;
			}

			//document creation successful
			//create content
			$ext = strtolower($fileFn->getFileExt($filename));
			$params = array(
				'title'=>$filename,
				'user_id'=>$data['user_id'],
				'is_document'=>1,
				'date_created'=>$data['date_created'],
				'active'=>1,
				'is_photo'=>(in_array($ext, array("png","jpg","jpeg","bmp","gif")) ? 1 : 0),
				'is_public'=>$folder->isPublic()
			);
			if($params['is_photo'])
			{
				$params['image_path'] = Content::PATH_THUMBNAILS.$filename;
			}
			$params = array_merge($data,$params);
			$content_id = Content::createNew($params,false);

			//update content_id for document
			$row->content_id = $content_id;
			$row->save();

			//now insert document into folder.
			$folder->addContents(array($content_id));//add to folder

			//if document belongs to a another module, make sure there is a
			//content to special category mapping.
			/**
			 * From Precurio 4, other modules should implement there own special folder
			 * which will be passed to this function

			if($data['parent_id'] <= RootFolder::SPECIAL_ID_HELPDESK)
			{
				$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
				$table->insert(array(
					'category_id'=>$data['parent_id'],
					'content_id'=>$content_id,
					'user_id'=>$data['user_id'],
					'date_created'=>$data['date_created'],
					'active'=>1
				));
			}
			 */
			//do not trigger activity if document was uploaded in another module. That module will trigger it's own activity
			if($folder->getId() > RootFolder::SPECIAL_ID_HELPDESK)
				Precurio_Activity::create(Document::APPID,Document::ACTIVITY_NEW,$document_id,$data['user_id']);

			//add activity feed to team rooms. (this is achieved by passing -2 to $onlyNotifyId)
			$groups = $folder->getGroups();
			foreach ($groups as $group)
				Precurio_Activity::create(Document::APPID,Document::ACTIVITY_NEW,$document_id,$data['user_id'],null,-2,$group->id);

			//delete the file
			unlink($filePath);
			return $document_id;
		}
		else
			echo "Invalid file";print_r($data);

	}
}

?>