<?php
/**
 * IndexController
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once ('cms/models/MyContents.php');
require_once ('document/models/Folders.php');
require_once ('document/models/FolderHistory.php');
require_once ('document/models/Documents.php');
require_once ('document/models/vo/RootFolder.php');
require_once ("team/models/vo/TeamRootFolder.php");
require_once ("team/models/vo/TeamDocument.php");
class Document_IndexController extends Zend_Controller_Action
{

	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/document/');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/document/');
	}
	/**
     * The default action - show the home page
     */
    public function indexAction ()
    {
    	Precurio_Session::getLicense()->validate();
		$this->view->folder = new RootFolder();
		$history = FolderHistory::get();
		$history->clear();
    }
	/**
	 * This action will also be called by any module that needs the "add document" functionality.
	 * If this action is called by another module, the c_id parameter will be set to a
	 * special id. e.g. helpdesk module will set c_id to RootFolder::SPECIAL_ID_HELPDESK.
	 * Once the c_id parameter is set to indicate that this call is from another module,
	 * then the 'id' parameter will not be the document_id, instead it will be the id of the
	 * module item. e.g. the helpdesk request id.
	 * Using the 'id' parameter instead of  creating another parameter serves only one
	 * purpose; the view will automatically be switched to basic upload mode.
	 */
	public function newAction()
    {
    	$this->_helper->layout->disableLayout();

    	$document_id = $this->getRequest()->getParam('id',0);//if it is a re-upload

    	$category_id = $this->getRequest()->getParam('c_id');
    	$access_type = $this->getRequest()->getParam('access');

    	$folder = empty($category_id) ? new RootFolder($access_type) : Folder::get($category_id);
    	$this->view->folder = $folder;
    	$this->view->group_id = $this->getRequest()->getParam("t_id",0);//set from within a team room
    	$this->renderScript("new_file.phtml");
    }
	public function renewAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->id = $this->getRequest()->getParam('id',0);//if it is a re-upload
    	$this->view->document = Document::get($this->view->id);
		$this->view->parent_id = $this->getRequest()->getParam('c_id',0);//parameter unnecessary for a reupload
		$this->view->access_type = $this->getRequest()->getParam('access',0);//parameter unnecessary for a reupload
		$this->view->group_id = $this->getRequest()->getParam("t_id",0);//set from within a team room
		$this->renderScript('new_file_version.phtml');
    }
    public function editdetailAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->id = $this->getRequest()->getParam('id',0);//if it is a re-upload
    	$this->view->document = Document::get($this->view->id);
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified');
			$this->renderScript('invalid.phtml');
			return;
		}
    	if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You cannot edit document details, only the document author can do this.');
			$this->renderScript('invalid.phtml');
			return;
		}
    }
	public function moveAction()
    {
		$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only move documents created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->view->d_id = $this->getRequest()->getParam('d_id','0');//will be set if we are currently view the document details
		$this->renderScript('move_document.phtml');
    }
    public function deleteAction()
    {
		$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only delete documents created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$c_id = $this->getRequest()->getParam('c_id',0);
		if(empty($c_id))
		{
			$history = FolderHistory::get();
			$folder = $history->getMostRecent();
			if(!empty($folder))
				$c_id = $folder->getId();
		}
		$this->view->parent_id = $c_id;
		$this->renderScript('delete_file.phtml');
    }
	public function optionsAction ()
    {
   	 	$this->_helper->layout->disableLayout();
    	$this->view->id = $this->getRequest()->getParam('id');
    	$option = $this->getRequest()->getParam('tab','general');
    	$this->view->tab = $this->getRequest()->getParam('tab','general');
    	$this->view->document = Document::get($this->view->id);
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified');
			$this->renderScript('invalid.phtml');
			return;
		}
		switch($option)
		{
			case 'access':
				$this->renderScript('view_history.phtml');
				return;
			break;
			case 'version':
				$this->renderScript('version_history.phtml');
				return;
			break;
			case 'password':
				$this->renderScript('password_document.phtml');
				return;
			break;
		}
    }
    public function emailAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!$this->view->document->canShare(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You have no email access to this document.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->renderScript('email_document.phtml');
    }
    public function descriptionAction()
    {
        $this->_helper->layout->disableLayout();
        $this->view->document = Document::get($this->getRequest()->getParam('id',0));
        if(empty($this->view->document))
        {
            $this->view->reason = $this->view->translate('Invalid Document Specified.');
            $this->renderScript('invalid.phtml');
            return;
        }
        if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
        {
            $this->view->reason = $this->view->translate('You cannot modify this document.');
            $this->renderScript('invalid.phtml');
            return;
        }
        $this->renderScript('edit_description.phtml');
    }
	public function lockAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!($this->view->document->canModify(Precurio_Session::getCurrentUserId()) || UserUtil::isAllowed('admin_index')))
		{
			$this->view->reason = $this->view->translate("You don't have enough permission to lock this document.");
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->renderScript('lock_document.phtml');
    }
	public function checkoutAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate("You don't have enough permission to check-out this document.");
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->renderScript('checkout_document.phtml');
    }
	/**
     * called to share content with group.
     */
    public function groupshareAction()
    {
		$this->_helper->layout->disableLayout();
		$id = $this->getRequest()->getParam('id',0);

		$this->view->document = Document::get($id);
   		if(empty($this->view->document))
		{
			$this->view->reason = $this->view->translate('Invalid Document Specified');
			$this->renderScript('invalid.phtml');
			return;
		}
    	if(!$this->view->document->canShare(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only share documents created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}

    }
    /**
     * Handle ajax document upload.
     * All document upload in Precurio 4 is now ajax.
     *
     */
    public function ajaxuploadAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();

    	require_once 'others/qqFileUploader.php';

    	$uploader = new qqFileUploader();

    	// Specify the list of valid extensions, ex. array("jpeg", "xml", "bmp")
    	$uploader->allowedExtensions = array();

    	// Specify the input name set in the javascript.
    	$uploader->inputName = 'qqfile';

    	// Call handleUpload() with the name of the folder, relative to PHP's getcwd()
    	$result = $uploader->handleUpload(Precurio_Upload::checkDir(Content::PATH_TMP));

    	//resize images
    	$filename = $uploader->getName();
    	$ext = strtolower(substr(strrchr($filename, "."), 1));
    	$image_extensions_allowed = array('jpg', 'jpeg', 'png');
    	if(in_array($ext, $image_extensions_allowed))
    	{
    		$upload = new Precurio_Upload();

    		$upload->setMaxWidth(Content::WIDTH_LARGE);
    		$upload->imgResize($filename,Content::PATH_TMP, Content::WIDTH_LARGE,true,Content::PATH_PHOTOS);

    		$upload->setMaxWidth(Content::WIDTH_THUMBNAIL);
    		$upload->imgResize($filename,Content::PATH_TMP, Content::WIDTH_THUMBNAIL,true,Content::PATH_THUMBNAILS,true);

    		$upload->setMaxWidth(Content::WIDTH_ICON);
    		$upload->imgResize($filename,Content::PATH_TMP, Content::WIDTH_ICON,true,Content::PATH_ICONS,true);
    	}

    	// To return a name used for uploaded file you can use the following line.
    	$result['uploadName'] = $uploader->getUploadName();
    	$result['size'] = Document::formatSize($uploader->getSize());

    	header("Content-Type: text/plain");
    	echo json_encode($result);
    }
    /**
     * This action is only used by the upload new version feature.
     * Every other document upload uses ajaxuploadAction
     * @version 4
     */
    public function uploadAction()
    {
		$params = $this->getRequest()->getPost();
		$upload = new Precurio_Upload;
		$files = $upload->uploadFile(Content::PATH_TMP,false);//don't encode file name

		$params['file'] = $files['document']; //'document' is the name of the html file control

    	if(isset($params['id']))
    	{
    		$document_id = $params['id'];
    		unset($params['id']);
    	}

		if(!empty($document_id))
		{
			if(empty($params['major']))
				$params['major'] = 0;
			if(empty($params['notes']))
				$params['notes'] = "";
			$document = (isset($params['group_id']) && $params['group_id']) ? TeamDocument::get($document_id, $params['group_id']) : Document::get($document_id);
			$document->updateContent($params['file'],$params['major'],$params['notes']);
		}

		$this->_redirect($document->getUrl());
    }
	public function downloadAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$content_id = $this->getRequest()->getParam('c_id');
		$document = Documents::getDocument($content_id);
		if(!$document->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}
		$version = $this->getRequest()->getParam('v',0);
		$document = Document::getVersion($document->getId(), $version);

		$password = $document->isPassworded();
		$password2 = $this->getRequest()->getParam('password','');

		if($password == md5($password2) || $password == false)
			$document->download(Precurio_Session::getCurrentUserId());
		else
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);

	}
 	public function passwordedAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id',0));
    	$this->view->access = $this->getRequest()->getParam('access','download');
    	$this->view->version = $this->getRequest()->getParam('v','0');
    	$this->renderScript("enter_password.phtml");
    }
    /**
     * @version 4
     * action to share document with group and users
     */
    public function shareAction()
    {
    	$this->_helper->layout->disableLayout();
    	$id = $this->getRequest()->getParam('id');
    	$document = Document::get($id);
    	if(!$document->canShare(Precurio_Session::getCurrentUserId()))
    	{
    		$this->view->reason = $this->view->translate('You cannot share this document.');
    		$this->renderScript('invalid.phtml');
    		return;
    	}
    	$this->view->document = $document;
    }
    public function renameAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->document = Document::get($this->getRequest()->getParam('id'));
    	if(!$this->view->document->canModify(Precurio_Session::getCurrentUserId()))
    	{
    		$this->view->reason = $this->view->translate('You can only rename documents created by you.');
    		$this->renderScript('invalid.phtml');
    		return;
    	}
    	$this->renderScript('rename_file.phtml');
    }
	public function submitAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$params = $this->getRequest()->getPost();
		$form = $params['form'];unset($params['form']);

		switch($form)
		{
			case 'new':

				unset($params['id']);
				if($params['parent_id'] > 0 )
				{
					$folder = Folder::get($params['parent_id']);
				}
				elseif($params['parent_id'] == 0 )
				{
					if(isset($params['group_id']) && $params['group_id'])
						$folder = new TeamRootFolder($params['group_id']);
					else
						$folder = new RootFolder($params['access_type']);
				}
				else
				{
					//one of them special folders
					$object = Precurio_Registry::getObject($params['appid'],$params['item_id'],"",isset($params['group_id']));
					$folder = $object->getFolder();
				}

				foreach($params['files'] as $filename)
				{
					$params['file'] = $filename;
					Documents::createNew($params,$folder);
					//delete the file
					$file = Precurio_Upload::checkDir(Content::PATH_TMP).$filename;
					@unlink($file);
				}
				return;
			case 'details':
				$document = Document::get($params['id']);
				if($document)
				{
					$document->updateDetails($params['doc_info'],$params['keywords'],$params['is_public']);
				}
				return;
			case 'rename':
				$document = Document::get($params['id']);
				if($document)
				{
					$document->rename($params['title']);
				}
				return;
			case 'move':
			case 'copy':
				$document = Document::get($params['id']);
				$folder = Folder::get($params['parent_id']);
				if($folder)
				{
					$folder->addContents(array($document->getContentId()));
					if($form == 'move')
					{
						$oldFolder = Folder::get($params['old_parent_id']);
						if($oldFolder)$oldFolder->removeContents(array($document->getContentId()));
					}
				}
				return;

			case 'delete':
				$document = Document::get($params['id']);
				if($document)
					$document->do_delete($params['parent_id'],$params['force']);
				return;
			case 'groupshare':
				$document = Document::get($params['id']);
				if($document)
				{
					$document->groupShare($params['ids']);
				}
				return;
			case 'email':
				$document = Document::get($params['id']);
				if($document)
				{
					$document->email($params['emails'],$params['subject'],$params['msg']);
				}
				return;
			case 'lock':
				$document = Document::get($params['id']);
				if($document)
				{
					if($params['lock'])
						$document->lock();
					else
						$document->unlock();
				}
				return;
			case 'password':
				$document = Document::get($params['id']);
				if($document)
				{
					if($params['set'])
						$document->setPassword($params['password']);
					else
						$document->removePassword();
				}
				return;
			case 'validate_password':
				$document = Document::get($params['id']);
				if($document)
				{
					$password = $document->isPassworded();
					if($password == md5($params['password']))
						echo Zend_Json::encode(array('valid'=>1,'password'=>$params['password']));
					else
						echo Zend_Json::encode(array('valid'=>0));
				}

				return;
			case 'checkout':
				$document = Document::get($params['id']);
				if($document)
				{
					if($params['check_out'])
						$document->checkOut();
					else
						$document->cancelCheckOut();
				}
				return;
			case 'revert':
				$document = Document::get($params['id']);
				if($document)
				{
					if($params['version'])
						$document->setCurrentVersion($params['version']);
				}
				return;
			case 'description':
			    $document = Document::get($params['id']);
			    if($document)
			    {
			        $document->updateDetails($params['msg'],(isset($params['keywords']) ? $params['keywords'] : null));
			    }
			    return;
		}
	}
	public function recentAction()
	{

	}
	public function viewAction()
	{
		if($this->getRequest()->isXmlHttpRequest())
    		$this->_helper->layout->disableLayout();
		$id = $this->getRequest()->getParam('id');
		$document = Document::get($id);
		if(empty($document) || !$document->isActive())
		{
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::MISSINGCONTENT),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
		}
		if(!$document->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$document->viewed(Precurio_Session::getCurrentUserId());

		$this->view->document = $document;

		$ns = new Zend_Session_Namespace('temp');
		$ns->id = $document->getContentId();
		$ns->selectedUsers = $document->getSharedUsers();//array
		$ns->selectLabel = $this->view->translate("Share document with:");

		$this->renderScript('templates/document.phtml');
	}
	public function searchdataAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$tr = Zend_Registry::get('Zend_Translate');
		$label = $tr->translate("Uploaded by {1}.");

		$documents = Documents::getAll(Precurio_Session::getCurrentUserId());

		$results = array();
		foreach($documents as $item)
		{
			$obj = new stdClass();
			$obj->id  = $item->getId();
			$obj->title = $item->getTitle()."<span style='display:none'>".$item->keyword."</span>";
			$obj->label = getLocalizedString($label,$item->getUser(),$item->getDateCreated());
			$obj->url = $item->getUrl();
			$results[] = $obj;
		}
		echo json_encode($results);
	}
	public function preDispatch()
	{

    	$ns = new Zend_Session_Namespace('temp');
		$ns->callback = $this->getRequest()->getBaseUrl()."/cms/user/share";//needed for the user select dialog
		$ns->selectedUsers = null;//clear the user select dialog.
	}
}
?>