<?php
/**
 * RootController
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once ('document/models/Folders.php');
require_once ('document/models/FolderHistory.php');
require_once ('document/models/Documents.php');
require_once ('document/models/vo/RootFolder.php');
class Document_CategoryController extends Zend_Controller_Action
{
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/document/');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/document/');
	}
	public function indexAction ()
    {
		$this->_forward('root');
    }
    public function rootAction ()
    {
		$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_C);
    }
    public function viewAction()
    {
    	if($this->getRequest()->isXmlHttpRequest())
    	{
    		$this->_helper->layout->disableLayout();
    	}


    	$category_id = $this->getRequest()->getParam('id');
    	$category = Folder::get($category_id);
    	if($category == null)
    	{
    		throw new Precurio_Exception($this->view->translate('Invalid Action'),Precurio_Exception::EXCEPTION_INVALID_USER_ACTION);
    	}
    	if(!$category->active)
    	{
    		throw new Precurio_Exception($this->view->translate('Folder has been removed.'),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
    	}
    	if(!$category->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception($this->view->translate('You do not have permission to view this folder'),Precurio_Exception::EXCEPTION_NO_ACCESS);
		}
		$this->view->category = $category;
    	if($category != null)
		{
			$ns = new Zend_Session_Namespace('temp');
			$ns->id = $category->getId();
			$ns->selectedUsers = $category->getSharedUsers();//array
			$ns->selectLabel = $this->view->translate("Share folder with:");
		}
		$history = FolderHistory::get();
		$history->add($category_id);
    }
	public function publicAction()
    {
    	if($this->getRequest()->isXmlHttpRequest())
    		$this->_helper->layout->disableLayout();
    	$this->view->category = new RootFolder(Category::ACCESS_PUBLIC);
    	$history = Zend_Registry::get(FolderHistory::BROWSE_HISTORY);
		$history->add(RootFolder::SPECIAL_ID_PUBLIC,$this->getRequest()->isXmlHttpRequest());
		$this->render('view');
    }
    public function privateAction()
    {
    	if($this->getRequest()->isXmlHttpRequest())
    		$this->_helper->layout->disableLayout();
    	$this->view->category = new RootFolder(Category::ACCESS_PRIVATE);
    	$history = Zend_Registry::get(FolderHistory::BROWSE_HISTORY);
		$history->add(RootFolder::SPECIAL_ID_PRIVATE,$this->getRequest()->isXmlHttpRequest());
		$this->render('view');
    }
	public function newAction()
    {
    	$this->_helper->layout->disableLayout();
    	$id = $this->getRequest()->getParam('id');
		$access_type = $this->getRequest()->getParam('access');

    	$folder = empty($id) ? new RootFolder($access_type) : Folder::get($id);
		$this->view->category = $folder;
		$this->view->folder = $folder;//version 4
		$this->view->group_id = $this->getRequest()->getParam("t_id",0);//set from within a team room
    }
    /**
     * @version 4
     * action to share folder with group and users
     */
    public function shareAction()
    {
    	$this->_helper->layout->disableLayout();
    	$id = $this->getRequest()->getParam('id');
    	$folder = Folder::get($id);
    	if(!$folder->canModify(Precurio_Session::getCurrentUserId()))
    	{
    	    $this->view->reason = $this->view->translate('You can only share folders created by you.');
    	    $this->renderScript('invalid.phtml');
    	    return;
    	}
    	$this->view->category = $folder;
    }
    /**
     * Called when you click "Done" on the user select component
     */
    public function usershareAction()
    {
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$selected_ids = $this->getRequest()->getParam('users');
		$selected_ids = explode(",",$selected_ids);
		$id = array_shift($selected_ids);

		$contents = new MyContents();
		$category = Folder::get($id);
		$category->setSharedUsers($selected_ids);

		$user_ids = $category->getSharedUsers();
		$ns = new Zend_Session_Namespace('temp');
		$ns->selectedUsers = $user_ids;//array
    }
    /**
     * called to share category with group.
     */
    public function groupshareAction()
    {
		$this->_helper->layout->disableLayout();
		$id = $this->getRequest()->getParam('id',0);

		$this->view->category = Category::getCategory($id);
   		if(empty($this->view->category))
		{
			$this->view->reason = $this->view->translate('Cannot share a root folder or deleted folder.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->view->c_id = $this->getRequest()->getParam('c_id',0);

    }
	public function renameAction()
    {
		$this->_helper->layout->disableLayout();
		$this->view->category = Folder::get($this->getRequest()->getParam('id'));
		if(empty($this->view->category))
		{
			$this->view->reason = $this->view->translate('Cannot rename a root folder or deleted folder.');
			$this->renderScript('invalid.phtml');
			return;
		}
		if(!$this->view->category->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only rename folders created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}
		//c_id here means current category id. This is used by the pop-up to determine
		//This is necessary because the user can rename by opening or not opening to folder
		$this->view->c_id = $this->getRequest()->getParam('c_id','0');
    }
	public function moveAction()
    {
		$this->_helper->layout->disableLayout();
    	$this->view->category = Folder::get($this->getRequest()->getParam('id'));
    	if(empty($this->view->category))
		{
			$this->view->reason = $this->view->translate('Cannot move a root folder or deleted folder.');
			$this->renderScript('invalid.phtml');
			return;
		}
   		if(!$this->view->category->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only move folders created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->view->c_id = $this->getRequest()->getParam('c_id','0');//@see renameAction()
		$this->renderScript('move_folder.phtml');
    }
    public function lockAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->view->category = Folder::get($this->getRequest()->getParam('id'));
    	if(empty($this->view->category))
    	{
    		$this->view->reason = $this->view->translate('Cannot lock a root folder or deleted folder.');
    		$this->renderScript('invalid.phtml');
    		return;
    	}
    	if(!$this->view->category->canModify(Precurio_Session::getCurrentUserId()))
    	{
    		$this->view->reason = $this->view->translate('You cannot lock this folder.');
    		$this->renderScript('invalid.phtml');
    		return;
    	}
    	$this->view->c_id = $this->getRequest()->getParam('c_id','0');
    	$this->renderScript('lock_folder.phtml');
    }
    public function deleteAction()
    {
		$this->_helper->layout->disableLayout();
    	$this->view->category = Folder::get($this->getRequest()->getParam('id'));
   		if(empty($this->view->category))
		{
			$this->view->reason = $this->view->translate('Cannot delete a root folder or deleted folder.');
			$this->renderScript('invalid.phtml');
			return;
		}
    	if(!$this->view->category->canModify(Precurio_Session::getCurrentUserId()))
		{
			$this->view->reason = $this->view->translate('You can only delete folders created by you.');
			$this->renderScript('invalid.phtml');
			return;
		}
		$this->view->c_id = $this->getRequest()->getParam('c_id','0');//@see renameAction()
    }
	public function submitAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$params = $this->getRequest()->getPost();
		$form = $this->getRequest()->getParam('form');unset($params['form']);
		switch($form)
		{
			case 'new':
				if(empty($params['title']))return;
				Folders::createNew($params);
				return;

			case 'rename':
				if(empty($params['title']))return;
				$folder = Folder::get($params['id']);
				if($folder)
					$folder->update($params);
				return;
			case 'lock':
				$folder = Folder::get($params['id']);
				if($folder)
					$folder->update(array('is_locked'=>1));
				return;
			case 'unlock':
				$folder = Folder::get($params['id']);
				if($folder)
					$folder->update(array('is_locked'=>0));
				return;
			case 'move':
			case 'copy':
				if($params['parent_id'] < 1)//copying to a root folder
				{
					$params['access_type'] = RootFolder::getAccessTypeFromSpecialId($params['parent_id']);
					$params['parent_id'] = 0;
				}
				else
				{
					$parent = Folder::get($params['parent_id']);
					if($parent)
					{
						//folder should inherit access type from new parent
						$params['access_type'] = $parent->access_type;
					}
				}
				$folder = Folder::get($params['id']);
				if($folder)
				{
					$id = $form == 'copy' ? $folder->createCopy($params) : $folder->update($params);
				}
				return;

			case 'delete':
				$folder = Folder::get($params['id']);
				if($folder)
					$folder->do_delete($params['force']);
				return;
			case 'share'://Action called when user shares. Works for users, groups.
		    	$data = $params['data'];
		    	$id = $params['id'];
		    	if(empty($id))return;
		    	$folder = Folder::get($id);
		    	$folder->setSharedUsers($data['user']);
		    	$folder->groupShare($data['group']);
		    	if(empty($data['user']) && empty($data['group']))
		    		echo 'alert("'.$this->view->translate('You have successfully disabled share for this folder').'");';
		    	else
		    		echo 'alert("'.$this->view->translate('You have successfully shared this folder').'");';
				return;

		}
	}
    public function preDispatch()
    {
    	if(Zend_Registry::isRegistered(FolderHistory::BROWSE_HISTORY))
    	{
    		$history = Zend_Registry::get(FolderHistory::BROWSE_HISTORY);
    	}
    	else
    	{
    		$history = new FolderHistory();
    		if(!isset($history->history))
    			$history->history = array();
    	}
    	$ns = new Zend_Session_Namespace('temp');
		$ns->callback = $this->getRequest()->getBaseUrl()."/document/category/usershare";//needed for the user select dialog
		$ns->selectedUsers = null;//clear the user select dialog.
    }
}
?>