<?php

/**
 * IndexController
 *
 * @author
 * @version
 */

require_once 'Zend/Controller/Action.php';
require_once 'discussion/models/vo/Discussion.php';
require_once 'discussion/models/vo/DiscussionCategory.php';
class Discussion_IndexController extends Zend_Controller_Action {
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
	    
	    $page = $this->getRequest()->getParam('page',1);
	    $limit = 10;
		$this->view->categories = DiscussionCategory::getAll(Precurio_Session::getCurrentUserId(),$limit,$page,$count);
	    $this->view->pageCount = $limit; $this->view->cpage = $page;  $this->view->totalCount = $count;
	    
	    
		$this->renderScript("templates/discussions.phtml");
	}
	public function viewAction()
	{
		$id = $this->getRequest()->getParam('id');
		$discussion = Discussion::get($id);
		if(empty($discussion) || !$discussion->canAccess(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		if(!$discussion->isActive())
		{
			$this->_redirect($discussion->getCategory()->getUrl());
		}
		$this->view->discussion  = $discussion;
		Precurio_Activity::create(Discussion::APPID,Discussion::ACTIVITY_VIEW,$id,Precurio_Session::getCurrentUserId());
	}
	/**
	 *Display create discussion form
	 */
	public function addAction()
	{
		$category_id = $this->getRequest()->getParam('c_id');
		$category = DiscussionCategory::get($category_id);

		$this->view->category = $category;
	}
	/**
	 * Action called on submit create new discussion
	 */
	public function submitAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$time = Precurio_Date::now()->getTimestamp();
		$user_id = Precurio_Session::getCurrentUserId();
		$params['message'] = trim($params['message']);
		$data = array('category_id'=>$params['category_id'],'creator_user_id'=>$user_id,'title'=>$params['subject'],'message'=>$params['message'],'date_created'=>$time,'last_updated'=>$time,'active'=>1);

		$discussion = Discussion::createNew($data);

		foreach($params['user_ids'] as $user_id)
		{
			$discussion->addUser($user_id);
		}

		$this->_redirect($discussion->getUrl());
	}
	public function updateAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();

		$discussion = Discussion::get($params['id']);
		if(empty($discussion))return;

		$time = Precurio_Date::now()->getTimestamp();
		$user_id = Precurio_Session::getCurrentUserId();
		if(!$discussion->canAccess($user_id))return;

		switch($params['form'])
		{
			case 'remove_user':
				$discussion->removeUser($params['user_id']);
			break;
			case 'add_user':
				$discussion->addUser($params['user_id']);
			break;
			case 'deactivate':
				$discussion->do_delete();
				return;
			break;
			case 'edit_subject':
				$discussion->changeSubject($params['subject']);
				$this->redirect($discussion->getUrl());
			break;
			case 'comment':
				$discussion->postMessage($user_id,$params['message']);
				$this->redirect($discussion->getUrl());
			break;
		}
	}

	public function searchdataAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$tr = Zend_Registry::get('Zend_Translate');
		$label = $tr->translate("Started by {1}.");

		$discussions = Discussion::getAll(Precurio_Session::getCurrentUserId());

		$results = array();
		foreach($discussions as $item)
		{
			$obj = new stdClass();
			$obj->id  = $item->getId();
			$obj->title = $item->getTitle();
			$obj->label = getLocalizedString($label,$item->getUser());
			$obj->url = $item->getUrl();
			$results[] = $obj;
		}
		echo json_encode($results);
	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/discussion');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/discussion');
	}


}
