<?php
/**
 *
 * @author Brain
 * @version
 */
require_once 'Zend/Loader/PluginLoader.php';
require_once 'Zend/Controller/Action/Helper/Abstract.php';
require_once 'adLDAP.php';
require_once ('user/models/vo/Location.php');
require_once ('user/models/vo/Department.php');
require_once ('user/models/vo/Group.php');
require_once ('user/models/vo/User.php');
require_once ('user/models/UserUtil.php');
/**
 * Active_Directory_Auth Action Helper
 *
 * @uses actionHelper Precurio_Helper
 */
class Precurio_Helper_LdapAuth extends Zend_Controller_Action_Helper_Abstract {
	/**
	 * @var Zend_Loader_PluginLoader
	 */
	public $pluginLoader;
	/**
	 * @var Zend_db active connection to database
	 */
	protected $_db;
	protected $_authAdapter;


	private $_errorCode;
	private $_errorMsg;
	/**
	 * @var User - user being authenticated, null is authentication fails
	 */
	private $_user;
	/**
	 * Constructor: initialize plugin loader
	 *
	 * @return void
	 */
	public function init(){
		//create a new db connection if you don't want to authenticate from application database
		$this->_db = Zend_Registry::get('db');

	}
	public function __construct() {
		$this->pluginLoader = new Zend_Loader_PluginLoader ( );
	}
	/**
	 * @param string $username - LDAP user to validate
	 * @param string $password - Valid passowrd
	 * @param boolean $ssoEnabled - If SSO is enabled, the user is validated irrespective of password.
	 * @throws Exception
	 * @return boolean
	 */
	public function validate($username,$password,$ssoEnabled=false)
	{
	    if(empty($username))
	    {
	        throw new Exception("Unable to validate, no username");
	        return false;
	    }
		$config = Zend_Registry::get('config');
		$ldap_config = $config->ldap;$ldapServers = $ldap_config->ldap;	$ldapServers = $ldapServers->toArray();
		
		$this->_authAdapter = new Zend_Auth_Adapter_Ldap($ldapServers,$username,$password);
		$result = $this->_authAdapter->authenticate();
		
		$messages = $result->getMessages();//log messages when precurio logging is impelemented
		$log = Zend_Registry::get('log');
		foreach($messages as $i=>$message)
		{
			if($i== 1)continue;
			$message = str_replace("\n", "\n ", $message);
			$log->info("Ldap: $i: $message");
		}
		
		if($result->isValid() || $ssoEnabled)
		{
			$server1 = $ldapServers['server1'];
			$email = $this->getUserEmail($username);
			/*
			 * For some systems, email is different from identity. So if email does not exist,
			 * let's check the AUTH table before assuming this is a total new user
            */ 
			 
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
		    $userVo = $table->fetchRow($table->select()->where('active = ? ',1)
															->where('email = ? ',$email));
			
			if($userVo == null) //if user cannot be found by email check AUTH table
			{
			    $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
			    $auth = $table->fetchRow($table->select()->where('identity = ? ',$username)
			        ->order('id DESC'));
			    if($auth)// if user was found by username, get user.
			    {
			        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS,'rowClass'=>'User'));
			        $userVo = $table->fetchRow($table->select()->where('user_id = ? ',$auth->id));
			    }
			}
			
			
			
		    if($userVo == null)//this is a new user
		    {
		        if($ssoEnabled)
		            throw new Precurio_Exception(PrecurioStrings::SESSIONEXPIRED,Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
		    	$userVo = $this->importUser($username,$password,$server1);
		    }

			try
			{
				if(!$userVo->isActive())
				{
				    throw new Exception($this->translate(PrecurioStrings::USERDEACTIVATED), 1111);
				}
				//always update group membership
				$this->updateGroupMemberships($userVo,$server1);

				//always update user information (including password, so IT can decide to switch from
				// active directory authentication to database authentication)
				$this->updateUser($username, $password, $userVo->user_id);

				$this->_user = new stdClass();
				$this->_user->id = $userVo->user_id;
				$this->_user->identity = $username;
				$this->_user->credential = $password;
			}
			catch(Exception $e)
			{
				$log->err($e);
				$this->_errorCode = 1234;
				return false;
			}


		}
		$this->_errorCode = $ssoEnabled ? Zend_Auth_Result::SUCCESS : $result->getCode();
		return $result->isValid();
	}

	public function getCode()
	{
		return $this->_errorCode;
	}
	public function getErrorMessage()
	{
		switch($this->_errorCode)
		{
			case Zend_Auth_Result::FAILURE_CREDENTIAL_INVALID:
				$this->_errorMsg = $this->translate("Invalid Password");
				break;
			case Zend_Auth_Result::FAILURE_IDENTITY_NOT_FOUND:
				$this->_errorMsg = $this->translate("Invalid user");
				break;
			case Zend_Auth_Result::FAILURE_IDENTITY_AMBIGUOUS:
				$this->_errorMsg = $this->translate("Invalid user");
				break;
			case Zend_Auth_Result::FAILURE_UNCATEGORIZED:
				$this->_errorMsg = $this->translate("Login Attempt Failed, please try again");
				break;
			case Zend_Auth_Result::FAILURE:
				$this->_errorMsg = $this->translate("Login Attempt Failed, please try again");
				break;
			case 1234:
				$this->_errorMsg = $this->translate("There was a problem retrieving your details from the directory");
				break;
		}
		return $this->_errorMsg;
	}
	/**
	 * Imports user details from active directory and creates user on Precuroo
	 * @param $username string
	 * @param $password string
	 * @return User
	 */
	private function importUser($username,$password)
	{
		$data = array();
		$date_created = Precurio_Date::now()->getTimestamp();

		$data['identity'] = $username;
		$data['credential'] = md5($password);
		$data['password'] = md5($password);
		$data['date_created'] = $date_created;

		$userData = $this->fetchUserInfo($username);

		$data = array_merge($data,$userData);
		$userVo = UserUtil::createUser($data);

		return $userVo;
	}

	/**
	 * Update Precurio with user information from Active Directory.
	 * This function is called by validate(..) i.e. each time a user logs in
	 * @param string $username
	 * @param string $password
	 * @param int $user_id
	 * @return User
	 */
	private function updateUser($username,$password,$user_id)
	{
		$data = array();
		$date_created = Precurio_Date::now()->getTimestamp();

		$data['identity'] = $username;
		$data['credential'] = md5($password);
		$data['password'] = md5($password);

		$userData = $this->fetchUserInfo($username);

		$data = array_merge($data,$userData);

		$user = UserUtil::getUser($user_id);
		$user->update($data);

		return $user;
	}
	/**
	 * Fetch user information from Active Directory
	 * @param  string $username
	 * @throws Precurio_Exception
	 * @return array
	 */
	private function fetchUserInfo($username)
	{
	    //If authentication is not valid (happens only during SSO), use the alternate function
	    if(!$this->_authAdapter->authenticate()->isValid())
	        return $this->fetchUserInfoSSO($username);
	    
		$data = array();

		try
		{
			$temp = Zend_Registry::get('config');
			$ldap_config = $temp->ldap;
			$ldapServers = $ldap_config->ldap;
			$ldapServers = $ldapServers->toArray();
			$server1 = $ldapServers['server1'];

			$userInfo = $this->_authAdapter->getAccountObject(array("givenName","sn","mail","company","department","location","title","mobile","telephoneNumber"));

			$data['email'] = $userInfo->mail;
			if(Precurio_Utils::isNull($data['email']))//this should not happen normally
				$data['email'] = stripos($username,'@') === false ? $username.$temp->domain : $username;

			$data['username'] = stripos($username,'@') === false ? $username : substr($username,0,strpos($username,'@'));

			$data['first_name'] = $userInfo->givenname;
			if(isset($userInfo->sn))
				$data['last_name'] = $userInfo->sn;
			if(isset($userInfo->telephonenumber))
				$data['work_phone'] = $userInfo->telephonenumber;
			if(isset($userInfo->mobile))
				$data['mobile_phone'] = $userInfo->mobile;
			if(isset($userInfo->title))
				$data['job_title'] = $userInfo->title;
			if(isset($userInfo->company))
				$data['company'] = $userInfo->company;

			if(Precurio_Utils::isNull($data['first_name']))
				$data['first_name'] = $username;

			if(isset($userInfo->location))
			{
				$data['location_id'] = Location::getLocationId($userInfo->location);
				if($data['location_id'] == 0 || empty($data['location_id']))unset($data['location_id']);
			}

			if(isset($userInfo->department))
			{
				$data['department_id'] = Department::getDepartmentId($userInfo->department);
				if($data['department_id'] == 0 || empty($data['department_id']))unset($data['department_id']);
			}
			
			return $data;

		}
		catch(Precurio_Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
			//throw license related exception
			if($e->type == Precurio_Exception::EXCEPTION_EXPIRED_LICENSE || $e->type == Precurio_Exception::EXCEPTION_LICENSE_FULL)
			{
				throw $e;
			}
		}
		catch (Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
		}
		return array();
	}
	/**
	 * Fetch user information  from Active Directory as a third party. Used during sso auth.
	 * Function is ONLY called by fetchUserInfo
	 * @param  string $username
	 * @throws Precurio_Exception
	 * @return array
	 */
	private function fetchUserInfoSSO($username)
	{
	    /**
	     * Empty function for now. We do need to get this details, since users are now forced to sign-in the first time, 
	     * before SSO takes effect.
	     */
	    
	    return array();
	}
	/**
	 * @param $user User
	 * @param $config array
	 * @return void
	 */
	private function updateGroupMemberships($user,$config)
	{
		if($user == null)throw new Exception();
		try
		{
			$config = Zend_Registry::get('config');
			$ldap = $config->ldap->ldap->server1;
			$adLdap = new adLDAP(array(
			'account_suffix'=>"@".$ldap->accountDomainName,
			'base_dn'=>$ldap->baseDn,
			'ad_username'=>$ldap->username,
			'ad_password'=>$ldap->password,
			'use_ssl'=>$ldap->useSsl,
			'domain_controllers'=>array($ldap->host)
			));
			$adUserGroups = $adLdap->user_groups($user->getUsername(),false);

			$userGroups = $this->getGroupNames($user->id);

			$adNotDb = array_diff($adUserGroups,$userGroups);
			$dbNotAd = array_diff($userGroups,$adUserGroups);

			$this->userIsNoMoreMember($user->id,$dbNotAd);
			$this->userIsNowMember($user->id,$adNotDb);

		}
		catch (Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
		}
	}
	/**
	 * Get all groups (roles) the user belong to on Precurio as an array of group names
	 * @version 4 changelog
	 *
	 * Previously we fetched all groups, thereby making the AD responsible for all group managment.
	 * With TeamRooms feature in version 4, this is no longer viable.
	 *
	 * Now, we are only fetching groups that are roles and not default roles. Thereby making the AD
	 * responsibe for user role management alone. So the admin is now free to create departments, locations
	 * and users are free to create teams.
	 *
	 * @param int $user_id
	 * @param boolean $includeDepartments - An extra feature. Sometimes AD may be responsible for Department Information too.
	 * @return array
	 */
	private function getGroupNames($user_id,$includeDepartments=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::GROUPS),array('title'))
						->join(array('b' => PrecurioTableConstants::USER_GROUPS),'a.id = b.group_id',array())
						->where('b.user_id = ? ',$user_id)
						->where('is_default = 0');
		if($includeDepartments)
			$select = $select->where('is_role = 1 OR is_department = 1');
		else
			$select = $select->where('is_role = 1');

		$select = $select->order('a.id DESC');
		$all = $table->fetchAll($select)->toArray();
		return Precurio_Utils::getSecondLevelArray($all,'title');
	}

	/**
	 * Removes user from memberships of groups
	 * @param $user_id int
	 * @param $groups array of group names to which user no longer belongs
	 * @return void
	 */
	private function userIsNoMoreMember($user_id,$groups)
	{
		if(count($groups) == 0)return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_GROUPS));
		$where = "";
		foreach($groups as $groupName)
		{
			$id = Group::getGroupIdFromName($groupName);
			if($id == 0)continue;//group does not exist, this can only happen if group was deleted from database
			$where = "user_id = {$user_id} AND group_id = {$id}";
			$table->delete($where);
		}
		return;
	}
	/**
	 * Adds user to memberships of groups
	 * @param $user_id int
	 * @param $groups array of group names
	 * @return void
	 */
	private function userIsNowMember($user_id,$groups)
	{
		if(count($groups) == 0)return;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_GROUPS));
		$data = array();
		$data['user_id'] = $user_id;
		$data['date_created'] = Precurio_Date::now()->getTimestamp();
		foreach($groups as $groupName)
		{
			$id = Group::getGroupIdFromName($groupName);
			if($id == 0)//this is a new group, add it to the database
			{
					$log = Zend_Registry::get('log');
					$log->warn("New group '$groupName' imported from active directory, please edit group information locally.");
					$groupTable = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS));
					$id = $groupTable->insert(array(
						'title'=>$groupName,
						'description'=>'',
						'parent_id'=>0,
						'is_location'=>0,
						'is_role'=>0,
						'is_department'=>0,
						'active'=>1,
						'date_created'=>Precurio_Date::now()->getTimestamp()
					));
			}
			$group = UserUtil::getGroup($id);
			if($group->containsMember($user_id))//is user is already a member, skip. This is likely to happen alot because of the new method of fetching only roles
				continue;
			$data['group_id'] = $id;
			$row = $table->createRow($data);
			$row->save();
		}
		return;
	}
	public function getUser()
	{
		if($this->_errorCode != Zend_Auth_Result::SUCCESS)
			return null;
		return $this->_user;
	}

	/**
	 * This will get the user email from the active directory
	 * @param string $username
	 * @return string
	 */
	private function getUserEmail($username)
	{
	    try
	    {
	        $log = Zend_Registry::get('log');
	        
	        $config = Zend_Registry::get('config');
	        $ldap = $config->ldap->ldap->server1;
	        $adLdap = new adLDAP(array(
	            'account_suffix'=>"@".$ldap->accountDomainName,
	            'base_dn'=>$ldap->baseDn,
	            'ad_username'=>$ldap->username,
	            'ad_password'=>$ldap->password,
	            'use_ssl'=>$ldap->useSsl,
	            'domain_controllers'=>array($ldap->host)
	        ));
	        $userInfo = $adLdap->user_info($username, array("samaccountname","mail","displayname"));
	        //log result
	        $userInfoStr = print_r($userInfo,true);
	        $log = Zend_Registry::get('log');
	        $log->info("LDAP User Info $username: $userInfoStr");
	        //get email
	        
            $email =  isset($userInfo[0]["mail"]) ? $userInfo[0]["mail"][0] : "" ;
	    
    	    if($email)
    		{
    		    return $email;
    		}
    		else
    		{
    		    $log->err("Email Information for [$username] could not be fetched from Active Directory");
    		    //else mail property not set, just append username to email domain, but make sure the username does not contain the domain name
    		    $username = stripos($username,'\\') === false ? $username : substr($username,strpos($username,'\\')+1);
    		    return stripos($username, "@") === false ?  $username.$config->domain : $username;
    		}
	    
	    }
	    catch (Exception $e)
	    {
	        $log->err($e);
	    }
	}
	/**
	 * Strategy pattern: call helper as broker method
	 */
	public function direct($username,$password) {
		return $this->validate($username,$password);
	}

	public function translate($str)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		return $tr->translate($str);
	}
}

